/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitorExtPerf;
import com.blixx.ext.IMonitorSubmitter;
import com.blixx.ext.IPerfLog;
import com.blixx.ext.PerfDoubleMetric;
import com.blixx.ext.PerfStringMetric;
import com.sun.net.ssl.HostnameVerifier;
import com.sun.net.ssl.internal.ssl.Provider;
import com.sun.net.ssl.internal.www.protocol.https.HttpsURLConnectionOldImpl;
import com.trilead.ssh2.crypto.Base64;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import javax.net.SocketFactory;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import sun.net.www.protocol.http.HttpURLConnection;

public class HTTPMonitor
implements IMonitorExtPerf {
    public String[] m_urlStr = null;
    public String m_monitor = "";
    public URL m_url;
    public String m_reason = null;
    public long m_responseTime = -1L;
    public String m_output = null;
    public IMonitorSubmitter m_submitter = null;
    public int m_responseCode = -6;
    public long m_connectTime = 0L;
    public IPerfLog m_perfSubmitter = null;
    public double m_speed = -1.0;
    public long m_interval = 300000L;
    public static final String BROWSER_EMU = "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10.4; en-US; rv:1.9.2.2) Gecko/20100316 Firefox/3.6.2";

    public static HTTPMonitor getInstance(String monitor, String[] url) {
        HTTPMonitor mon = new HTTPMonitor();
        mon.m_urlStr = url;
        mon.m_monitor = monitor;
        return mon;
    }

    public int isAvailable(URL url) {
        int responseCode;
        block17: {
            this.m_speed = -1.0;
            responseCode = -6;
            int timeout = 10000;
            try {
                long start = System.currentTimeMillis();
                if (!url.getProtocol().toLowerCase().startsWith("https")) {
                    URLConnection conn = url.openConnection();
                    if (conn instanceof HttpURLConnection) {
                        HttpURLConnection connection = (HttpURLConnection)conn;
                        if (url.getUserInfo() != null) {
                            String encodedUserPass = new String(Base64.encode(url.getUserInfo().getBytes()));
                            connection.setAuthenticationProperty("Authorization", " Basic " + encodedUserPass);
                        }
                        connection.setConnectTimeout(timeout);
                        connection.setRequestProperty("User-Agent", BROWSER_EMU);
                        connection.connect();
                        connection.setReadTimeout(timeout);
                        this.m_connectTime = System.currentTimeMillis() - start;
                        start = System.currentTimeMillis();
                        responseCode = connection.getResponseCode();
                        try {
                            InputStream inputStream = connection.getInputStream();
                            this.read(inputStream);
                            connection.disconnect();
                        }
                        catch (Throwable inputStream) {
                            // empty catch block
                        }
                        this.m_responseTime = System.currentTimeMillis() - start;
                        this.m_reason = connection.getResponseMessage();
                        break block17;
                    }
                    responseCode = -2;
                    break block17;
                }
                HTTPMonitor.trustAllHttpsCertificates();
                URLConnection conn = url.openConnection();
                if (conn instanceof HttpsURLConnection) {
                    HttpsURLConnection connection = (HttpsURLConnection)conn;
                    if (url.getUserInfo() != null) {
                        String encodedUserPass = new String(Base64.encode(url.getUserInfo().getBytes()));
                        connection.setRequestProperty("Authorization", " Basic " + encodedUserPass);
                    }
                    connection.setConnectTimeout(timeout);
                    connection.setRequestProperty("User-Agent", BROWSER_EMU);
                    connection.connect();
                    connection.setReadTimeout(timeout);
                    this.m_connectTime = System.currentTimeMillis() - start;
                    start = System.currentTimeMillis();
                    responseCode = connection.getResponseCode();
                    try {
                        InputStream inputStream = connection.getInputStream();
                        this.read(inputStream);
                        connection.disconnect();
                    }
                    catch (Throwable inputStream) {
                        // empty catch block
                    }
                    this.m_responseTime = System.currentTimeMillis() - start;
                    this.m_reason = connection.getResponseMessage();
                    break block17;
                }
                if (conn instanceof HttpsURLConnectionOldImpl) {
                    HttpsURLConnectionOldImpl connection = (HttpsURLConnectionOldImpl)conn;
                    if (url.getUserInfo() != null) {
                        String encodedUserPass = new String(Base64.encode(url.getUserInfo().getBytes()));
                        connection.setRequestProperty("Authorization", " Basic " + encodedUserPass);
                    }
                    connection.setConnectTimeout(timeout);
                    connection.setRequestProperty("User-Agent", BROWSER_EMU);
                    connection.connect();
                    connection.setReadTimeout(timeout);
                    this.m_connectTime = System.currentTimeMillis() - start;
                    start = System.currentTimeMillis();
                    responseCode = connection.getResponseCode();
                    try {
                        InputStream inputStream = connection.getInputStream();
                        this.read(inputStream);
                        connection.disconnect();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.m_responseTime = System.currentTimeMillis() - start;
                    this.m_reason = connection.getResponseMessage();
                    break block17;
                }
                throw new RuntimeException("Unsupported Https implementation class: " + conn.getClass().getCanonicalName());
            }
            catch (UnknownHostException e) {
                this.m_reason = "Unresolvabe hostname: " + e.getMessage();
                responseCode = -6;
            }
            catch (IOException e) {
                this.m_reason = e.getMessage();
                responseCode = -5;
            }
            catch (Throwable e) {
                this.m_reason = e.getMessage();
                responseCode = -5;
            }
        }
        return responseCode;
    }

    protected void read(InputStream inputStream) throws IOException {
        byte[] arr = new byte[16000];
        StringBuffer sb = new StringBuffer();
        int len = -1;
        int totalBytes = 0;
        long start = System.currentTimeMillis();
        while ((len = inputStream.read(arr)) != -1) {
            sb.append(new String(arr, 0, len));
            totalBytes += len;
        }
        try {
            inputStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.m_speed = (long)(totalBytes * 1000) / (System.currentTimeMillis() - start + 1L) / 1024L;
        this.m_output = sb.toString();
        this.m_output = this.m_output.replace("<br>", "<br>\n");
        this.m_output = this.m_output.replace("<p", "\n<p");
        this.m_output = this.m_output.replace("<h", "\n<h");
        this.m_output = this.m_output.replace("<ta", "\n<ta");
        this.m_output = this.m_output.replace("<tr", "\n<tr");
        this.m_output = this.m_output.replace("<di", "\n<di");
    }

    public String runMonitor() {
        for (int i = 0; i < this.m_urlStr.length; ++i) {
            URL url = null;
            try {
                url = new URL(this.m_urlStr[i]);
            }
            catch (MalformedURLException e) {
                this.m_submitter.submitMonitorValue(this.m_monitor, -2.0, this.m_urlStr[i], null);
                continue;
            }
            int res = this.isAvailable(url);
            HashMap<String, Object> opVars = new HashMap<String, Object>();
            if (this.m_reason != null) {
                opVars.put("error", this.m_reason);
            }
            opVars.put("rtime", this.m_responseTime);
            opVars.put("ctime", this.m_connectTime);
            long totalTime = this.m_responseTime + this.m_connectTime;
            if (res < 0) {
                totalTime = -1L;
                this.m_connectTime = -1L;
                this.m_responseTime = -1L;
            }
            opVars.put("time", totalTime);
            String page = url.getPath();
            String urlWOlp = url.getProtocol() + "://" + url.getHost() + page;
            opVars.put("url", urlWOlp);
            opVars.put("host", url.getHost());
            opVars.put("page", page);
            this.m_submitter.submitMonitorValue(this.m_monitor, (double)res, urlWOlp + ":AVAILABILITY", opVars);
            this.m_submitter.submitMonitorValue(this.m_monitor, (double)totalTime, urlWOlp + ":TIME", opVars);
            if (this.m_perfSubmitter == null) continue;
            ArrayList<Object> perfMetrics = new ArrayList<Object>();
            perfMetrics.add(new PerfStringMetric("HOST", url.getHost()));
            int port = url.getPort();
            if (port == -1) {
                port = 80;
            }
            perfMetrics.add(new PerfDoubleMetric("PORT", (double)port));
            perfMetrics.add(new PerfStringMetric("OBJECT", page));
            perfMetrics.add(new PerfDoubleMetric("RTIME", (double)this.m_responseTime));
            perfMetrics.add(new PerfDoubleMetric("CTIME", (double)this.m_connectTime));
            perfMetrics.add(new PerfDoubleMetric("TTIME", (double)totalTime));
            perfMetrics.add(new PerfDoubleMetric("SPEED", this.m_speed));
            perfMetrics.add(new PerfDoubleMetric("STATUS", (double)res));
            this.m_perfSubmitter.submitPerfRow("IS_HTTP", System.currentTimeMillis(), perfMetrics);
        }
        return null;
    }

    public void stop() {
    }

    public void setMessageSubmitter(IMessage submitter) {
    }

    public static SocketFactory trustAllHttpsCertificates() throws Exception {
        System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
        Security.addProvider((java.security.Provider)new Provider());
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public boolean isServerTrusted(X509Certificate[] certs) {
                return true;
            }

            public boolean isClientTrusted(X509Certificate[] certs) {
                return true;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        }};
        SSLContext sc = SSLContext.getInstance("TLS");
        sc.init(new X509KeyManager[0], trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HttpsURLConnectionOldImpl.setDefaultSSLSocketFactory((SSLSocketFactory)sc.getSocketFactory());
        javax.net.ssl.HostnameVerifier hv = new javax.net.ssl.HostnameVerifier(){

            @Override
            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }

            public boolean verify(String urlHostname, String certHostname) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hv);
        HttpsURLConnectionOldImpl.setDefaultHostnameVerifier((HostnameVerifier)new HostnameVerifier(){

            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }

            public boolean verify(String urlHostname, String certHostname) {
                return true;
            }
        });
        return sc.getSocketFactory();
    }

    public void setInterval(long ms) {
        this.m_interval = ms;
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
        this.m_submitter = submitter;
    }

    public void setPerfSubmitter(IPerfLog submitter) {
        this.m_perfSubmitter = submitter;
    }
}

