/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.agent.monitors.HTTPMonitor;
import com.blixx.agent.util.NullMonSubmitter;
import com.blixx.agent.util.NullMsgSubmitter;
import com.blixx.ext.IMonitorExtPerf;
import com.sun.net.ssl.internal.www.protocol.https.HttpsURLConnectionOldImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import javax.net.ssl.HttpsURLConnection;
import sun.net.www.protocol.http.HttpURLConnection;

public class HTTPProxyMonitor
extends HTTPMonitor
implements IMonitorExtPerf {
    public String m_proxyStr = null;
    public Proxy m_proxy = null;
    private static String hostS;
    private static int port;

    public static HTTPProxyMonitor getInstance(String monitor, String[] url) {
        HTTPProxyMonitor mon = new HTTPProxyMonitor();
        mon.m_proxyStr = url[0].toLowerCase();
        if (mon.m_proxyStr.startsWith("proxy:")) {
            hostS = null;
            port = 0;
            try {
                mon.m_proxyStr = mon.m_proxyStr.substring("proxy:".length());
                hostS = mon.m_proxyStr.substring(0, mon.m_proxyStr.lastIndexOf(58));
                String portS = mon.m_proxyStr.substring(mon.m_proxyStr.lastIndexOf(58) + 1);
                port = Integer.parseInt(portS);
            }
            catch (Throwable e) {
                throw new RuntimeException("First parameter must be proxy:<hostname>:<port>");
            }
        } else {
            throw new RuntimeException("First parameter must be proxy:<hostname>:<port>");
        }
        mon.m_urlStr = new String[url.length - 1];
        System.arraycopy(url, 1, mon.m_urlStr, 0, url.length - 1);
        mon.m_monitor = monitor;
        return mon;
    }

    @Override
    public int isAvailable(URL url) {
        int i;
        block16: {
            this.m_speed = -1.0;
            i = -6;
            int timeout = 10000;
            try {
                InetAddress address = InetAddress.getByName(hostS);
                InetSocketAddress sa = new InetSocketAddress(address, port);
                this.m_proxy = new Proxy(Proxy.Type.HTTP, sa);
            }
            catch (Throwable e1) {
                this.m_reason = "Unresolved Proxy host: " + hostS + " " + e1.getClass().getName();
                i = -5;
                return i;
            }
            try {
                long start = System.currentTimeMillis();
                if (!url.getProtocol().toLowerCase().startsWith("https")) {
                    URLConnection conn = url.openConnection(this.m_proxy);
                    if (conn instanceof HttpURLConnection) {
                        HttpURLConnection connection = (HttpURLConnection)conn;
                        connection.setConnectTimeout(timeout);
                        connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10.4; en-US; rv:1.9.2.2) Gecko/20100316 Firefox/3.6.2");
                        connection.connect();
                        connection.setReadTimeout(timeout);
                        this.m_connectTime = System.currentTimeMillis() - start;
                        start = System.currentTimeMillis();
                        i = connection.getResponseCode();
                        try {
                            InputStream inputStream = connection.getInputStream();
                            this.read(inputStream);
                            connection.disconnect();
                        }
                        catch (Throwable inputStream) {
                            // empty catch block
                        }
                        this.m_responseTime = System.currentTimeMillis() - start;
                        break block16;
                    }
                    i = -2;
                    break block16;
                }
                HTTPProxyMonitor.trustAllHttpsCertificates();
                URLConnection conn = url.openConnection(this.m_proxy);
                if (conn instanceof HttpsURLConnection) {
                    HttpsURLConnection connection = (HttpsURLConnection)conn;
                    connection.setConnectTimeout(timeout);
                    connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10.4; en-US; rv:1.9.2.2) Gecko/20100316 Firefox/3.6.2");
                    connection.connect();
                    connection.setReadTimeout(timeout);
                    this.m_connectTime = System.currentTimeMillis() - start;
                    start = System.currentTimeMillis();
                    i = connection.getResponseCode();
                    try {
                        InputStream inputStream = connection.getInputStream();
                        this.read(inputStream);
                        connection.disconnect();
                    }
                    catch (Throwable inputStream) {
                        // empty catch block
                    }
                    this.m_responseTime = System.currentTimeMillis() - start;
                    break block16;
                }
                if (conn instanceof HttpsURLConnectionOldImpl) {
                    HttpsURLConnectionOldImpl connection = (HttpsURLConnectionOldImpl)conn;
                    connection.setConnectTimeout(timeout);
                    connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10.4; en-US; rv:1.9.2.2) Gecko/20100316 Firefox/3.6.2");
                    connection.connect();
                    connection.setReadTimeout(timeout);
                    this.m_connectTime = System.currentTimeMillis() - start;
                    start = System.currentTimeMillis();
                    i = connection.getResponseCode();
                    try {
                        InputStream inputStream = connection.getInputStream();
                        this.read(inputStream);
                        connection.disconnect();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.m_responseTime = System.currentTimeMillis() - start;
                    break block16;
                }
                throw new RuntimeException("Unsupported Https implementation class: " + conn.getClass().getCanonicalName());
            }
            catch (UnknownHostException e) {
                this.m_reason = e.getMessage();
                i = -6;
            }
            catch (IOException e) {
                this.m_reason = e.getMessage();
                i = -5;
            }
            catch (Throwable e) {
                this.m_reason = e.getMessage();
                i = -5;
            }
        }
        return i;
    }

    public static void main(String[] args) {
        HTTPProxyMonitor m = HTTPProxyMonitor.getInstance("monitorName", new String[]{"proxy:xxxxpersonhider.info:80", "http://www.apple.com"});
        m.setMessageSubmitter(new NullMsgSubmitter());
        m.setMonitorSubmitter(new NullMonSubmitter());
        m.runMonitor();
    }
}

