/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.agent.monitors.HTTPMonitor;
import com.sun.net.ssl.internal.www.protocol.https.HttpsURLConnectionOldImpl;
import com.trilead.ssh2.crypto.Base64;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLPeerUnverifiedException;
import sun.security.x509.X500Name;

public class HTTPSCertificateCheck
extends HTTPMonitor {
    public static HTTPSCertificateCheck getInstance(String monitor, String[] url) {
        HTTPSCertificateCheck mon = new HTTPSCertificateCheck();
        mon.m_urlStr = url;
        mon.m_monitor = monitor;
        return mon;
    }

    @Override
    public String runMonitor() {
        int timeout = 10000;
        int responseCode = 0;
        for (int i = 0; i < this.m_urlStr.length; ++i) {
            if (!this.m_urlStr[i].toLowerCase().startsWith("https:")) {
                HashMap<String, String> opVars = new HashMap<String, String>();
                opVars.put("ERROR", "HTTPS protocol required");
                opVars.put("URL", this.m_urlStr[i]);
                this.m_submitter.submitMonitorValue(this.m_monitor, -2.0, "ERROR:" + this.m_urlStr[i], opVars);
                continue;
            }
            URL url = null;
            try {
                url = new URL(this.m_urlStr[i]);
            }
            catch (MalformedURLException e) {
                HashMap<String, String> opVars = new HashMap<String, String>();
                opVars.put("ERROR", "MalformedURLException");
                opVars.put("URL", this.m_urlStr[i]);
                this.m_submitter.submitMonitorValue(this.m_monitor, -7.0, "ERROR:" + this.m_urlStr[i], null);
                continue;
            }
            try {
                InputStream inputStream2;
                HashMap<String, String> opVars;
                String encodedUserPass;
                HttpsURLConnection connection;
                HTTPSCertificateCheck.trustAllHttpsCertificates();
                URLConnection conn = url.openConnection();
                if (conn instanceof HttpsURLConnection) {
                    connection = (HttpsURLConnection)conn;
                    if (url.getUserInfo() != null) {
                        encodedUserPass = new String(Base64.encode(url.getUserInfo().getBytes()));
                        connection.setRequestProperty("Authorization", " Basic " + encodedUserPass);
                    }
                    connection.setConnectTimeout(timeout);
                    connection.connect();
                    connection.setReadTimeout(timeout);
                    responseCode = connection.getResponseCode();
                    this.m_reason = connection.getResponseMessage();
                    if (responseCode >= 200) {
                        this.processCertificates(connection.getURL(), connection);
                    } else {
                        opVars = new HashMap<String, String>();
                        opVars.put("ERROR", this.m_reason);
                        opVars.put("URL", this.m_urlStr[i]);
                        this.m_submitter.submitMonitorValue(this.m_monitor, (double)responseCode, "ERROR:" + this.m_urlStr[i], opVars);
                    }
                    try {
                        inputStream2 = connection.getInputStream();
                        this.read(inputStream2);
                        connection.disconnect();
                    }
                    catch (Throwable inputStream2) {}
                    continue;
                }
                if (conn instanceof HttpsURLConnectionOldImpl) {
                    connection = (HttpsURLConnectionOldImpl)conn;
                    if (url.getUserInfo() != null) {
                        encodedUserPass = new String(Base64.encode(url.getUserInfo().getBytes()));
                        connection.setRequestProperty("Authorization", " Basic " + encodedUserPass);
                    }
                    connection.setConnectTimeout(timeout);
                    connection.connect();
                    connection.setReadTimeout(timeout);
                    responseCode = connection.getResponseCode();
                    this.m_reason = connection.getResponseMessage();
                    if (responseCode >= 200) {
                        this.processCertificates(connection.getURL(), (HttpsURLConnectionOldImpl)connection);
                    } else {
                        opVars = new HashMap();
                        opVars.put("ERROR", this.m_reason);
                        opVars.put("URL", this.m_urlStr[i]);
                        this.m_submitter.submitMonitorValue(this.m_monitor, (double)responseCode, "ERROR:" + this.m_urlStr[i], opVars);
                    }
                    try {
                        inputStream2 = connection.getInputStream();
                        this.read(inputStream2);
                        connection.disconnect();
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                throw new RuntimeException("Unsupported Https implementation class: " + conn.getClass().getCanonicalName());
            }
            catch (Throwable e) {
                RuntimeException re = new RuntimeException(e.getMessage());
                re.setStackTrace(e.getStackTrace());
                throw re;
            }
        }
        return null;
    }

    private void processCertificates(URL url, HttpsURLConnectionOldImpl connection) throws SSLPeerUnverifiedException {
        Certificate[] array = connection.getServerCertificates();
        this._processX509(url, array);
    }

    private void processCertificates(URL url, HttpsURLConnection connection) throws SSLPeerUnverifiedException {
        Certificate[] array = connection.getServerCertificates();
        this._processX509(url, array);
    }

    private void _processX509(URL url, Certificate[] array) {
        boolean isFoundHostCert = false;
        Certificate cert = array[0];
        try {
            X509Certificate x509cert = (X509Certificate)cert;
            Date date = x509cert.getNotAfter();
            Calendar calNow = Calendar.getInstance();
            Calendar expireDate = Calendar.getInstance();
            expireDate.setTime(date);
            long daysToExpire = (expireDate.getTimeInMillis() - calNow.getTimeInMillis()) / 86400000L;
            HashMap<String, Object> opVars = new HashMap<String, Object>();
            opVars.put("URL", url.toString());
            opVars.put("Type", x509cert.getType());
            opVars.put("Version", x509cert.getVersion());
            opVars.put("host", url.getHost());
            X500Name subjectDN = (X500Name)x509cert.getSubjectDN();
            String cn = subjectDN.getCommonName();
            opVars.put("CN", cn);
            if (subjectDN.getOrganizationalUnit() != null) {
                opVars.put("OU", subjectDN.getOrganizationalUnit());
            }
            if (subjectDN.getOrganization() != null) {
                opVars.put("O", subjectDN.getOrganization());
            }
            if (subjectDN.getDomain() != null) {
                opVars.put("D", subjectDN.getDomain());
            }
            if (subjectDN.getCountry() != null) {
                opVars.put("C", subjectDN.getCountry());
            }
            isFoundHostCert = true;
            this.m_submitter.submitMonitorValue(this.m_monitor, (double)daysToExpire, cn, opVars);
        }
        catch (Throwable x509cert) {
            // empty catch block
        }
        if (!isFoundHostCert) {
            HashMap<String, String> opVars = new HashMap<String, String>();
            opVars.put("ERROR", "Valid certificate for this host not found.");
            opVars.put("URL", url.toString());
            opVars.put("host", url.getHost());
            this.m_submitter.submitMonitorValue(this.m_monitor, 2.0, "ERROR:" + url.toString(), opVars);
        }
    }
}

