/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitorExt;
import com.blixx.ext.IMonitorSubmitter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;

public class ICMPMonitor
implements IMonitorExt,
Runnable {
    public String[] m_hostnames = null;
    public String m_monitor = "";
    public long m_connectTime = 0L;
    public IMonitorSubmitter m_submitter = null;

    public static ICMPMonitor getInstance(String monitor, String[] hostnames) {
        ICMPMonitor mon = new ICMPMonitor();
        mon.m_hostnames = hostnames;
        mon.m_monitor = monitor;
        return mon;
    }

    public int isAvailable(String hostname) {
        int i = -6;
        try {
            this.m_connectTime = -1L;
            long dnsStart = System.currentTimeMillis();
            InetAddress addr = InetAddress.getByName(hostname);
            this.m_connectTime = System.currentTimeMillis() - dnsStart;
            long start = System.currentTimeMillis();
            if (addr.isReachable(3000)) {
                long delay = System.currentTimeMillis() - start;
                i = (int)delay;
            } else {
                i = -4;
            }
        }
        catch (UnknownHostException e) {
            i = -6;
        }
        catch (IOException e) {
            i = -5;
        }
        return i;
    }

    public String runMonitor() {
        if (this.m_hostnames != null) {
            for (int i = 0; i < this.m_hostnames.length; ++i) {
                int res = this.isAvailable(this.m_hostnames[i]);
                HashMap<String, String> opts = new HashMap<String, String>();
                opts.put("ctime", "" + this.m_connectTime);
                this.m_submitter.submitMonitorValue(this.m_monitor, (double)res, this.m_hostnames[i], opts);
            }
        }
        return null;
    }

    public void stop() {
    }

    public void setMessageSubmitter(IMessage submitter) {
    }

    @Override
    public void run() {
    }

    public void setInterval(long ms) {
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
        this.m_submitter = submitter;
    }
}

