/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.agent.util.NullMonSubmitter;
import com.blixx.agent.util.Utils;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitorExtPerf;
import com.blixx.ext.IMonitorSubmitter;
import com.blixx.ext.IPerfLog;
import com.blixx.ext.PerfDoubleMetric;
import com.blixx.ext.PerfStringMetric;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;

public class IMAPMonitor
implements IMonitorExtPerf {
    public String[] m_hostnames = null;
    public String m_monitor = "";
    public long m_connectTime = 0L;
    public long m_responseTime = 0L;
    public IMonitorSubmitter m_submitter = null;
    public IPerfLog m_perfSubmitter = null;
    public IMessage m_msgSubmitter = null;
    private static final String MS = "(MESSAGES ";

    public static IMAPMonitor getInstance(String monitor, String[] parameters) {
        IMAPMonitor mon = new IMAPMonitor();
        mon.m_hostnames = parameters;
        mon.m_monitor = monitor;
        return mon;
    }

    public void setPerfSubmitter(IPerfLog submitter) {
        this.m_perfSubmitter = submitter;
    }

    public void setInterval(long ms) {
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
        this.m_submitter = submitter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String runMonitor() {
        for (int i = 0; i < this.m_hostnames.length; ++i) {
            InetAddress addr2;
            int availability = -4;
            double connectTime = -1.0;
            double mails = -1.0;
            String[] args = Utils.split(this.m_hostnames[i]);
            if (args.length != 3) continue;
            String hostname = args[0];
            int port = 143;
            int posC = hostname.indexOf(58);
            if (posC != -1) {
                hostname = args[0].substring(0, posC);
                String portStr = args[0].substring(posC + 1);
                try {
                    port = Integer.parseInt(portStr);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            String user = null;
            String pass = null;
            if (args.length > 1) {
                user = args[1];
                if (args.length > 2) {
                    pass = args[2];
                }
            }
            long start = System.currentTimeMillis();
            HashMap<String, Object> opts = new HashMap<String, Object>();
            opts.put("host", hostname);
            opts.put("user", user);
            Socket socket = null;
            try {
                socket = new Socket();
                socket.connect(new InetSocketAddress(hostname, port));
                socket.setSoTimeout(10000);
                this.m_connectTime = System.currentTimeMillis() - start;
                InputStream is = socket.getInputStream();
                OutputStream os = socket.getOutputStream();
                int len = -1;
                byte[] buff = new byte[512];
                len = is.read(buff);
                if (len > -1) {
                    String answer = new String(buff, 0, len);
                    if (answer.indexOf(" OK ") != -1) {
                        block47: {
                            os.write(("$ LOGIN \"" + user + "\" \"" + pass + "\"\r\n").getBytes());
                            try {
                                len = is.read(buff);
                                answer = new String(buff, 0, len);
                                if (answer.indexOf(" OK ") != -1) {
                                    availability = 5;
                                    try {
                                        os.write("$ STATUS INBOX (messages)\r\n".getBytes());
                                        len = is.read(buff);
                                        answer = new String(buff, 0, len);
                                        if (!answer.contains("$ OK")) break block47;
                                        try {
                                            int b = answer.indexOf(MS) + MS.length();
                                            String nm = answer.substring(b, answer.indexOf(41, b));
                                            mails = Integer.parseInt(nm);
                                            opts.put("mails", mails);
                                            break block47;
                                        }
                                        catch (Throwable b) {
                                        }
                                    }
                                    catch (Throwable b) {}
                                    break block47;
                                }
                                availability = 1;
                            }
                            catch (Throwable e) {
                                availability = 1;
                            }
                        }
                        this.m_responseTime = System.currentTimeMillis() - start - this.m_connectTime;
                    }
                    os.write("$ LOGOUT\r\n".getBytes());
                    len = is.read(buff);
                    answer = new String(buff, 0, len);
                } else {
                    availability = -3;
                }
                long totalTime = this.m_connectTime + this.m_responseTime;
                opts.put("time", totalTime);
                opts.put("ctime", this.m_connectTime);
                opts.put("rtime", this.m_responseTime);
            }
            catch (UnknownHostException e) {
                availability = -6;
            }
            catch (SocketException e) {
                availability = -4;
                try {
                    addr2 = InetAddress.getByName(hostname);
                    if (addr2.isReachable(3000)) {
                        availability = -3;
                    }
                }
                catch (Throwable addr2) {
                    // empty catch block
                }
            }
            catch (SocketTimeoutException e) {
                availability = -4;
                try {
                    addr2 = InetAddress.getByName(hostname);
                    if (addr2.isReachable(3000)) {
                        availability = -3;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            catch (IOException e) {
                availability = -5;
            }
            finally {
                try {
                    socket.close();
                }
                catch (Throwable e) {}
            }
            long totalTime = this.m_connectTime + this.m_responseTime;
            if (availability < 0) {
                totalTime = -1L;
            }
            if (totalTime < 0L) {
                this.m_responseTime = -1L;
                this.m_connectTime = -1L;
            }
            this.m_submitter.submitMonitorValue(this.m_monitor, (double)totalTime, user + "@" + hostname + ":TIME", opts);
            this.m_submitter.submitMonitorValue(this.m_monitor, (double)availability, user + "@" + hostname + ":AVAILABILITY", opts);
            if (this.m_perfSubmitter == null) continue;
            ArrayList<Object> perfMetrics = new ArrayList<Object>();
            perfMetrics.add(new PerfStringMetric("HOST", hostname));
            perfMetrics.add(new PerfDoubleMetric("PORT", (double)port));
            perfMetrics.add(new PerfStringMetric("OBJECT", user));
            perfMetrics.add(new PerfDoubleMetric("RTIME", (double)this.m_responseTime));
            perfMetrics.add(new PerfDoubleMetric("CTIME", (double)this.m_connectTime));
            perfMetrics.add(new PerfDoubleMetric("TTIME", (double)totalTime));
            perfMetrics.add(new PerfDoubleMetric("MAILCOUNT", mails));
            perfMetrics.add(new PerfDoubleMetric("STATUS", (double)availability));
            this.m_perfSubmitter.submitPerfRow("IS_IMAP", System.currentTimeMillis(), perfMetrics);
        }
        return null;
    }

    public void setMessageSubmitter(IMessage submitter) {
        this.m_msgSubmitter = submitter;
    }

    public void stop() {
    }

    public static void main(String[] args) {
        IMAPMonitor pm = IMAPMonitor.getInstance("OK5", new String[]{"sloxsv boris 4boris"});
        pm.setMonitorSubmitter(new NullMonSubmitter());
        pm.runMonitor();
        pm = IMAPMonitor.getInstance("OK-3", new String[]{"xsv1.blixx.de boris 4boris"});
        pm.setMonitorSubmitter(new NullMonSubmitter());
        pm.runMonitor();
        pm = IMAPMonitor.getInstance("LOGIN_FAILED1", new String[]{"sloxsv boris WRONGPASS4boris"});
        pm.setMonitorSubmitter(new NullMonSubmitter());
        pm.runMonitor();
    }
}

