/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.agent.util.NullMonSubmitter;
import com.blixx.agent.util.Utils;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitorExtPerf;
import com.blixx.ext.IMonitorSubmitter;
import com.blixx.ext.IPerfLog;
import com.blixx.ext.PerfDoubleMetric;
import com.blixx.ext.PerfStringMetric;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;

public class LDAPMonitor
implements IMonitorExtPerf {
    public String[] m_hostnames = null;
    public String m_monitor = "";
    public long m_connectTime = 0L;
    public long m_responseTime = 0L;
    public IMonitorSubmitter m_submitter = null;
    public IPerfLog m_perfSubmitter = null;

    public static LDAPMonitor getInstance(String monitor, String[] parameters) {
        LDAPMonitor mon = new LDAPMonitor();
        mon.m_hostnames = parameters;
        mon.m_monitor = monitor;
        mon.getDefaultLdapContextFactory();
        return mon;
    }

    public void setInterval(long ms) {
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
        this.m_submitter = submitter;
    }

    public String runMonitor() {
        for (int i = 0; i < this.m_hostnames.length; ++i) {
            int availability = -4;
            double connectTime = -1.0;
            HashMap<String, String> opts = new HashMap<String, String>();
            String[] args = new String[3];
            String[] split = Utils.split(this.m_hostnames[i]);
            if (split.length > 3) {
                args[0] = split[0];
                args[2] = split[split.length - 1];
                args[1] = "";
                for (int j = 1; j < split.length - 1; ++j) {
                    args[1] = args[1] + split[j] + " ";
                }
                args[1] = args[1].trim();
            } else {
                if (split.length != 3) continue;
                args = split;
            }
            int port = 389;
            String urlLdap = args[0].toLowerCase();
            if (!urlLdap.startsWith("ldap://") && !urlLdap.startsWith("ldaps://")) {
                urlLdap = "ldap://" + urlLdap;
            } else if (urlLdap.startsWith("ldaps://")) {
                port = 636;
            }
            String host = urlLdap;
            try {
                URL url = new URL(urlLdap.replace("ldap://", "http://").replace("ldaps://", "https://"));
                host = url.getHost();
                opts.put("host", host);
                if (url.getPort() != -1) {
                    port = url.getPort();
                }
            }
            catch (Throwable e) {
                opts.put("host", host);
            }
            String user = null;
            String pass = null;
            if (args.length > 1) {
                user = args[1];
                if (args.length > 2) {
                    pass = args[2];
                }
            }
            long start = System.currentTimeMillis();
            try {
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                env.put("java.naming.provider.url", urlLdap);
                if (urlLdap.toLowerCase().startsWith("ldaps:")) {
                    env.put("java.naming.ldap.factory.socket", "com.boom.utils.BoomSSLSocketFactory");
                }
                env.put("java.naming.security.authentication", "simple");
                env.put("java.naming.security.principal", user);
                env.put("java.naming.security.credentials", pass);
                env.put("java.naming.referral", "ignore");
                opts.put("user", user);
                InitialDirContext ctx = new InitialDirContext(env);
                this.m_connectTime = System.currentTimeMillis() - start;
                this.m_responseTime = 0L;
                ctx.close();
                availability = 5;
            }
            catch (AuthenticationException e) {
                availability = 1;
            }
            catch (CommunicationException e) {
                availability = -3;
                Throwable root = e.getRootCause();
                if (root != null && root instanceof UnknownHostException) {
                    availability = -6;
                }
                try {
                    InetAddress addr = InetAddress.getByName(host);
                    if (!addr.isReachable(3000)) {
                        availability = -4;
                    }
                }
                catch (Throwable addr) {
                    // empty catch block
                }
                if (availability == -3) {
                    if (root != null) {
                        opts.put("error", root.getMessage());
                    } else {
                        opts.put("error", e.getMessage());
                    }
                }
            }
            catch (NamingException e) {
                availability = 3;
                opts.put("error", e.getMessage());
            }
            long totalTime = this.m_connectTime + this.m_responseTime;
            if (availability < 0) {
                totalTime = -1L;
            }
            if (totalTime < 0L) {
                this.m_responseTime = -1L;
                this.m_connectTime = -1L;
                totalTime = -1L;
            }
            this.m_submitter.submitMonitorValue(this.m_monitor, (double)totalTime, urlLdap + ":TIME", opts);
            this.m_submitter.submitMonitorValue(this.m_monitor, (double)availability, urlLdap + ":AVAILABILITY", opts);
            if (this.m_perfSubmitter == null) continue;
            ArrayList<Object> perfMetrics = new ArrayList<Object>();
            perfMetrics.add(new PerfStringMetric("HOST", host));
            perfMetrics.add(new PerfDoubleMetric("PORT", (double)port));
            perfMetrics.add(new PerfStringMetric("OBJECT", user));
            perfMetrics.add(new PerfDoubleMetric("RTIME", (double)this.m_responseTime));
            perfMetrics.add(new PerfDoubleMetric("CTIME", (double)this.m_connectTime));
            perfMetrics.add(new PerfDoubleMetric("TTIME", (double)totalTime));
            perfMetrics.add(new PerfDoubleMetric("STATUS", (double)availability));
            this.m_perfSubmitter.submitPerfRow("IS_LDAP", System.currentTimeMillis(), perfMetrics);
        }
        return null;
    }

    public void setMessageSubmitter(IMessage submitter) {
    }

    public void stop() {
    }

    public void setPerfSubmitter(IPerfLog submitter) {
        this.m_perfSubmitter = submitter;
    }

    public String getDefaultLdapContextFactory() {
        String defaultLdapContextFactory = "";
        try {
            String sun = "com.sun.jndi.ldap.LdapCtxFactory";
            Class.forName(sun);
            defaultLdapContextFactory = sun;
        }
        catch (Throwable sun) {
            // empty catch block
        }
        try {
            String apache = "org.apache.harmony.jndi.provider.ldap.LdapContextFactory";
            Class.forName(apache);
            defaultLdapContextFactory = apache;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return defaultLdapContextFactory;
    }

    public static void main(String[] args) {
        LDAPMonitor mon = null;
        mon = LDAPMonitor.getInstance("5==OK", new String[]{"blixxsv2 blixx\\boris Markaba99"});
        mon.setMonitorSubmitter(new NullMonSubmitter());
        mon.runMonitor();
        mon = LDAPMonitor.getInstance("OK", new String[]{"sloxsv boris@blixx.de 4boris"});
        mon.setMonitorSubmitter(new NullMonSubmitter());
        mon.runMonitor();
        System.exit(0);
        mon = LDAPMonitor.getInstance("OK", new String[]{"sloxsv uid=boris, dc=blixx, dc=de 4boris"});
        mon.setMonitorSubmitter(new NullMonSubmitter());
        mon.runMonitor();
        mon = LDAPMonitor.getInstance("OK", new String[]{"blixxsv2 cn=boris,cn=Users,dc=blixx,dc=de Markaba99"});
        mon.setMonitorSubmitter(new NullMonSubmitter());
        mon.runMonitor();
        mon = LDAPMonitor.getInstance("FAILED_name", new String[]{"sloxsv cn=boris,cn=Users,dc=blixx,dc=de 4boris"});
        mon.setMonitorSubmitter(new NullMonSubmitter());
        mon.runMonitor();
        mon = LDAPMonitor.getInstance("FAILED_pass", new String[]{"sloxsv cn=boris,cn=Users,dc=blixx,dc=de 4boris"});
        mon.setMonitorSubmitter(new NullMonSubmitter());
        mon.runMonitor();
        mon = LDAPMonitor.getInstance("UnknownHost", new String[]{"ddddd cn=boris,cn=Users,dc=blixx,dc=de 4boris"});
        mon.setMonitorSubmitter(new NullMonSubmitter());
        mon.runMonitor();
    }
}

