/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.agent.monitors.LogFileAbstract;
import com.blixx.agent.util.Exec;
import com.blixx.agent.util.ExecResult;
import com.blixx.agent.util.NullMonSubmitter;
import com.blixx.agent.util.NullMsgSubmitter;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitor;
import com.blixx.ext.IMonitorExt;
import com.blixx.ext.IMonitorSubmitter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.regex.Pattern;

public class LogFileMonitor
extends LogFileAbstract
implements IMonitorExt {
    protected static final String TYPE_FROMSTART = "FROM_START";
    protected static final String TYPE_REMEMBERLAST = "FROM_LAST";
    protected static final String SOLERROR_DATE_PATTERN = "\\w{3}\\s+\\w{3}\\s\\d{2}\\s\\d{2}:\\d{2}:\\d{2}.*";
    protected static final String TEST_BOOM_PATTERN = "\\d{6}\\s\\d{2}:\\d{2}:\\d{2}.*";
    public static final String LOGERRORFILE_OBJECT = "ERRLOG";
    public String m_filemask = null;
    protected File m_file = null;
    protected long m_position = 0L;
    protected boolean m_isFirst = true;
    protected String m_lineSplit = "\r*\n";
    protected Pattern m_patternSplit = null;
    protected Pattern m_sendPattern = Pattern.compile(".*");
    protected HashMap m_optParams;
    protected String m_exec = null;
    protected String m_type = null;
    protected long m_interval = 60000L;
    protected IMonitorSubmitter m_monitorSubmitter = null;
    protected static int MAXBUFFERSIZE = 65536;

    protected LogFileMonitor(String filepath, String logLinePattern, String sendPattern, String exec, String type) {
        if (filepath == null || filepath.length() == 0) {
            throw new RuntimeException("Path to the file can't be empty");
        }
        if (logLinePattern != null && logLinePattern.length() != 0) {
            this.m_patternSplit = Pattern.compile(logLinePattern);
        }
        if (sendPattern != null && sendPattern.length() != 0) {
            this.m_sendPattern = Pattern.compile(sendPattern, 40);
        }
        this.m_filemask = filepath;
        this.m_file = this.getActualFile(this.m_filemask, true);
        if (this.m_file != null && this.m_file.exists()) {
            if (!this.m_file.canRead()) {
                throw new RuntimeException("File is not readable: " + filepath);
            }
            this.m_position = this.m_file.length();
        }
        this.m_exec = exec;
        this.m_type = type;
    }

    public void setInterval(long ms) {
        this.m_interval = ms;
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
        this.m_monitorSubmitter = submitter;
    }

    public static IMonitor getInstance(String monitorName, String[] parameters) {
        String filepath = null;
        String logLinePattern = null;
        String sendPattern = null;
        String exec = null;
        String type = null;
        try {
            filepath = parameters[0];
            logLinePattern = parameters[1];
            sendPattern = parameters[2];
            type = parameters[3];
            if (type.equalsIgnoreCase(TYPE_FROMSTART) || type.equalsIgnoreCase(TYPE_REMEMBERLAST)) {
                exec = parameters[4];
            } else {
                exec = type;
                type = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        LogFileMonitor imon = new LogFileMonitor(filepath, logLinePattern, sendPattern, exec, type);
        imon.m_monitorName = monitorName;
        imon.m_optParams = new HashMap();
        imon.m_optParams.put("POLICY_NAME", imon.m_monitorName);
        return imon;
    }

    private static String removeStartEndQuotes(String filepath) {
        int last;
        if (filepath.charAt(0) == '\"') {
            filepath = filepath.substring(1);
        }
        if (filepath.charAt(last = filepath.length() - 1) == '\"') {
            filepath = filepath.substring(0, last);
        }
        return filepath;
    }

    private boolean monitorLogfile() {
        boolean isOK;
        block17: {
            isOK = false;
            try {
                File changed = this.getActualFile(this.m_filemask, false);
                if (changed != null) {
                    if (this.m_file == null || !changed.getName().equals(this.m_file.getName())) {
                        try {
                            if (this.m_file != null && this.m_position < this.m_file.length() - 1L) {
                                this.readAndProcess(this.m_file.length());
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.m_position = 0L;
                        this.m_file = changed;
                        this.m_isFirst = false;
                        String canon = this.m_file.getCanonicalPath();
                        try {
                            this.m_optParams.put("LOGFILE", this.m_file.getName());
                            this.m_optParams.put("LOGPATH", this.m_file.getCanonicalPath());
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.m_submitter.sendMessage(null, this.m_monitorName, "LogFileMonitor", canon, "LFM switched to monitor file: " + canon, "normal", new HashMap());
                    }
                    long size = this.m_file.length();
                    if (this.m_type != null && this.m_type.equalsIgnoreCase(TYPE_FROMSTART)) {
                        this.m_position = 0L;
                    } else if (this.m_position > size) {
                        this.m_position = 0L;
                    } else if (this.m_isFirst) {
                        this.m_position = Math.max(0L, size);
                    }
                    this.m_isFirst = false;
                    if (this.m_position < size - 1L) {
                        this.readAndProcess(size);
                    }
                    break block17;
                }
                if (this.m_file != null && changed == null) {
                    this.m_file = null;
                    if (this.m_submitter != null) {
                        this.m_submitter.sendMessage(null, this.m_monitorName, "LogFileMonitor", this.m_filemask, "File(s) not found", "major", new HashMap());
                    }
                }
            }
            catch (Throwable e) {
                this.m_submitter.sendMessage(null, this.m_monitorName, "LogFileMonitor", this.m_filemask, e.getMessage(), "major", new HashMap());
                isOK = false;
            }
        }
        return isOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAndProcess(long size) throws FileNotFoundException, IOException {
        long start = System.currentTimeMillis();
        RandomAccessFile raf = new RandomAccessFile(this.m_file, "r");
        try {
            while (this.m_position < size) {
                int effectiveSize;
                raf.seek(this.m_position);
                Long l = new Long(size - this.m_position);
                int bs = Math.min(MAXBUFFERSIZE, l.intValue());
                byte[] bytes = new byte[bs];
                raf.read(bytes);
                String logs = new String(bytes);
                int lp = logs.lastIndexOf(10);
                if (lp > 0) {
                    logs = logs.substring(0, lp + 1);
                }
                if ((effectiveSize = logs.length()) < 3) {
                    break;
                }
                this.m_position += (long)effectiveSize;
                this.checkBuffer(logs);
                long time = System.currentTimeMillis() - start;
                if (time > this.m_interval / 2L) {
                    this.submitMonValue(100.0 * ((double)this.m_position / (double)size));
                    start = System.currentTimeMillis();
                }
                Thread.yield();
            }
        }
        finally {
            try {
                raf.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public void checkBuffer(String logs) {
        String[] arr_1 = logs.split(this.m_lineSplit);
        StringBuffer tempMSG = null;
        for (int i = 0; i < arr_1.length; ++i) {
            String toTest = arr_1[i];
            if (this.m_patternSplit.matcher(toTest).matches()) {
                if (tempMSG != null) {
                    this.sendMsg(tempMSG.toString());
                }
                tempMSG = new StringBuffer();
                tempMSG.append(toTest);
                continue;
            }
            if (tempMSG == null) continue;
            tempMSG.append("\n").append(toTest);
        }
        if (tempMSG != null) {
            this.sendMsg(tempMSG.toString());
        }
    }

    private void sendMsg(String message) {
        if (this.m_sendPattern != null && !this.m_sendPattern.matcher(message).matches()) {
            return;
        }
        String canonicalPath = "";
        try {
            canonicalPath = this.m_file.getCanonicalPath();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.m_optParams.put("LOGFILE", this.m_file.getName());
            this.m_optParams.put("LOGPATH", this.m_file.getCanonicalPath());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.m_submitter.sendMessage(null, this.m_monitorName, "LogFileMonitor", canonicalPath, message, null, this.m_optParams);
    }

    public String runMonitor() {
        block6: {
            if (this.m_exec != null) {
                Exec ex = new Exec();
                try {
                    File dir = new File("spi");
                    if (!dir.exists()) {
                        dir = new File(".");
                    }
                    ExecResult er = Exec.exec2(this.m_exec, dir, 300);
                    if (er.resultCode != 0) {
                        String output = er.toStringOnError();
                        if (this.m_submitter != null) {
                            this.m_submitter.sendMessage(null, this.m_monitorName, "LogFileMonitor", "", "LogFileMonitor trigger failed " + this.m_exec + "\n" + output, "major", new HashMap());
                        }
                    }
                }
                catch (Throwable e) {
                    if (this.m_submitter == null) break block6;
                    this.m_submitter.sendMessage(null, this.m_monitorName, "LogFileMonitor", "", "LogFileMonitor trigger failed " + this.m_exec + "\n" + e.getMessage(), "major", new HashMap());
                }
            }
        }
        this.monitorLogfile();
        this.submitMonValue(100.0);
        return null;
    }

    private void submitMonValue(double progress) {
        HashMap<String, String> opts = null;
        try {
            String filePath = this.m_file.getCanonicalPath();
            opts = new HashMap<String, String>();
            opts.put("file", filePath);
            try {
                opts.put("LOGFILE", this.m_file.getName());
                opts.put("LOGPATH", filePath);
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.m_monitorSubmitter.submitMonitorValue(this.m_monitorName, progress, this.m_filemask, opts);
    }

    public void stop() {
    }

    public void setMessageSubmitter(IMessage submitter) {
        if (this.m_submitter == submitter) {
            return;
        }
        this.m_submitter = submitter;
        try {
            String canon = this.m_file.getCanonicalPath();
            this.m_submitter.sendMessage(null, this.m_monitorName, "LogFileMonitor", canon, "LFM start to monitor file: " + canon, "normal", new HashMap());
        }
        catch (Throwable e) {
            this.m_file = this.getActualFile(this.m_filemask, true);
        }
    }

    public static void main(String[] args) {
        LogFileMonitor lm = (LogFileMonitor)LogFileMonitor.getInstance("monName", new String[]{"C:\\eclipse-ganymede-SR1\\workspace\\BOOM_SERVER_b20\\TEST_*.log", TEST_BOOM_PATTERN, ".*BT.*", TYPE_FROMSTART});
        lm.setMessageSubmitter(new NullMsgSubmitter());
        lm.setMonitorSubmitter(new NullMonSubmitter());
        while (true) {
            lm.runMonitor();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

