/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.agent.monitors.LogFileAbstract;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogFileTransactionMonitor
extends LogFileAbstract
implements Runnable,
IMonitor {
    protected File m_file = null;
    protected long m_position = 0L;
    public String m_filemask = null;
    protected boolean m_isFirst = true;
    protected String m_lineSplit = "\r*\n";
    protected List<Transaction> m_transactions = new ArrayList<Transaction>();
    protected HashMap m_optParams;

    protected LogFileTransactionMonitor(String filepath) {
        if (filepath == null || filepath.length() == 0) {
            throw new RuntimeException("Path to the file can't be empty");
        }
        this.m_filemask = filepath;
        this.m_file = this.getActualFile(this.m_filemask, true);
        if (this.m_file != null && this.m_file.exists()) {
            if (!this.m_file.canRead()) {
                throw new RuntimeException("File is not readable: " + filepath);
            }
            this.m_position = this.m_file.length();
        }
    }

    public static IMonitor getInstance(String monitorName, String[] parameters) {
        String filepath = null;
        String startPattern = null;
        String endPattern = null;
        String failPattern = null;
        long sec = 0L;
        filepath = parameters[0];
        LogFileTransactionMonitor imon = new LogFileTransactionMonitor(filepath);
        imon.m_monitorName = monitorName;
        imon.m_optParams = new HashMap();
        imon.m_optParams.put("POLICY_NAME", imon.m_monitorName);
        for (int i = 1; i < parameters.length; ++i) {
            startPattern = parameters[i];
            endPattern = parameters[++i];
            failPattern = parameters[++i];
            sec = Long.parseLong(parameters[++i]);
            ++i;
            List<Transaction> list = imon.m_transactions;
            LogFileTransactionMonitor logFileTransactionMonitor = imon;
            logFileTransactionMonitor.getClass();
            list.add(logFileTransactionMonitor.new Transaction(startPattern, endPattern, failPattern, sec));
        }
        return imon;
    }

    public String runMonitor() {
        if (this.m_isFirst) {
            Thread tr = new Thread(this);
            this.m_isFirst = false;
            tr.start();
        }
        return this.m_monitorName + "=0";
    }

    public void setMessageSubmitter(IMessage submitter) {
        if (this.m_submitter == submitter) {
            return;
        }
        this.m_submitter = submitter;
        try {
            String canon = this.m_file.getCanonicalPath();
            this.m_submitter.sendMessage(null, this.m_monitorName, "LogFileMonitor", canon, "LFTM start to monitor file: " + canon, "normal", new HashMap());
        }
        catch (Throwable e) {
            this.m_file = this.getActualFile(this.m_filemask, true);
        }
    }

    public void stop() {
        this.m_isFirst = true;
    }

    @Override
    public void run() {
        while (!this.m_isFirst) {
            try {
                this.monitorLogfile();
            }
            catch (Throwable e1) {
                this.m_submitter.sendMessage(null, null, "MONITOR", "LogFileMonitor", "Error: " + e1.getMessage(), "major", null);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private boolean monitorLogfile() {
        boolean isOK;
        block14: {
            isOK = false;
            try {
                File changed = this.getActualFile(this.m_filemask, false);
                if (changed != null) {
                    long size;
                    if (this.m_file == null || !changed.getName().equals(this.m_file.getName())) {
                        try {
                            if (this.m_file != null && this.m_position < this.m_file.length() - 1L) {
                                this.readAndProcess(this.m_file.length());
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.m_position = 0L;
                        this.m_file = changed;
                        this.m_isFirst = false;
                        String canon = this.m_file.getCanonicalPath();
                        try {
                            this.m_optParams.put("LOGFILE", this.m_file.getName());
                            this.m_optParams.put("LOGPATH", this.m_file.getCanonicalPath());
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.m_submitter.sendMessage(null, this.m_monitorName, "LogFileMonitor", canon, "LFTM switched to monitor file: " + canon, "normal", new HashMap());
                    }
                    if (this.m_position > (size = this.m_file.length())) {
                        this.m_position = 0L;
                    }
                    if (this.m_position < size - 1L) {
                        this.readAndProcess(size);
                    } else {
                        this.checkBuffer("");
                    }
                    break block14;
                }
                if (this.m_file != null && changed == null) {
                    this.m_file = null;
                    if (this.m_submitter != null) {
                        this.m_submitter.sendMessage(null, this.m_monitorName, "LogFileMonitor", this.m_filemask, "File(s) not found", "major", new HashMap());
                    }
                }
            }
            catch (Throwable e) {
                this.m_submitter.sendMessage(null, this.m_monitorName, "LogFileMonitor", this.m_filemask, e.getMessage(), "major", new HashMap());
                isOK = false;
            }
        }
        return isOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAndProcess(long size) throws FileNotFoundException, IOException {
        byte[] bytes;
        if (this.m_isFirst) {
            this.m_position = Math.max(0L, size);
            this.m_isFirst = false;
        }
        RandomAccessFile raf = new RandomAccessFile(this.m_file, "r");
        try {
            raf.seek(this.m_position);
            Long l = new Long(size - this.m_position);
            int bs = l.intValue();
            bytes = new byte[bs];
            int n = raf.read(bytes);
        }
        finally {
            try {
                raf.close();
            }
            catch (Throwable l) {}
        }
        String logs = new String(bytes);
        int lp = logs.lastIndexOf(10);
        if (lp > 0) {
            logs = logs.substring(0, lp + 1);
        }
        this.m_position += (long)logs.length();
        this.checkBuffer(logs);
    }

    public void checkBuffer(String logs) {
        String[] arr_1 = logs.split(this.m_lineSplit);
        for (int i = 0; i < arr_1.length; ++i) {
            String toTest = arr_1[i].trim();
            for (Transaction tr : this.m_transactions) {
                tr.checkEndedOrFailed(toTest, this.m_submitter);
                tr.checkWithStartPattern(toTest, this.m_submitter);
            }
        }
        this.checkTransactionTimeouts();
    }

    public void checkTransactionTimeouts() {
        for (Transaction tr : this.m_transactions) {
            tr.checkTimeouts(this.m_submitter);
        }
    }

    public class ActiveTransaction {
        public String m_startString = null;
        public Pattern m_endPattern = null;
        public Pattern m_failPattern = null;
        public long m_start = 0L;
        public long m_endMax = 0L;
        public HashMap m_opts = new HashMap();

        public boolean checkWithEndPattern(String line) {
            if (this.m_endPattern == null) {
                return false;
            }
            return this.m_endPattern.matcher(line).matches();
        }

        public boolean checkWithFailPattern(String line) {
            if (this.m_failPattern == null) {
                return false;
            }
            return this.m_failPattern.matcher(line).matches();
        }
    }

    public class Transaction {
        private List<ActiveTransaction> m_activeTrans = new ArrayList<ActiveTransaction>();
        private Pattern m_startPattern = null;
        private String m_endPatternS = null;
        private String m_failPatternS = null;
        private long m_seconds = 0L;

        public Transaction(String beginPattern, String endPattern, String failPattern, long seconds) {
            this.m_startPattern = Pattern.compile(beginPattern, 40);
            this.m_endPatternS = endPattern;
            this.m_failPatternS = failPattern;
            this.m_seconds = seconds;
        }

        public boolean checkWithStartPattern(String line, IMessage m_su) {
            Matcher m = this.m_startPattern.matcher(line);
            boolean match = m.matches();
            if (match) {
                ActiveTransaction aTrans = new ActiveTransaction();
                String pe = this.m_endPatternS;
                String pf = this.m_failPatternS;
                for (int i = 1; i <= m.groupCount(); ++i) {
                    String str = m.group(i).trim();
                    aTrans.m_opts.put("svar" + i, str);
                    if (pe != null) {
                        pe = pe.replace("<$svar" + i + ">", str);
                    }
                    if (pf == null) continue;
                    pf = pf.replace("<$svar" + i + ">", str);
                }
                aTrans.m_endPattern = Pattern.compile(pe, 40);
                aTrans.m_failPattern = Pattern.compile(pf, 40);
                aTrans.m_start = System.currentTimeMillis();
                aTrans.m_opts.putAll(LogFileTransactionMonitor.this.m_optParams);
                aTrans.m_endMax = this.m_seconds > 1L ? aTrans.m_start + this.m_seconds * 1000L : aTrans.m_start + 86400000L;
                aTrans.m_startString = line;
                this.m_activeTrans.add(aTrans);
            }
            return match;
        }

        public void checkTimeouts(IMessage m_su) {
            Iterator<ActiveTransaction> it = this.m_activeTrans.iterator();
            while (it.hasNext()) {
                ActiveTransaction at = it.next();
                if (at.m_endMax > System.currentTimeMillis()) continue;
                try {
                    at.m_opts.put("LOGFILE", LogFileTransactionMonitor.this.m_file.getName());
                    at.m_opts.put("LOGPATH", LogFileTransactionMonitor.this.m_file.getCanonicalPath());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                m_su.sendMessage(null, LogFileTransactionMonitor.this.m_monitorName, "LogFileMonitor", "FAIL_TIMEOUT", at.m_startString, "critical", at.m_opts);
                it.remove();
                return;
            }
        }

        public void checkEndedOrFailed(String line, IMessage m_su) {
            Iterator<ActiveTransaction> it = this.m_activeTrans.iterator();
            while (it.hasNext()) {
                Matcher m;
                ActiveTransaction at = it.next();
                if (at.m_endPattern != null && (m = at.m_endPattern.matcher(line)).matches()) {
                    at.m_opts.put("SUCCESS_END_MSG", line);
                    try {
                        at.m_opts.put("LOGFILE", LogFileTransactionMonitor.this.m_file.getName());
                        at.m_opts.put("LOGPATH", LogFileTransactionMonitor.this.m_file.getCanonicalPath());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    m_su.sendMessage(null, LogFileTransactionMonitor.this.m_monitorName, "LogFileMonitor", "SUCCESS_END", at.m_startString, "normal", at.m_opts);
                    it.remove();
                    return;
                }
                if (at.m_failPattern == null || !(m = at.m_failPattern.matcher(line)).matches()) continue;
                at.m_opts.put("FAIL_END_MSG", line);
                at.m_opts.put("SUCCESS_END_MSG", line);
                try {
                    at.m_opts.put("LOGFILE", LogFileTransactionMonitor.this.m_file.getName());
                    at.m_opts.put("LOGPATH", LogFileTransactionMonitor.this.m_file.getCanonicalPath());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                m_su.sendMessage(null, LogFileTransactionMonitor.this.m_monitorName, "LogFileMonitor", "FAIL_END", at.m_startString, "critical", at.m_opts);
                it.remove();
                return;
            }
        }
    }
}

