/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.agent.monitors.AbstractLogMonitor;
import com.blixx.agent.monitors.MultiFileMonitor;
import com.blixx.agent.util.RotatingFile;
import com.blixx.ext.IMonitor;
import java.util.regex.Pattern;

public class MPathLogFileMonitor
extends AbstractLogMonitor {
    protected static final String TYPE_FROMSTART = "FROM_START";
    protected static final String TYPE_REMEMBERLAST = "FROM_LAST";
    protected Pattern m_sendPattern;
    protected String m_exec;

    public static IMonitor getInstance(String monitorName, String[] parameters) {
        String exec = null;
        String type = null;
        String filepath = parameters[0];
        String logLinePattern = parameters[1];
        String sendPattern = parameters[2];
        try {
            type = parameters[3];
            if (type.equalsIgnoreCase(TYPE_FROMSTART) || type.equalsIgnoreCase(TYPE_REMEMBERLAST)) {
                exec = parameters[4];
            } else {
                exec = type;
                type = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new MPathLogFileMonitor(monitorName, filepath, logLinePattern, sendPattern, exec, type);
    }

    protected MPathLogFileMonitor(String monitorName, String filepath, String logLinePattern, String sendPattern, String exec, String type) {
        super(monitorName, filepath, logLinePattern);
        this.m_sendPattern = Pattern.compile(sendPattern, 40);
        this.m_exec = exec;
        this.resetPosition = type != null && type.equalsIgnoreCase(TYPE_FROMSTART);
    }

    @Override
    protected MultiFileMonitor.FileMonitoringJob createMonitorJob(RotatingFile file) {
        return new MultiFileMonitor.ConcurrentMonitoringJob(this, new PlainLogJob(file), 0L);
    }

    @Override
    public String runMonitor() {
        if (this.m_exec != null) {
            this.exec(this.m_exec);
        }
        return super.runMonitor();
    }

    class PlainLogJob
    extends AbstractLogMonitor.LogMonitoringJob {
        protected PlainLogJob(RotatingFile file) {
            super(file);
        }

        @Override
        protected void sendMsg(String message) {
            if (MPathLogFileMonitor.this.m_sendPattern.matcher(message).matches()) {
                String path = (String)this.optParams.get("LOGPATH");
                MPathLogFileMonitor.this.sendMessage(path, message, null, this.optParams);
            }
        }
    }
}

