/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.agent.monitors.AbstractLogMonitor;
import com.blixx.agent.monitors.MultiFileMonitor;
import com.blixx.agent.util.RotatingFile;
import com.blixx.ext.IMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MPathLogFileTransactionMonitorML
extends AbstractLogMonitor {
    protected final List<TransactionCfg> m_transactions;

    public static IMonitor getInstance(String monitorName, String[] parameters) {
        ArrayList<TransactionCfg> lst = new ArrayList<TransactionCfg>();
        for (int i = 2; i < parameters.length; ++i) {
            String startPattern = parameters[i++];
            String endPattern = parameters[i++];
            String failPattern = parameters[i++];
            long sec = Long.parseLong(parameters[i]);
            lst.add(new TransactionCfg(startPattern, endPattern, failPattern, sec));
        }
        return new MPathLogFileTransactionMonitorML(monitorName, parameters[0], parameters[1], lst);
    }

    public MPathLogFileTransactionMonitorML(String monitorName, String pathPattern, String recordSplitPattern, List<TransactionCfg> trs) {
        super(monitorName, pathPattern, recordSplitPattern);
        if (trs.isEmpty()) {
            throw new IllegalArgumentException("No transaction entries specified");
        }
        this.m_transactions = trs;
    }

    @Override
    protected MultiFileMonitor.FileMonitoringJob createMonitorJob(RotatingFile file) {
        return new MultiFileMonitor.ConcurrentMonitoringJob(this, new TransactionLogJob(file), 1000L);
    }

    public class TransactionLogJob
    extends AbstractLogMonitor.LogMonitoringJob {
        public final HashMap<TransactionCfg, ArrayList<ActiveTransaction>> m_activeTrans;

        protected TransactionLogJob(RotatingFile file) {
            super(file);
            this.m_activeTrans = new HashMap();
            for (TransactionCfg tr : MPathLogFileTransactionMonitorML.this.m_transactions) {
                this.m_activeTrans.put(tr, new ArrayList());
            }
        }

        @Override
        public void process() {
            super.process();
            this.checkTransactionTimeouts();
        }

        @Override
        protected void sendMsg(String record) {
            for (TransactionCfg tr : MPathLogFileTransactionMonitorML.this.m_transactions) {
                if (this.checkWithStartPattern(tr, record)) continue;
                this.checkEndedOrFailed(tr, record);
            }
        }

        public boolean checkWithStartPattern(TransactionCfg tr, String line) {
            Matcher m = tr.m_startPattern.matcher(line);
            boolean match = m.matches();
            if (match) {
                ActiveTransaction aTrans = new ActiveTransaction();
                String pe = tr.m_endPatternS;
                String pf = tr.m_failPatternS;
                for (int i = 1; i <= m.groupCount(); ++i) {
                    String str = m.group(i).trim();
                    aTrans.m_opts.put("svar" + i, str);
                    str = Pattern.quote(str);
                    pe = pe.replace("<$svar" + i + ">", str);
                    pf = pf.replace("<$svar" + i + ">", str);
                }
                aTrans.m_endPattern = Pattern.compile(pe, 40);
                aTrans.m_failPattern = Pattern.compile(pf, 40);
                aTrans.m_start = System.currentTimeMillis();
                aTrans.m_opts.putAll(this.optParams);
                aTrans.m_endMax = tr.m_seconds > 1L ? aTrans.m_start + tr.m_seconds * 1000L : aTrans.m_start + 86400000L;
                aTrans.m_startString = line;
                this.m_activeTrans.get(tr).add(aTrans);
            }
            return match;
        }

        public void checkTransactionTimeouts() {
            long now = System.currentTimeMillis();
            for (ArrayList<ActiveTransaction> l : this.m_activeTrans.values()) {
                Iterator<ActiveTransaction> it = l.iterator();
                while (it.hasNext()) {
                    ActiveTransaction at = it.next();
                    if (at.m_endMax > now) continue;
                    MPathLogFileTransactionMonitorML.this.sendMessage("FAIL_TIMEOUT", at.m_startString, "critical", at.m_opts);
                    it.remove();
                }
            }
        }

        public boolean checkEndedOrFailed(TransactionCfg tr, String line) {
            Iterator<ActiveTransaction> it = this.m_activeTrans.get(tr).iterator();
            while (it.hasNext()) {
                ActiveTransaction at = it.next();
                if (at.matchesEndPattern(line)) {
                    at.m_opts.put("SUCCESS_END_MSG", line);
                    MPathLogFileTransactionMonitorML.this.sendMessage("SUCCESS_END", at.m_startString, "normal", at.m_opts);
                    it.remove();
                    return true;
                }
                if (!at.matchesFailPattern(line)) continue;
                at.m_opts.put("FAIL_END_MSG", line);
                MPathLogFileTransactionMonitorML.this.sendMessage("FAIL_END", at.m_startString, "critical", at.m_opts);
                it.remove();
                return true;
            }
            return false;
        }
    }

    public static class ActiveTransaction {
        public String m_startString = null;
        public Pattern m_endPattern = null;
        public Pattern m_failPattern = null;
        public long m_start = 0L;
        public long m_endMax = 0L;
        public HashMap<String, String> m_opts = new HashMap();

        public boolean matchesEndPattern(String line) {
            return this.m_endPattern.matcher(line).matches();
        }

        public boolean matchesFailPattern(String line) {
            return this.m_failPattern.matcher(line).matches();
        }
    }

    public static class TransactionCfg {
        public final Pattern m_startPattern;
        public final String m_endPatternS;
        public final String m_failPatternS;
        public final long m_seconds;

        public TransactionCfg(String beginPattern, String endPattern, String failPattern, long seconds) {
            this.m_startPattern = Pattern.compile(beginPattern, 40);
            this.m_endPatternS = endPattern;
            this.m_failPatternS = failPattern;
            this.m_seconds = seconds;
        }
    }
}

