/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.agent.util.Exec;
import com.blixx.agent.util.ExecResult;
import com.blixx.agent.util.FileUtils;
import com.blixx.agent.util.GlobScanner;
import com.blixx.agent.util.RotatingFile;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitorExtPerf;
import com.blixx.ext.IMonitorSubmitter;
import com.blixx.ext.IPerfLog;
import com.blixx.ext.PerfDoubleMetric;
import com.blixx.ext.PerfStringMetric;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class MultiFileMonitor
implements IMonitorExtPerf {
    public final String MONITOR_CLASS = this.getClass().getSimpleName();
    protected final String monitorName;
    private IMessage msgSubmitter;
    protected IMonitorSubmitter monitorSubmitter;
    protected IPerfLog perfLog;
    protected long interval = 60000L;
    protected final String pathPattern;
    protected final String pathComputer;
    protected ScheduledThreadPoolExecutor execPool;
    protected HashMap<String, FileMonitoringJob> currentJobs = new HashMap();
    private String lastError;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MultiFileMonitor(String monitorName, String pathPattern) {
        this.monitorName = monitorName;
        this.pathPattern = pathPattern;
        if (pathPattern == null || pathPattern.length() == 0) {
            throw new IllegalArgumentException("Path to the file can't be empty");
        }
        String pref = "<$LOGFILES(";
        if (pathPattern.indexOf(pref) != -1) {
            if (!pathPattern.startsWith(pref) || !pathPattern.endsWith(")>")) throw new IllegalArgumentException("Bad path pattern: " + pathPattern);
            this.pathComputer = pathPattern.substring(pref.length(), pathPattern.length() - 2);
            return;
        } else {
            this.pathComputer = null;
        }
    }

    public void setPerfSubmitter(IPerfLog submitter) {
        this.perfLog = submitter;
    }

    public void setInterval(long ms) {
        this.interval = ms;
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
        this.monitorSubmitter = submitter;
    }

    public void setMessageSubmitter(IMessage submitter) {
        this.msgSubmitter = submitter;
    }

    protected void sendError(String object, String text, String severity, HashMap optVars) {
        String error = object + text;
        if (!error.equals(this.lastError)) {
            this.lastError = error;
            HashMap withoutPolicName = new HashMap(optVars);
            withoutPolicName.remove("POLICY_NAME");
            this.msgSubmitter.sendMessage(null, this.monitorName, this.MONITOR_CLASS, object, text, severity, withoutPolicName);
        }
    }

    protected void sendMessage(String object, String text, String severity, HashMap optVars) {
        this.lastError = null;
        this.msgSubmitter.sendMessage(null, this.monitorName, this.MONITOR_CLASS, object, text, severity, optVars);
    }

    protected void sendMessageInternal(String object, String text, String severity, HashMap optVars) {
        this.lastError = null;
        HashMap withoutPolicName = new HashMap(optVars);
        withoutPolicName.remove("POLICY_NAME");
        this.msgSubmitter.sendMessage(null, this.monitorName, this.MONITOR_CLASS, object, text, severity, withoutPolicName);
    }

    public void stop() {
        if (this.execPool != null) {
            this.execPool.shutdown();
            this.execPool = null;
            for (FileMonitoringJob j : this.currentJobs.values()) {
                if (!(j instanceof ConcurrentMonitoringJob)) continue;
                ((ConcurrentMonitoringJob)j).stop();
            }
        }
    }

    public String runMonitor() {
        if (this.execPool == null) {
            this.execPool = new ScheduledThreadPoolExecutor(2);
        }
        this.processPaths();
        return this.monitorName + "=0";
    }

    protected void processPaths() {
        long start = System.nanoTime();
        HashMap<String, RotatingFile> actualFiles = this.collectPaths();
        long scanMS = (System.nanoTime() - start) / 1000000L;
        if (this.perfLog != null) {
            ArrayList<Object> perfMetrics = new ArrayList<Object>();
            perfMetrics.add(new PerfStringMetric("OBJECT", this.pathPattern));
            perfMetrics.add(new PerfDoubleMetric("TIME", (double)scanMS));
            this.perfLog.submitPerfRow("FILE_SCAN", System.currentTimeMillis(), perfMetrics);
        }
        HashMap<String, FileMonitoringJob> oldJobs = new HashMap<String, FileMonitoringJob>(this.currentJobs);
        HashMap<String, FileMonitoringJob> newJobs = new HashMap<String, FileMonitoringJob>();
        for (Map.Entry<String, RotatingFile> entry : actualFiles.entrySet()) {
            RotatingFile actual = entry.getValue();
            FileMonitoringJob job = oldJobs.remove(entry.getKey());
            if (job == null) {
                job = this.createMonitorJob(actual);
            } else if (!actual.file.getAbsolutePath().equals(job.file.file.getAbsolutePath())) {
                job.switchToFile(actual);
            } else if (actual.file.getAbsolutePath().equals(job.file.file.getAbsolutePath()) && job.file.date > actual.file.lastModified()) {
                job.switchToFile(actual);
            }
            newJobs.put(entry.getKey(), job);
            job.process();
        }
        for (Map.Entry<String, Object> entry : oldJobs.entrySet()) {
            ((FileMonitoringJob)entry.getValue()).finish();
        }
        this.currentJobs = newJobs;
    }

    protected abstract FileMonitoringJob createMonitorJob(RotatingFile var1);

    protected final HashMap<String, RotatingFile> collectPaths() {
        HashMap<String, RotatingFile> total = new HashMap<String, RotatingFile>();
        ArrayList<String> paths = new ArrayList<String>();
        if (this.pathComputer != null) {
            ArrayList<String> computed = this.exec(this.pathComputer);
            if (computed == null) {
                return total;
            }
            for (String line : computed) {
                paths.addAll(Arrays.asList(line.split("\\|")));
            }
            if (paths.isEmpty()) {
                this.sendError(this.pathPattern, "Empty path pattern provided", "major", new HashMap());
            }
        } else {
            paths.addAll(Arrays.asList(this.pathPattern.split("\\|")));
        }
        for (String path : paths) {
            if (path.length() == 0) continue;
            path = FileUtils.resolveEnvVars(path);
            HashMap<String, RotatingFile> current = GlobScanner.findFiles(path);
            for (Map.Entry<String, RotatingFile> e : current.entrySet()) {
                e.getValue().pattern = path;
                total.put(path + "@" + e.getKey(), e.getValue());
            }
        }
        if (total.isEmpty()) {
            this.sendError(this.pathPattern, "File(s) not found", "major", new HashMap());
        }
        return total;
    }

    protected ArrayList<String> exec(String cmd) {
        Exec ex = new Exec();
        try {
            File dir = new File("spi");
            if (!dir.exists()) {
                dir = new File(".");
            }
            ExecResult er = Exec.exec2(cmd, dir, 300);
            if (er.resultCode == 0) {
                return er.m_outMessages;
            }
            String output = er.toStringOnError();
            this.sendError("", this.MONITOR_CLASS + ": external trigger failed " + cmd + "\n" + output, "major", new HashMap());
        }
        catch (Throwable e) {
            this.sendError("", this.MONITOR_CLASS + ": external trigger failed " + cmd + "\n" + e.toString(), "major", new HashMap());
        }
        return null;
    }

    protected class ConcurrentMonitoringJob
    extends FileMonitoringJob
    implements Runnable {
        protected final Queue<RotatingFile> rotated;
        protected final FileMonitoringJob job;
        protected final AtomicBoolean isScheduled;
        protected final long period;
        protected Future future;

        protected ConcurrentMonitoringJob(FileMonitoringJob job, long period) {
            super(job.file);
            this.rotated = new ConcurrentLinkedQueue<RotatingFile>();
            this.isScheduled = new AtomicBoolean();
            this.job = job;
            this.period = period;
        }

        @Override
        public void process() {
            if (this.isScheduled.compareAndSet(false, true)) {
                this.future = this.period == 0L ? MultiFileMonitor.this.execPool.submit(this) : MultiFileMonitor.this.execPool.scheduleAtFixedRate(this, this.period / 2L, this.period, TimeUnit.MILLISECONDS);
                if (!this.isScheduled.get()) {
                    this.future.cancel(false);
                }
            }
        }

        @Override
        public void switchToFile(RotatingFile newFile) {
            this.rotated.add(newFile);
            this.file = newFile;
        }

        public void stop() {
            if (this.future != null) {
                this.future.cancel(false);
                this.future = null;
            }
            this.isScheduled.set(false);
        }

        @Override
        public void finish() {
            if (this.isScheduled.compareAndSet(true, false)) {
                if (this.future != null) {
                    this.future.cancel(false);
                    this.future = null;
                }
            } else {
                this.job.finish();
            }
        }

        @Override
        public void run() {
            if (!this.isScheduled.get()) {
                this.job.finish();
                return;
            }
            try {
                while (!this.rotated.isEmpty()) {
                    this.job.switchToFile(this.rotated.poll());
                }
                this.job.process();
            }
            finally {
                if (this.period == 0L) {
                    this.isScheduled.set(false);
                }
            }
        }
    }

    protected abstract class FileMonitoringJob {
        protected RotatingFile file;

        protected FileMonitoringJob(RotatingFile file) {
            this.file = file;
        }

        public abstract void process();

        public abstract void switchToFile(RotatingFile var1);

        public abstract void finish();
    }
}

