/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.agent.util.NullMonSubmitter;
import com.blixx.agent.util.Utils;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitorExtPerf;
import com.blixx.ext.IMonitorSubmitter;
import com.blixx.ext.IPerfLog;
import com.blixx.ext.PerfDoubleMetric;
import com.blixx.ext.PerfStringMetric;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.net.nntp.NNTPClient;
import org.apache.commons.net.nntp.NewsgroupInfo;

public class NNTPMonitor
implements IMonitorExtPerf {
    public String[] m_hostnames = null;
    public String m_monitor = "";
    public long m_connectTime = 0L;
    public long m_responseTime = 0L;
    public IMonitorSubmitter m_submitter = null;
    public IPerfLog m_perfSubmitter = null;
    public IMessage m_msgSubmitter = null;

    public static NNTPMonitor getInstance(String monitor, String[] parameters) {
        NNTPMonitor mon = new NNTPMonitor();
        mon.m_hostnames = parameters;
        mon.m_monitor = monitor;
        return mon;
    }

    public void setPerfSubmitter(IPerfLog submitter) {
        this.m_perfSubmitter = submitter;
    }

    public void setInterval(long ms) {
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
        this.m_submitter = submitter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String runMonitor() {
        for (int i = 0; i < this.m_hostnames.length; ++i) {
            InetAddress addr2;
            int availability = -4;
            double groupsNumber = -1.0;
            double articlesCount = -1.0;
            String[] args = Utils.split(this.m_hostnames[i]);
            String hostname = args[0];
            int port = 119;
            int posC = hostname.indexOf(58);
            if (posC != -1) {
                hostname = args[0].substring(0, posC);
                String portStr = args[0].substring(posC + 1);
                try {
                    port = Integer.parseInt(portStr);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            String user = null;
            String pass = null;
            if (args.length > 1) {
                user = args[1];
                if (args.length > 2) {
                    pass = args[2];
                }
            }
            long start = System.currentTimeMillis();
            HashMap<String, Object> opts = new HashMap<String, Object>();
            opts.put("host", hostname);
            opts.put("user", user);
            NNTPClient client = new NNTPClient();
            try {
                client.connect(hostname, port);
                this.m_connectTime = System.currentTimeMillis() - start;
                if (user != null) {
                    if (pass == null) {
                        pass = "";
                    }
                    availability = client.authenticate(user, pass) ? 5 : 1;
                }
                if (availability != 1) {
                    NewsgroupInfo[] ngi = null;
                    try {
                        ngi = client.listNewsgroups();
                        availability = 5;
                    }
                    catch (Throwable e) {
                        availability = 3;
                    }
                    this.m_responseTime = System.currentTimeMillis() - start - this.m_connectTime;
                    if (ngi != null) {
                        groupsNumber = ngi.length;
                        articlesCount = 0.0;
                        for (int j = 0; j < ngi.length; ++j) {
                            articlesCount += (double)ngi[j].getArticleCount();
                        }
                        opts.put("articlesEst", "" + articlesCount);
                        opts.put("ngroups", "" + groupsNumber);
                    }
                }
                long totalTime = this.m_connectTime + this.m_responseTime;
                opts.put("time", totalTime);
                opts.put("ctime", this.m_connectTime);
                opts.put("rtime", this.m_responseTime);
            }
            catch (UnknownHostException e) {
                availability = -6;
            }
            catch (SocketException e) {
                availability = -4;
                try {
                    addr2 = InetAddress.getByName(hostname);
                    if (addr2.isReachable(3000)) {
                        availability = -3;
                    }
                }
                catch (Throwable addr2) {
                    // empty catch block
                }
            }
            catch (SocketTimeoutException e) {
                availability = -4;
                try {
                    addr2 = InetAddress.getByName(hostname);
                    if (addr2.isReachable(3000)) {
                        availability = -3;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            catch (IOException e) {
                availability = -5;
            }
            finally {
                try {
                    client.logout();
                }
                catch (Throwable e) {}
                try {
                    client.disconnect();
                }
                catch (Throwable e) {}
            }
            long totalTime = this.m_connectTime + this.m_responseTime;
            if (availability < 0) {
                totalTime = -1L;
            }
            if (totalTime < 0L) {
                this.m_responseTime = -1L;
                this.m_connectTime = -1L;
            }
            this.m_submitter.submitMonitorValue(this.m_monitor, (double)totalTime, user + "@" + hostname + ":TIME", opts);
            this.m_submitter.submitMonitorValue(this.m_monitor, (double)availability, user + "@" + hostname + ":AVAILABILITY", opts);
            if (this.m_perfSubmitter == null) continue;
            ArrayList<Object> perfMetrics = new ArrayList<Object>();
            perfMetrics.add(new PerfStringMetric("HOST", hostname));
            perfMetrics.add(new PerfDoubleMetric("PORT", (double)port));
            perfMetrics.add(new PerfStringMetric("OBJECT", user));
            perfMetrics.add(new PerfDoubleMetric("ARTICLESEST", articlesCount));
            perfMetrics.add(new PerfDoubleMetric("NGROUPS", groupsNumber));
            perfMetrics.add(new PerfDoubleMetric("RTIME", (double)this.m_responseTime));
            perfMetrics.add(new PerfDoubleMetric("CTIME", (double)this.m_connectTime));
            perfMetrics.add(new PerfDoubleMetric("TTIME", (double)totalTime));
            perfMetrics.add(new PerfDoubleMetric("STATUS", (double)availability));
            this.m_perfSubmitter.submitPerfRow("IS_NNTP", System.currentTimeMillis(), perfMetrics);
        }
        return null;
    }

    public void setMessageSubmitter(IMessage submitter) {
        this.m_msgSubmitter = submitter;
    }

    public void stop() {
    }

    public static void main(String[] args) {
        NNTPMonitor pm = NNTPMonitor.getInstance("OK5", new String[]{"msnews.microsoft.com"});
        pm.setMonitorSubmitter(new NullMonSubmitter());
        pm.runMonitor();
        pm = NNTPMonitor.getInstance("LOGIN_FAILED1", new String[]{"msnews.microsoft.com test test"});
        pm.setMonitorSubmitter(new NullMonSubmitter());
        pm.runMonitor();
    }
}

