/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.agent.util.NullMonSubmitter;
import com.blixx.agent.util.NullMsgSubmitter;
import com.blixx.agent.util.NullPerfSubmitter;
import com.blixx.agent.util.Utils;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitorExtPerf;
import com.blixx.ext.IMonitorSubmitter;
import com.blixx.ext.IPerfLog;
import com.boom.utils.JNRPEClient;
import com.boom.utils.JNRPEClientException;
import com.boom.utils.ReturnValue;
import java.util.HashMap;

public class NRPEClient
implements IMonitorExtPerf {
    public String m_monitor = "";
    public IMonitorSubmitter m_submitter = null;
    public IPerfLog m_perfSubmitter = null;
    public IMessage m_msgSubmitter = null;
    public String[] m_parameters = null;
    public String m_host = null;
    public int m_port = 5666;
    public boolean m_ssl = true;
    public String m_command = null;
    public String[] m_arguments = null;
    public int m_timeout = 10;

    public static NRPEClient getInstance(String monitor, String[] parameters) {
        NRPEClient mon = new NRPEClient();
        mon.m_parameters = parameters;
        mon.m_monitor = monitor;
        StringBuilder sb = new StringBuilder();
        for (String str : parameters) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(str);
        }
        String[] params = Utils.processQuoted(sb.toString());
        for (int i = 0; i < params.length; ++i) {
            String arg = Utils.removeQuotesStrict(params[i]);
            if (!arg.startsWith("-")) continue;
            if ("-h".equalsIgnoreCase(arg)) {
                mon.m_host = params[++i];
                continue;
            }
            if ("-p".equalsIgnoreCase(arg)) {
                mon.m_port = Integer.parseInt(params[++i]);
                continue;
            }
            if ("-t".equalsIgnoreCase(arg)) {
                mon.m_timeout = Integer.parseInt(params[++i]);
                continue;
            }
            if ("-c".equalsIgnoreCase(arg)) {
                mon.m_command = params[++i];
                continue;
            }
            if ("-n".equalsIgnoreCase(arg)) {
                mon.m_ssl = false;
                continue;
            }
            if ("-a".equalsIgnoreCase(arg)) {
                String ss = params[++i];
                mon.m_arguments = Utils.processQuoted(ss);
                for (int j = 0; j < mon.m_arguments.length; ++j) {
                    mon.m_arguments[j] = Utils.removeQuotesStrict(mon.m_arguments[j]);
                }
                continue;
            }
            throw new RuntimeException("Unsupported parameter flag: " + params[i]);
        }
        return mon;
    }

    public void setInterval(long ms) {
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
        this.m_submitter = submitter;
    }

    public String runMonitor() {
        try {
            JNRPEClient client = new JNRPEClient(this.m_host, this.m_port, this.m_ssl);
            client.setTimeout(this.m_timeout);
            ReturnValue rv = client.sendCommand(this.m_command, this.m_arguments);
            HashMap<String, Object> opts = new HashMap<String, Object>();
            String message = rv.getMessage();
            opts.put("message", message);
            opts.put("host", this.m_host);
            opts.put("port", this.m_port);
            opts.put("command", this.m_command);
            opts.put("arguments", this.m_arguments);
            String hash = "" + message.hashCode();
            this.m_submitter.submitMonitorValue(this.m_monitor, (double)rv.getStatus().intValue(), hash, opts);
            String severity = "unknown";
            switch (rv.getStatus().intValue()) {
                case 0: {
                    severity = "normal";
                    break;
                }
                case 1: {
                    severity = "warning";
                    break;
                }
                case 2: {
                    severity = "critical";
                    break;
                }
            }
            opts.put("POLICY_NAME", this.m_monitor);
            this.m_msgSubmitter.sendMessage(this.m_host, "", null, null, message, severity, opts);
        }
        catch (JNRPEClientException e) {
            RuntimeException re = new RuntimeException(e.getMessage());
            re.setStackTrace(e.getStackTrace());
            throw re;
        }
        return null;
    }

    public void setMessageSubmitter(IMessage submitter) {
        this.m_msgSubmitter = submitter;
    }

    public void stop() {
    }

    public void setPerfSubmitter(IPerfLog submitter) {
        this.m_perfSubmitter = submitter;
    }

    public static void main(String[] args) {
        NRPEClient nrpe = NRPEClient.getInstance("test", new String[]{"-H marnef.bes-intern.com -c check_mountpoints -t 30"});
        nrpe.setMessageSubmitter(new NullMsgSubmitter());
        nrpe.setMonitorSubmitter(new NullMonSubmitter());
        nrpe.setPerfSubmitter(new NullPerfSubmitter());
        nrpe.runMonitor();
    }
}

