/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.agent.util.NullMonSubmitter;
import com.blixx.agent.util.Utils;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitorExtPerf;
import com.blixx.ext.IMonitorSubmitter;
import com.blixx.ext.IPerfLog;
import com.blixx.ext.PerfDoubleMetric;
import com.blixx.ext.PerfLongMetric;
import com.blixx.ext.PerfStringMetric;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.net.ntp.NTPUDPClient;
import org.apache.commons.net.ntp.TimeInfo;

public class NTPMonitor
implements IMonitorExtPerf {
    public String[] m_hostnames = null;
    public String m_monitor = "";
    public long m_connectTime = 0L;
    public long m_responseTime = 0L;
    public IMonitorSubmitter m_submitter = null;
    public IPerfLog m_perfSubmitter = null;
    public IMessage m_msgSubmitter = null;

    public static NTPMonitor getInstance(String monitor, String[] parameters) {
        NTPMonitor mon = new NTPMonitor();
        mon.m_hostnames = parameters;
        mon.m_monitor = monitor;
        return mon;
    }

    public void setPerfSubmitter(IPerfLog submitter) {
        this.m_perfSubmitter = submitter;
    }

    public void setInterval(long ms) {
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
        this.m_submitter = submitter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String runMonitor() {
        for (int i = 0; i < this.m_hostnames.length; ++i) {
            int availability = -4;
            String[] args = Utils.split(this.m_hostnames[i]);
            String hostname = args[0];
            int port = 123;
            int posC = hostname.indexOf(58);
            if (posC != -1) {
                hostname = args[0].substring(0, posC);
                String portStr = args[0].substring(posC + 1);
                try {
                    port = Integer.parseInt(portStr);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            Long offset = 0L;
            int stratum = 0;
            HashMap<String, String> opts = new HashMap<String, String>();
            opts.put("host", hostname);
            NTPUDPClient client = new NTPUDPClient();
            client.setDefaultTimeout(10000);
            try {
                InetAddress ia = InetAddress.getByName(hostname);
                this.m_connectTime = 0L;
                long start = System.currentTimeMillis();
                TimeInfo ti = client.getTime(ia, port);
                this.m_responseTime = System.currentTimeMillis() - start;
                long totalTime = this.m_connectTime + this.m_responseTime;
                ti.computeDetails();
                offset = ti.getOffset();
                if (offset == null) {
                    offset = 0L;
                }
                stratum = ti.getMessage().getStratum();
                availability = 5;
                opts.put("time", "" + totalTime);
                opts.put("ctime", "" + this.m_connectTime);
                opts.put("rtime", "" + this.m_responseTime);
                opts.put("offset", offset.toString());
                opts.put("stratum", "" + stratum);
            }
            catch (UnknownHostException e) {
                availability = -6;
            }
            catch (SocketException e) {
                availability = -4;
                try {
                    InetAddress addr = InetAddress.getByName(hostname);
                    if (addr.isReachable(3000)) {
                        availability = -3;
                    }
                }
                catch (Throwable addr) {
                    // empty catch block
                }
            }
            catch (SocketTimeoutException e) {
                availability = -4;
                try {
                    InetAddress addr = InetAddress.getByName(hostname);
                    if (addr.isReachable(3000)) {
                        availability = -3;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            catch (IOException e) {
                availability = -5;
            }
            finally {
                try {
                    client.close();
                }
                catch (Throwable e) {}
            }
            long totalTime = this.m_connectTime + this.m_responseTime;
            if (availability < 0) {
                totalTime = -1L;
            }
            if (totalTime < 0L) {
                this.m_responseTime = -1L;
                this.m_connectTime = -1L;
            }
            this.m_submitter.submitMonitorValue(this.m_monitor, (double)totalTime, hostname + ":TIME", opts);
            this.m_submitter.submitMonitorValue(this.m_monitor, (double)availability, hostname + ":AVAILABILITY", opts);
            if (this.m_perfSubmitter == null) continue;
            ArrayList<Object> perfMetrics = new ArrayList<Object>();
            perfMetrics.add(new PerfStringMetric("HOST", hostname));
            perfMetrics.add(new PerfDoubleMetric("PORT", (double)port));
            perfMetrics.add(new PerfDoubleMetric("RTIME", (double)this.m_responseTime));
            perfMetrics.add(new PerfDoubleMetric("CTIME", (double)this.m_connectTime));
            perfMetrics.add(new PerfDoubleMetric("TTIME", (double)totalTime));
            perfMetrics.add(new PerfDoubleMetric("STATUS", (double)availability));
            perfMetrics.add(new PerfLongMetric("OFFSET", offset.longValue()));
            perfMetrics.add(new PerfLongMetric("STRATUM", (long)stratum));
            this.m_perfSubmitter.submitPerfRow("IS_NTP", System.currentTimeMillis(), perfMetrics);
        }
        return null;
    }

    public void setMessageSubmitter(IMessage submitter) {
        this.m_msgSubmitter = submitter;
    }

    public void stop() {
    }

    public static void main(String[] args) {
        NTPMonitor pm = NTPMonitor.getInstance("OK5", new String[]{"0.de.pool.ntp.org", "1.de.pool.ntp.org", "2.de.pool.ntp.org", "3.de.pool.ntp.org"});
        pm.setMonitorSubmitter(new NullMonSubmitter());
        pm.runMonitor();
    }
}

