/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.agent.actions.HttpAction;
import com.blixx.agent.actions.JmxAction;
import com.blixx.agent.actions.SshAction;
import com.blixx.agent.actions.StrAction;
import com.blixx.agent.util.Exec;
import com.blixx.agent.util.ExecResult;
import com.blixx.agent.util.HashMapArray;
import com.blixx.agent.util.SyntaxException;
import com.blixx.agent.util.Utils;
import com.blixx.ext.IAction;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitorExt;
import com.blixx.ext.IMonitorSubmitter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.OpmExpressionBuilder;

public class Opm
implements IMonitorExt {
    public static final String VAR = "var";
    public static final String SVAR = "svar";
    public String m_monitor = "";
    public IMonitorSubmitter m_submitter = null;
    public IMessage m_msgSubmitter = null;
    public long m_interval = 0L;
    public ArrayList<String> m_patternStr = new ArrayList();
    public ArrayList<Pattern> m_pattern = new ArrayList();
    public ArrayList<String> m_functions = new ArrayList();
    public String m_type = null;
    public String m_exec = null;
    public static String LINE_BY_LINE = "LineByLine";
    public static String TABLE_SUMMARY = "TableSummary";
    public static String PUNCH_CARD = "PunchCard";
    public static String FUNC_COUNT = "COUNT";
    public static String FUNC_SUM = "SUM";
    public static String FUNC_MIN = "MIN";
    public static String FUNC_MAX = "MAX";
    public static String FUNC_AVG = "AVG";
    public static Pattern m_svarPattern = null;
    HashMap<String, ArrayList<Object>> m_previousValues = new HashMap();
    protected int m_numSubmittedValues = 0;
    public List<PunchCard> punchCards = new ArrayList<PunchCard>();

    public static Opm getInstance(String monitor, String[] params) {
        Opm mon = new Opm();
        mon.m_monitor = monitor;
        if (params == null || params.length < 4) {
            throw new RuntimeException("Monitor expects at least 4 parameters:\nExec, type, regexp, calculation string. See documentation about usage of this monitor");
        }
        mon.m_exec = params[0];
        mon.m_type = params[1];
        if (mon.m_type.equalsIgnoreCase(TABLE_SUMMARY)) {
            String patternStr = params[2];
            mon.m_patternStr.add(patternStr);
            Pattern p = Pattern.compile(patternStr);
            mon.m_pattern.add(p);
            for (int i = 3; i < params.length; ++i) {
                mon.m_functions.add(params[i]);
            }
        } else if (mon.m_type.equalsIgnoreCase(PUNCH_CARD)) {
            int i = 1;
            while (i < params.length && PUNCH_CARD.equals(params[i].trim())) {
                Opm opm = mon;
                opm.getClass();
                PunchCard punchCard = opm.new PunchCard(params[++i], params[++i], params[++i]);
                mon.punchCards.add(punchCard);
                while (++i < params.length && !PUNCH_CARD.equals(params[i].trim())) {
                    Opm opm2 = mon;
                    opm2.getClass();
                    PunchCardLine line = opm2.new PunchCardLine(params[i], Opm.splitStringUsingEscapeCharacter(params[++i], ";", "\\"));
                    punchCard.lines.add(line);
                }
            }
        } else {
            for (int i = 2; i < params.length; i += 2) {
                String patternStr = params[i];
                mon.m_patternStr.add(patternStr);
                Pattern p = Pattern.compile(patternStr);
                mon.m_pattern.add(p);
                mon.m_functions.add(params[i + 1]);
            }
        }
        return mon;
    }

    private static String[] splitStringUsingEscapeCharacter(String text, String delimiter, String escape) {
        String regex = "(?<!" + Pattern.quote(escape) + ")" + Pattern.quote(delimiter);
        String[] result = text.split(regex);
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].replace(escape + delimiter, delimiter);
        }
        return result;
    }

    public void setInterval(long ms) {
        this.m_interval = ms;
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
        this.m_submitter = submitter;
    }

    public String runMonitor() {
        try {
            ExecResult er = this.execute();
            Iterator<String> it = er.m_outMessages.iterator();
            if (this.m_type.equalsIgnoreCase(TABLE_SUMMARY)) {
                this.processSummary(it, this.m_pattern.get(0), this.m_functions);
            } else if (this.m_type.equalsIgnoreCase(LINE_BY_LINE)) {
                this.processLines(it);
            } else if (this.m_type.equalsIgnoreCase(PUNCH_CARD)) {
                this.processPunchCard(it);
            }
            if (this.m_numSubmittedValues == 0) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < er.m_outMessages.size(); ++i) {
                    sb.append(er.m_outMessages.get(i)).append("\n");
                }
                this.m_msgSubmitter.sendMessage(null, "AGENT", "Opm", this.m_monitor, "Zero matches for the output: \n" + sb.toString(), "warning", null);
            }
        }
        catch (IOException e) {
            this.m_msgSubmitter.sendMessage(null, "AGENT", "Opm", this.m_monitor, "Exec failed.", "warning", null);
        }
        catch (StopProcessing stopProcessing) {
            // empty catch block
        }
        return null;
    }

    protected ExecResult execute() throws StopProcessing, IOException {
        int seconds = (int)(this.m_interval / 1000L);
        File workDir = new File(".");
        File spiDir = new File("spi");
        if (spiDir.exists() && spiDir.isDirectory()) {
            workDir = spiDir;
        }
        ExecResult er = new ExecResult();
        er.resultCode = -404;
        if (this.m_exec.startsWith("SshAction ") || this.m_exec.startsWith("com.blixx.agent.actions.SshAction ")) {
            try {
                int i;
                SshAction sshAction = new SshAction();
                String[] parameters = new String[4];
                String[] split = Utils.processQuoted(this.m_exec);
                if (split != null) {
                    for (i = 0; i < split.length; ++i) {
                        if (split[i] == null) continue;
                        split[i] = Utils.removeQuotes(split[i]);
                    }
                }
                parameters[0] = split[1];
                parameters[1] = split[2];
                parameters[2] = split[3];
                parameters[3] = "";
                for (i = 4; i < split.length; ++i) {
                    parameters[3] = parameters[3] + split[i] + " ";
                }
                String res = sshAction.run(parameters, seconds);
                er.resultCode = 0;
                String[] lines = res.split("\r*\n");
                for (int i2 = 0; i2 < lines.length; ++i2) {
                    er.m_outMessages.add(lines[i2]);
                }
            }
            catch (Throwable e) {
                this.m_msgSubmitter.sendMessage(null, "AGENT", "Opm", this.m_monitor, "SshAction failed (" + this.m_exec + ")\n" + e.getMessage(), "warning", null);
                throw new StopProcessing();
            }
        } else if (this.m_exec.startsWith("JmxAction ") || this.m_exec.startsWith("com.blixx.agent.actions.JmxAction ")) {
            try {
                String[] params = Utils.processQuoted(this.m_exec);
                if (params != null) {
                    for (int i = 0; i < params.length; ++i) {
                        if (params[i] == null) continue;
                        params[i] = Utils.removeQuotes(params[i]);
                    }
                }
                String[] params2 = new String[params.length - 1];
                System.arraycopy(params, 1, params2, 0, params2.length);
                JmxAction jmx = new JmxAction();
                String res = jmx.run(params2, seconds);
                er.resultCode = 0;
                String[] lines = res.split("\r*\n");
                for (int i = 0; i < lines.length; ++i) {
                    er.m_outMessages.add(lines[i]);
                }
            }
            catch (Throwable e) {
                this.m_msgSubmitter.sendMessage(null, "AGENT", "Opm", this.m_monitor, "JmxAction failed (" + this.m_exec + ")\n" + e.getMessage(), "warning", null);
                throw new StopProcessing();
            }
        } else if (this.m_exec.startsWith("HttpAction ") || this.m_exec.startsWith("com.blixx.agent.actions.HttpAction ")) {
            try {
                String[] params = Utils.processQuoted(this.m_exec);
                if (params != null) {
                    for (int i = 0; i < params.length; ++i) {
                        if (params[i] == null) continue;
                        params[i] = Utils.removeQuotes(params[i]);
                    }
                }
                String[] params2 = new String[params.length - 1];
                System.arraycopy(params, 1, params2, 0, params2.length);
                HttpAction web = new HttpAction();
                String res = web.run(params2, seconds);
                er.resultCode = web.m_responseCode >= 400 ? web.m_responseCode : 0;
                String[] lines = res.split("\r*\n");
                for (int i = 0; i < lines.length; ++i) {
                    if (lines[i].trim().length() == 0) continue;
                    er.m_outMessages.add(lines[i]);
                }
            }
            catch (Throwable e) {
                this.m_msgSubmitter.sendMessage(null, "AGENT", "Opm", this.m_monitor, "HttpAction failed (" + this.m_exec + ")\n" + e.getMessage(), "warning", null);
                throw new StopProcessing();
            }
        } else if (this.m_exec.startsWith("IAction ")) {
            try {
                String[] params = Utils.processQuoted(this.m_exec);
                if (params.length < 2) {
                    throw new RuntimeException("Incorrect format. Expected format: IAction <className> [parameters]");
                }
                if (params != null) {
                    for (int i = 0; i < params.length; ++i) {
                        if (params[i] == null) continue;
                        params[i] = Utils.removeQuotes(params[i]);
                    }
                }
                String className = params[1];
                String[] params2 = new String[params.length - 2];
                System.arraycopy(params, 2, params2, 0, params2.length);
                Class<?> actionClass = Class.forName(className);
                Constructor<?> constr = actionClass.getConstructor(new Class[0]);
                Object instance = constr.newInstance(new Object[0]);
                String res = ((IAction)instance).run(params2, seconds);
                String[] lines = res.split("\r*\n");
                for (int i = 0; i < lines.length; ++i) {
                    if (lines[i].trim().length() == 0) continue;
                    er.m_outMessages.add(lines[i]);
                }
            }
            catch (Throwable e) {
                this.m_msgSubmitter.sendMessage(null, "AGENT", "Opm", this.m_monitor, "IAction failed (" + this.m_exec + ")\n" + e.getMessage(), "warning", null);
                throw new StopProcessing();
            }
        } else if (this.m_exec.startsWith("StrAction ") || this.m_exec.startsWith("com.blixx.agent.actions.StrAction ")) {
            try {
                String[] params = Utils.processQuoted(this.m_exec);
                if (params != null) {
                    for (int i = 0; i < params.length; ++i) {
                        if (params[i] == null) continue;
                        params[i] = Utils.removeQuotes(params[i]);
                    }
                }
                String[] params2 = new String[params.length - 1];
                System.arraycopy(params, 1, params2, 0, params2.length);
                StrAction action = new StrAction();
                action.run(params2, seconds);
                er.resultCode = 0;
                er.m_outMessages.addAll(action.m_result);
            }
            catch (Throwable e) {
                this.m_msgSubmitter.sendMessage(null, "AGENT", "Opm", this.m_monitor, "StrAction failed (" + this.m_exec + ")\n" + e.getMessage(), "warning", null);
                throw new StopProcessing();
            }
        } else {
            er = Exec.exec2(this.m_exec, workDir, seconds);
            if (er.resultCode != 0 && (er.m_errorMessages != null && er.m_errorMessages.size() > 0 || er.m_outMessages == null || er.m_outMessages.size() == 0)) {
                this.m_msgSubmitter.sendMessage(null, "AGENT", "Opm", this.m_monitor, "Exec failed. returnCode: " + er.resultCode + "\n" + er.toStringOnError(), "warning", null);
                throw new StopProcessing();
            }
        }
        return er;
    }

    public void processPunchCard(Iterator<String> it) {
        HashSet<PunchCard> currentPunchCards = new HashSet<PunchCard>();
        while (it.hasNext()) {
            String textLine = it.next();
            for (PunchCard punchCard : this.punchCards) {
                if (!punchCard.splitPattern.matcher(textLine).matches()) continue;
                this.submitPunchCardResult(punchCard);
                punchCard.values = new Values();
                currentPunchCards.add(punchCard);
            }
            for (PunchCard punchCard : currentPunchCards) {
                for (PunchCardLine punchCardLine : punchCard.lines) {
                    punchCard.values.putAll(this.processPunchCardLine(punchCardLine, textLine));
                }
            }
        }
        for (PunchCard punchCard : currentPunchCards) {
            this.submitPunchCardResult(punchCard);
        }
    }

    private void submitPunchCardResult(PunchCard punchCard) {
        if (punchCard.values.size() > 0) {
            String object = this.replaceVariables(punchCard.objectExpression, punchCard.values.stringValues, true);
            object = this.replaceVariables(object, punchCard.values.doubleValues, true);
            this.processLine(punchCard.values, object, punchCard.valueExpression.replaceAll("[<\\$>]", ""), new HashMap<String, Double>());
        }
    }

    private Values processPunchCardLine(PunchCardLine punchCardLine, String textLine) {
        Values resultValues = new Values();
        Matcher m = punchCardLine.pattern.matcher(textLine);
        if (m.matches()) {
            Values parsedValues = this.parseValues(m);
            for (String function : punchCardLine.functions) {
                String[] objectNameExpression = function.split("=", 2);
                String variableName = objectNameExpression[0].trim();
                String expression = objectNameExpression[1].trim();
                if (expression.contains(SVAR) || !expression.contains(VAR)) {
                    String variableValue = this.replaceVariables(expression, parsedValues.stringValues, false);
                    variableValue = this.replaceVariables(variableValue, parsedValues.doubleValues, false);
                    resultValues.stringValues.put(variableName, variableValue);
                    try {
                        resultValues.doubleValues.put(variableName, Double.parseDouble(variableValue.trim().replace(',', '.')));
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                try {
                    double result = this.calculateLine(parsedValues.doubleValues, expression, new HashMap<String, Double>());
                    resultValues.doubleValues.put(variableName, result);
                    resultValues.stringValues.put(variableName, String.valueOf(result));
                }
                catch (SyntaxException e) {
                    this.m_submitter.submitMonitorValue(this.m_monitor, -2.0, variableName, null);
                    ++this.m_numSubmittedValues;
                    this.m_msgSubmitter.sendMessage(null, "AGENT", "Opm", this.m_monitor, e.getMessage() + " Line: " + function, "minor", null);
                }
            }
        }
        return resultValues;
    }

    private String getVariableSubstitutionKey(String variable) {
        StringBuilder builder = new StringBuilder();
        builder.append("<$").append(variable).append(">");
        return builder.toString();
    }

    public String replaceVariables(String expression, Map<String, ? extends Object> variableValues, boolean expressionContainsBracedVariables) {
        String result = new String(expression);
        for (String var : variableValues.keySet()) {
            Object value = variableValues.get(var);
            if (value == null) {
                value = "null";
            }
            if (expressionContainsBracedVariables) {
                result = result.replace(this.getVariableSubstitutionKey(var), value.toString());
                continue;
            }
            result = result.replace(var, value.toString());
        }
        return result;
    }

    public void processLines(Iterator<String> it) {
        while (it.hasNext()) {
            String line = it.next();
            LinkedHashMap<String, Double> previousObjectsCalculated = new LinkedHashMap<String, Double>();
            for (int i = 0; i < this.m_pattern.size(); ++i) {
                Pattern pt = this.m_pattern.get(i);
                Matcher m = pt.matcher(line);
                if (!m.matches()) continue;
                Values values = this.parseValues(m);
                String[] arr = this.m_functions.get(i).split("\\s+", 2);
                this.processLine(values, arr[0], arr[1], previousObjectsCalculated);
            }
        }
    }

    private Values parseValues(Matcher m) {
        Values values = new Values();
        if (m != null) {
            for (int i = 1; i <= m.groupCount(); ++i) {
                try {
                    String str = m.group(i).trim();
                    values.stringValues.put(SVAR + i, str);
                    double v = Double.parseDouble(str.replace(',', '.'));
                    values.doubleValues.put(VAR + i, v);
                    continue;
                }
                catch (Throwable e) {
                    values.doubleValues.put(VAR + i, null);
                }
            }
        }
        return values;
    }

    private void processLine(Values values, String object, String expression, Map<String, Double> previousObjectsCalculated) {
        String[] arr = expression.split("\\s+");
        String function = arr[0];
        StringBuilder expressionBuilder = new StringBuilder();
        for (int i = 1; i < arr.length; ++i) {
            String element = arr[i];
            element = this.replaceSVALues(element, values.stringValues);
            expressionBuilder.append(element).append(' ');
        }
        try {
            double res = this.calculateLine(values.doubleValues, expressionBuilder.toString(), previousObjectsCalculated);
            Object ma = null;
            object = this.replaceSVALues(object, values.stringValues);
            if (function.equalsIgnoreCase("DELTA")) {
                ArrayList<Number> al = new ArrayList<Number>();
                al.add(res);
                al.add(System.currentTimeMillis());
                if (this.m_previousValues.containsKey(object)) {
                    ArrayList<Object> stored = this.m_previousValues.get(object);
                    values.stringValues.put("lastValue", "" + stored.get(0));
                    values.stringValues.put("lastTime", "" + stored.get(1));
                    try {
                        Double pr = (Double)stored.get(0);
                        res -= pr.doubleValue();
                        if (res < 0.0) {
                            res = -1.0;
                        }
                    }
                    catch (Throwable e) {
                        res = -1.0;
                    }
                } else {
                    res = -1.0;
                }
                this.m_previousValues.put(object, al);
            }
            this.m_submitter.submitMonitorValue(this.m_monitor, res, object, values.stringValues);
            previousObjectsCalculated.put(object, res);
            ++this.m_numSubmittedValues;
        }
        catch (SyntaxException e) {
            this.m_submitter.submitMonitorValue(this.m_monitor, -2.0, object, null);
            ++this.m_numSubmittedValues;
            this.m_msgSubmitter.sendMessage(null, "AGENT", "Opm", this.m_monitor, e.getMessage() + " Line: " + object + function + expression, "minor", null);
        }
    }

    public double calculateLine(Map<String, Double> values, String expression, Map<String, Double> previousObjectsCalculated) throws SyntaxException {
        double result;
        Double variableValue;
        HashMap<String, Double> valuesAndCalculatedObjects = new HashMap<String, Double>();
        for (String variableName : values.keySet()) {
            variableValue = values.get(variableName);
            if (variableValue == null) continue;
            valuesAndCalculatedObjects.put(variableName, variableValue);
        }
        for (String variableName : previousObjectsCalculated.keySet()) {
            variableValue = previousObjectsCalculated.get(variableName);
            if (variableValue == null) continue;
            valuesAndCalculatedObjects.put(variableName, variableValue);
        }
        try {
            Expression e = new OpmExpressionBuilder(expression).variables(valuesAndCalculatedObjects.keySet()).build().setVariables(valuesAndCalculatedObjects);
            result = e.evaluate();
        }
        catch (Throwable t) {
            throw new SyntaxException(t);
        }
        return result;
    }

    private String replaceSVALues(String text, HashMap<String, String> svalues) {
        if (text.startsWith(SVAR) && svalues.get(text) != null) {
            text = svalues.get(text);
        } else {
            Matcher ma = m_svarPattern.matcher(text);
            if (ma.matches()) {
                for (Map.Entry<String, String> en : svalues.entrySet()) {
                    text = text.replace(en.getKey(), en.getValue());
                }
            }
        }
        return text;
    }

    public void processSummary(Iterator<String> it, Pattern pattern, List<String> calcs) {
        HashMapArray values = new HashMapArray();
        HashMapArray strvalues = new HashMapArray();
        while (it.hasNext()) {
            String line = it.next();
            Matcher m = pattern.matcher(line);
            if (!m.matches()) continue;
            for (int i = 1; i <= m.groupCount(); ++i) {
                try {
                    String val = m.group(i).trim();
                    strvalues.putIgnoreUnique(SVAR + i, val);
                    strvalues.putIgnoreUnique(VAR + i, val);
                    double v = Double.parseDouble(val.replace(',', '.'));
                    values.putIgnoreUnique(VAR + i, v);
                    continue;
                }
                catch (Throwable e) {
                    values.putIgnoreUnique(VAR + i, null);
                }
            }
        }
        int line = 3;
        Iterator<String> it3 = calcs.iterator();
        while (it3.hasNext()) {
            ++line;
            String function = it3.next();
            this.processFunction(values, strvalues, function);
        }
    }

    public double processFunction(HashMapArray values, HashMapArray strvalues, String function) {
        double res = -1.0;
        String[] arr = function.split("\\s+", 3);
        String object = arr[0];
        if (arr.length < 2) {
            throw new SyntaxException("Function is missed in a line: {" + function + "}");
        }
        if (arr.length < 3) {
            throw new SyntaxException("Calculation is missed in a line: {" + function + "}");
        }
        String func = arr[1];
        String expression = arr[2];
        try {
            if (func.equals(FUNC_SUM)) {
                res = this.sum(values, expression);
            } else if (func.equals(FUNC_MIN)) {
                res = this.min(values, expression);
            } else if (func.equals(FUNC_MAX)) {
                res = this.max(values, expression);
            } else if (func.equals(FUNC_AVG)) {
                res = this.avg(values, expression);
            } else if (func.equals(FUNC_COUNT)) {
                String[] calcs = expression.split("\\s+", 2);
                if (calcs != null && calcs.length > 1) {
                    String regex = calcs[1];
                    Pattern p = null;
                    try {
                        p = Pattern.compile(regex);
                    }
                    catch (Throwable e) {
                        throw new SyntaxException("Invalid pattern \"" + regex + "\" in a line: {" + function + "}");
                    }
                    int matched = 0;
                    ArrayList al = strvalues.getArray(calcs[0]);
                    if (al != null) {
                        Iterator its = al.iterator();
                        while (its.hasNext()) {
                            String s = "" + its.next();
                            Matcher m = p.matcher(s);
                            if (!m.matches()) continue;
                            ++matched;
                        }
                    }
                    res = matched;
                } else {
                    ArrayList array;
                    res = calcs != null && calcs.length == 1 ? ((array = strvalues.getArray(calcs[0])) != null ? (double)array.size() : 0.0) : ((array = strvalues.getArray("svar1")) != null ? (double)array.size() : 0.0);
                }
            } else {
                throw new SyntaxException("Incorrect syntax in a line: {" + function + "}");
            }
            this.m_submitter.submitMonitorValue(this.m_monitor, res, object, null);
            ++this.m_numSubmittedValues;
        }
        catch (SyntaxException e) {
            this.m_submitter.submitMonitorValue(this.m_monitor, -2.0, object, null);
            ++this.m_numSubmittedValues;
            this.m_msgSubmitter.sendMessage(null, "AGENT", "Opm", this.m_monitor, e.getLocalizedMessage(), "minor", null);
        }
        return res;
    }

    public void setMessageSubmitter(IMessage submitter) {
        this.m_msgSubmitter = submitter;
    }

    public void stop() {
    }

    public double _sum(List<Double> values) {
        double sumVal = 0.0;
        for (int i = 0; i < values.size(); ++i) {
            Double next = values.get(i);
            if (next == null) continue;
            sumVal += next.doubleValue();
        }
        return sumVal;
    }

    public double _max(List<Double> values) {
        double maxVal = -1.7976931348623157E308;
        for (int i = 0; i < values.size(); ++i) {
            Double next = values.get(i);
            if (next == null || !(next > maxVal)) continue;
            maxVal = next;
        }
        return maxVal;
    }

    public double _min(List<Double> values) {
        double minVal = Double.MAX_VALUE;
        for (int i = 0; i < values.size(); ++i) {
            Double next = values.get(i);
            if (next == null || !(next < minVal)) continue;
            minVal = next;
        }
        return minVal;
    }

    public double _avg(List<Double> values) {
        double avgVal = 0.0;
        int count = 0;
        for (int i = 0; i < values.size(); ++i) {
            Double next = values.get(i);
            if (next == null) continue;
            avgVal += next.doubleValue();
            ++count;
        }
        return avgVal / (double)count;
    }

    public double sum(HashMapArray allData, String expression) {
        double sumVal = 0.0;
        List<Double> in = this.calculateLines(allData, expression);
        sumVal = this._sum(in);
        return sumVal;
    }

    public double min(HashMapArray allData, String expression) {
        double minVal = 0.0;
        List<Double> in = this.calculateLines(allData, expression);
        minVal = this._min(in);
        return minVal;
    }

    public double max(HashMapArray allData, String expression) {
        double maxVal = 0.0;
        List<Double> in = this.calculateLines(allData, expression);
        maxVal = this._max(in);
        return maxVal;
    }

    public double avg(HashMapArray allData, String expression) {
        double avgVal = 0.0;
        List<Double> in = this.calculateLines(allData, expression);
        avgVal = this._avg(in);
        return avgVal;
    }

    public List<Double> calculateLines(HashMapArray allData, String expressionString) {
        Expression expression;
        ArrayList<Double> intermediate = new ArrayList<Double>();
        int rows = allData.getArray("var1").size();
        try {
            expression = new OpmExpressionBuilder(expressionString).variables(allData.keySet()).build();
        }
        catch (Throwable t) {
            throw new SyntaxException("Opm function has wrong syntax: ", t);
        }
        for (int i = 0; i < rows; ++i) {
            for (Object variableName : allData.keySet()) {
                Double variableValue = (Double)allData.getArray(variableName).get(i);
                if (variableValue == null) continue;
                expression.setVariable(variableName.toString(), variableValue);
            }
            try {
                intermediate.add(expression.evaluate());
                continue;
            }
            catch (Throwable t) {
                throw new SyntaxException("Opm function evaluation exception: ", t);
            }
        }
        return intermediate;
    }

    static {
        m_svarPattern = Pattern.compile(".*(svar\\d+).*");
    }

    private class PunchCardLine {
        public Pattern pattern;
        public List<String> functions = new ArrayList<String>();

        public PunchCardLine(String stringPattern, String[] variables) {
            this.pattern = Pattern.compile(stringPattern);
            for (int i = 0; i < variables.length; ++i) {
                this.functions.add(variables[i].trim());
            }
        }
    }

    private class PunchCard {
        public Pattern splitPattern;
        public String objectExpression;
        public String valueExpression;
        public Values values;
        public List<PunchCardLine> lines = new ArrayList<PunchCardLine>();

        public PunchCard(String splitPatternString, String objectExpression, String valueExpression) {
            this.splitPattern = Pattern.compile(splitPatternString);
            this.objectExpression = objectExpression;
            this.valueExpression = valueExpression;
            this.values = new Values();
        }
    }

    private class Values {
        public HashMap<String, Double> doubleValues = new HashMap();
        public HashMap<String, String> stringValues = new HashMap();

        private Values() {
        }

        public void putAll(Values otherValues) {
            this.doubleValues.putAll(otherValues.doubleValues);
            this.stringValues.putAll(otherValues.stringValues);
        }

        public int size() {
            return this.stringValues.size() + this.doubleValues.size();
        }

        public String toString() {
            return this.doubleValues.toString() + " " + this.stringValues.toString();
        }
    }

    public class StopProcessing
    extends Exception {
    }
}

