/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.agent.util.NullMonSubmitter;
import com.blixx.agent.util.Utils;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitorExtPerf;
import com.blixx.ext.IMonitorSubmitter;
import com.blixx.ext.IPerfLog;
import com.blixx.ext.PerfDoubleMetric;
import com.blixx.ext.PerfStringMetric;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.net.pop3.POP3Client;
import org.apache.commons.net.pop3.POP3MessageInfo;

public class POP3Monitor
implements IMonitorExtPerf {
    public String[] m_hostnames = null;
    public String m_monitor = "";
    public long m_connectTime = 0L;
    public long m_responseTime = 0L;
    public IMonitorSubmitter m_submitter = null;
    public IPerfLog m_perfSubmitter = null;

    public static POP3Monitor getInstance(String monitor, String[] parameters) {
        POP3Monitor mon = new POP3Monitor();
        mon.m_hostnames = parameters;
        mon.m_monitor = monitor;
        return mon;
    }

    public void setInterval(long ms) {
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
        this.m_submitter = submitter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String runMonitor() {
        for (int i = 0; i < this.m_hostnames.length; ++i) {
            InetAddress addr2;
            int availability = -4;
            double connectTime = -1.0;
            double mails = -1.0;
            double size = -1.0;
            String[] args = Utils.split(this.m_hostnames[i]);
            if (args.length != 3) continue;
            String hostname = args[0];
            int port = 110;
            int posC = hostname.indexOf(58);
            if (posC != -1) {
                hostname = args[0].substring(0, posC);
                String portStr = args[0].substring(posC + 1);
                try {
                    port = Integer.parseInt(portStr);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            String user = null;
            String pass = null;
            if (args.length > 1) {
                user = args[1];
                if (args.length > 2) {
                    pass = args[2];
                }
            }
            long start = System.currentTimeMillis();
            POP3Client pop3 = new POP3Client();
            pop3.setDefaultTimeout(30000);
            HashMap<String, Object> opts = new HashMap<String, Object>();
            opts.put("host", hostname);
            opts.put("user", user);
            try {
                pop3.connect(hostname, port);
                if (pop3.login(user, pass)) {
                    this.m_connectTime = System.currentTimeMillis() - start;
                    availability = 5;
                    POP3MessageInfo messages = pop3.status();
                    this.m_responseTime = System.currentTimeMillis() - start - this.m_connectTime;
                    if (messages == null) {
                        availability = 3;
                        try {
                            pop3.disconnect();
                        }
                        catch (Throwable throwable) {}
                    } else {
                        mails = messages.number;
                        size = messages.size / 0x100000;
                        opts.put("mails", messages.number);
                        opts.put("size", messages.size / 0x100000);
                    }
                } else {
                    this.m_connectTime = System.currentTimeMillis() - start;
                    availability = 1;
                    try {
                        pop3.logout();
                    }
                    catch (Throwable messages) {
                        // empty catch block
                    }
                    try {
                        pop3.disconnect();
                    }
                    catch (Throwable messages) {
                        // empty catch block
                    }
                }
                long totalTime = this.m_connectTime + this.m_responseTime;
                opts.put("time", totalTime);
                opts.put("ctime", this.m_connectTime);
                opts.put("rtime", this.m_responseTime);
            }
            catch (UnknownHostException e) {
                availability = -6;
            }
            catch (SocketException e) {
                availability = -4;
                try {
                    addr2 = InetAddress.getByName(hostname);
                    if (addr2.isReachable(3000)) {
                        availability = -3;
                    }
                }
                catch (Throwable addr2) {
                    // empty catch block
                }
            }
            catch (SocketTimeoutException e) {
                availability = -4;
                try {
                    addr2 = InetAddress.getByName(hostname);
                    if (addr2.isReachable(3000)) {
                        availability = -3;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            catch (IOException e) {
                availability = -5;
            }
            finally {
                try {
                    pop3.disconnect();
                }
                catch (Throwable e) {}
            }
            long totalTime = this.m_connectTime + this.m_responseTime;
            if (availability < 0) {
                totalTime = -1L;
            }
            if (totalTime < 0L) {
                this.m_responseTime = -1L;
                this.m_connectTime = -1L;
            }
            this.m_submitter.submitMonitorValue(this.m_monitor, (double)totalTime, user + "@" + hostname + ":TIME", opts);
            this.m_submitter.submitMonitorValue(this.m_monitor, (double)availability, user + "@" + hostname + ":AVAILABILITY", opts);
            if (this.m_perfSubmitter == null) continue;
            ArrayList<Object> perfMetrics = new ArrayList<Object>();
            perfMetrics.add(new PerfStringMetric("HOST", hostname));
            perfMetrics.add(new PerfDoubleMetric("PORT", (double)port));
            perfMetrics.add(new PerfStringMetric("OBJECT", user));
            perfMetrics.add(new PerfDoubleMetric("RTIME", (double)this.m_responseTime));
            perfMetrics.add(new PerfDoubleMetric("CTIME", (double)this.m_connectTime));
            perfMetrics.add(new PerfDoubleMetric("TTIME", (double)totalTime));
            perfMetrics.add(new PerfDoubleMetric("MAILCOUNT", mails));
            perfMetrics.add(new PerfDoubleMetric("SIZEMB", size));
            perfMetrics.add(new PerfDoubleMetric("STATUS", (double)availability));
            this.m_perfSubmitter.submitPerfRow("IS_POP", System.currentTimeMillis(), perfMetrics);
        }
        return null;
    }

    public void setMessageSubmitter(IMessage submitter) {
    }

    public void stop() {
    }

    public void setPerfSubmitter(IPerfLog submitter) {
        this.m_perfSubmitter = submitter;
    }

    public static void main(String[] args) {
        POP3Monitor pm = POP3Monitor.getInstance("OK5", new String[]{"emano b_streshnyev 4boris"});
        pm.setMonitorSubmitter(new NullMonSubmitter());
        pm.runMonitor();
        pm = POP3Monitor.getInstance("LoginFailed1", new String[]{"emano b_streshnyev aaa"});
        pm.setMonitorSubmitter(new NullMonSubmitter());
        pm.runMonitor();
        pm = POP3Monitor.getInstance("HostUnknown-6", new String[]{"emano4 b_streshnyev aaa"});
        pm.setMonitorSubmitter(new NullMonSubmitter());
        pm.runMonitor();
        pm = POP3Monitor.getInstance("NoPOP3Server-4", new String[]{"localhost b_streshnyev 4boris"});
        pm.setMonitorSubmitter(new NullMonSubmitter());
        pm.runMonitor();
    }
}

