/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.agent.monitors.Opm;
import com.blixx.agent.util.ExecResult;
import com.blixx.agent.util.NullMonSubmitter;
import com.blixx.agent.util.NullMsgSubmitter;
import com.blixx.agent.util.NullPerfSubmitter;
import com.blixx.agent.util.SyntaxException;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitorExtPerf;
import com.blixx.ext.IMonitorSubmitter;
import com.blixx.ext.IPerfLog;
import com.blixx.ext.IPerfMetric;
import com.blixx.ext.PerfDoubleMetric;
import com.blixx.ext.PerfLongMetric;
import com.blixx.ext.PerfStringMetric;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

public class PerfCollector
implements IMonitorExtPerf {
    public static final String TABLE_SUMMARY = "TableSummary";
    public static final String LINE_BY_LINE = "LineByLine";
    public static final String PUNCH_CARD = "PunchCard";
    public IMonitorSubmitter m_submitter = null;
    public IPerfLog m_perfSubmitter = null;
    public IMessage m_messageSubmitter = null;
    public String m_monitorName = null;
    public long m_interval = 300000L;
    public List<PerfRow> m_to_submit = new ArrayList<PerfRow>();
    public List<PerfOpm> m_execs = new ArrayList<PerfOpm>();
    Properties m_agentProps = new Properties();
    Map<String, List<IPerfMetric>> runtimeTableSummary = new HashMap<String, List<IPerfMetric>>();
    Map<String, List<IPerfMetric>> runtimeTableSummaryVARCHARS = new HashMap<String, List<IPerfMetric>>();

    public static PerfCollector getInstance(String monitor, String[] parameters) {
        PerfCollector pc = new PerfCollector();
        pc.m_monitorName = monitor;
        ArrayList<String> curr = new ArrayList<String>();
        for (int i = 0; i < parameters.length; ++i) {
            String line = parameters[i];
            if (i > 0 && line.trim().length() == 0 && curr.size() > 0) {
                PerfCollector perfCollector = pc;
                perfCollector.getClass();
                PerfOpm popm = perfCollector.new PerfOpm(curr);
                pc.m_execs.add(popm);
                curr = new ArrayList();
                continue;
            }
            curr.add(line);
        }
        if (curr.size() > 0) {
            PerfCollector perfCollector = pc;
            perfCollector.getClass();
            PerfOpm popm = perfCollector.new PerfOpm(curr);
            pc.m_execs.add(popm);
        }
        return pc;
    }

    public void setPerfSubmitter(IPerfLog submitter) {
        this.m_perfSubmitter = submitter;
    }

    public void setInterval(long ms) {
        this.m_interval = ms;
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
        this.m_submitter = submitter;
    }

    public String runMonitor() {
        try {
            FileInputStream fis = new FileInputStream("conf/agent.conf");
            this.m_agentProps.load(fis);
            fis.close();
        }
        catch (Throwable fis) {
            // empty catch block
        }
        this.m_to_submit.clear();
        for (int i = 0; i < this.m_execs.size(); ++i) {
            PerfOpm popm = this.m_execs.get(i);
            popm.setInterval(this.m_interval);
            popm.run();
        }
        for (PerfRow row : this.m_to_submit) {
            if (row.isEmpty()) continue;
            this.m_perfSubmitter.submitPerfRow(row.getClassName(), row.getTime(), row.getMetricList());
        }
        return this.m_monitorName + "=0";
    }

    public void setMessageSubmitter(IMessage submitter) {
        this.m_messageSubmitter = submitter;
    }

    public void stop() {
    }

    public static void main(String[] args) {
        String[] arr = new String[]{"sh -c \"LC_ALL=C ifconfig\"", PUNCH_CARD, "\\s*(\\w+)\\s+Link.*", "\\s*(\\w+)\\s+Link.*", "InterfaceName = svar1; Foo=svar1\\;svar1\\;asdf", "\\s*RX packets:(\\d+)\\s+errors:(\\d+)\\s+dropped:(\\d+)\\s+overruns:(\\d+)\\s+frame:(\\d*).*", "RXPaketNumber=var1; RXErrors=var2; RXLost=var3; RXOverflow=var4; RXWindow = var5", "\\s*TX packets:(\\d+)\\s+errors:(\\d+)\\s+dropped:(\\d+)\\s+overruns:(\\d+)\\s+carrier:(\\d*).*", "TXPaketNumber=var1; TXErrors=var2; TXLost=var3; TXOverflow=var4; TXCarrier=var5", "\\s*collisions:(\\d+)\\s+txqueuelen:(\\d+).*", "Collisions=var1; SendQueueLength = var2", "\\s*RX bytes:(\\d+)\\s+\\(\\d+\\.\\d+\\s+(?:B|KB|MB|GB|TB)\\)\\s+TX bytes:(\\d+)\\s+\\(\\d+\\.\\d+\\s+(?:B|KB|MB|GB|TB)\\).*", "RXMBytes= round(var1 / 1024, 2); TXMBytes=round(var2 / 1024, 2)", "TableMapping", "TTT|VARCHAR|HOST = <$AGENT_HOST>", "TTT|VARCHAR|INSTANCE = <$InterfaceName>", "TTT|TYPE_DOUBLE|RXERRORPERCENTAGE = 100 * <$RXErrors> / (<$RXPaketNumber> + 1)"};
        for (int i = 0; i < arr.length; ++i) {
            System.out.println(arr[i]);
        }
        PerfCollector pc = PerfCollector.getInstance("TESTPerfMon", arr);
        pc.setPerfSubmitter(new NullPerfSubmitter());
        pc.setMessageSubmitter(new NullMsgSubmitter());
        pc.setMonitorSubmitter(new NullMonSubmitter());
        pc.runMonitor();
        System.out.println();
        System.out.println("*****");
        pc.runMonitor();
        System.out.println();
        pc.runMonitor();
        System.out.println();
    }

    public class PerfRow {
        private String m_className = null;
        private List<IPerfMetric> m_metrics = new ArrayList<IPerfMetric>();
        private String m_keys = "";
        private long m_time;

        public PerfRow(String className, long time, List<IPerfMetric> metrics) {
            this.m_className = className;
            this.m_metrics = metrics;
            this.m_time = time;
            for (int i = 0; i < metrics.size(); ++i) {
                IPerfMetric pm = metrics.get(i);
                if (pm.getType() != "VARCHAR") continue;
                this.m_keys = this.m_keys + pm.getValue();
            }
        }

        public String getKeys() {
            return this.m_keys;
        }

        public String getClassName() {
            return this.m_className;
        }

        public List<IPerfMetric> getMetricList() {
            return this.m_metrics;
        }

        public boolean isEmpty() {
            return this.m_metrics.size() == 0;
        }

        public boolean equals(Object obj) {
            PerfRow row = (PerfRow)obj;
            return this.m_className.equals(row.getClassName()) && this.m_keys.equals(row.getKeys());
        }

        public void mergeFieldsFrom(PerfRow row) {
            if (this.equals(row)) {
                for (IPerfMetric ipm : row.m_metrics) {
                    if (this.contains(ipm)) continue;
                    this.m_metrics.add(ipm);
                }
            }
        }

        public boolean contains(IPerfMetric pm) {
            for (IPerfMetric ipm : this.m_metrics) {
                if (!ipm.getName().equalsIgnoreCase(pm.getName())) continue;
                return true;
            }
            return false;
        }

        public long getTime() {
            return this.m_time;
        }
    }

    public class PerfOpm
    implements IMonitorSubmitter {
        HashMap m_previousValues = new HashMap();
        public Opm m_opm = null;
        public IMonitorSubmitter m_monSubmitter = null;
        public Map<String, List<String>> m_howToSubmit = new HashMap<String, List<String>>(2);
        public Map<String, Pattern> m_patterns = new HashMap<String, Pattern>(2);
        Boolean isTableSummary = null;

        public PerfOpm(List<String> perfBlock) {
            ArrayList<String> nopmBlock = new ArrayList<String>();
            nopmBlock.add(perfBlock.get(0));
            double counter = 0.0;
            String pattern = null;
            ArrayList<String> hts = new ArrayList<String>();
            String blockNumber = "block" + counter;
            this.m_howToSubmit.put(blockNumber, hts);
            for (int i = 1; i < perfBlock.size(); ++i) {
                String line = perfBlock.get(i);
                if (line.trim().equalsIgnoreCase(PerfCollector.LINE_BY_LINE) || line.trim().equalsIgnoreCase(PerfCollector.TABLE_SUMMARY) || line.trim().equalsIgnoreCase(PerfCollector.PUNCH_CARD)) {
                    if (line.trim().equalsIgnoreCase(PerfCollector.PUNCH_CARD) && this.isTableSummary != null) {
                        nopmBlock.add(line);
                    }
                    if (this.isTableSummary == null) {
                        nopmBlock.add(line);
                    } else {
                        hts = new ArrayList();
                        blockNumber = "block" + (counter += 1.0);
                        this.m_howToSubmit.put(blockNumber, hts);
                    }
                    pattern = perfBlock.get(++i);
                    Pattern patternObj = Pattern.compile(pattern);
                    this.m_patterns.put(blockNumber, patternObj);
                    if (this.isTableSummary != null && this.isTableSummary.booleanValue()) continue;
                    nopmBlock.add(pattern);
                    if (line.trim().equalsIgnoreCase(PerfCollector.LINE_BY_LINE)) {
                        nopmBlock.add("DUMMY = " + counter);
                        this.isTableSummary = false;
                        continue;
                    }
                    if (line.trim().equalsIgnoreCase(PerfCollector.PUNCH_CARD)) {
                        nopmBlock.add("PUNCH_CARD_DUMMY");
                        nopmBlock.add("= " + counter);
                        ++i;
                        while (i < perfBlock.size() && !"TableMapping".equals(perfBlock.get(i).trim())) {
                            nopmBlock.add(perfBlock.get(i));
                            ++i;
                        }
                        this.isTableSummary = false;
                        continue;
                    }
                    nopmBlock.add(blockNumber + " = " + counter);
                    this.isTableSummary = true;
                    continue;
                }
                if (this.isTableSummary.booleanValue() && line.contains("VARCHAR")) {
                    try {
                        String[] parts = line.split("\\s*=\\s*");
                        if (parts.length != 2) continue;
                        String strValue = parts[1];
                        String field = null;
                        String pclass = null;
                        String[] perfDef = parts[0].split("\\s*\\|\\s*");
                        if (perfDef.length != 3) continue;
                        pclass = perfDef[0];
                        field = perfDef[2];
                        try {
                            strValue = strValue.replace("<$AGENT_HOST>", PerfCollector.this.m_agentProps.getProperty("AGENT_HOST"));
                            strValue = strValue.replace("<$AGENT_IP>", PerfCollector.this.m_agentProps.getProperty("AGENT_IP"));
                            strValue = strValue.replace("<$AGENT_ID>", PerfCollector.this.m_agentProps.getProperty("AGENT_ID"));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        PerfStringMetric pm = new PerfStringMetric(field, strValue);
                        if (pm == null) continue;
                        String block_and_class = blockNumber + '|' + pclass;
                        List<IPerfMetric> listForClass = PerfCollector.this.runtimeTableSummaryVARCHARS.get(block_and_class);
                        if (listForClass == null) {
                            listForClass = new ArrayList<IPerfMetric>();
                            PerfCollector.this.runtimeTableSummaryVARCHARS.put(block_and_class, listForClass);
                        }
                        listForClass.add((IPerfMetric)pm);
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                hts.add(line);
            }
            this.m_opm = Opm.getInstance(PerfCollector.this.m_monitorName, nopmBlock.toArray(new String[0]));
            this.m_opm.setMonitorSubmitter(this);
            this.m_opm.setInterval(PerfCollector.this.m_interval);
        }

        public void run() {
            try {
                this.m_opm.setMessageSubmitter(PerfCollector.this.m_messageSubmitter);
                PerfCollector.this.runtimeTableSummary.clear();
                for (Map.Entry<String, List<IPerfMetric>> en : PerfCollector.this.runtimeTableSummaryVARCHARS.entrySet()) {
                    PerfCollector.this.runtimeTableSummary.put(en.getKey(), new ArrayList(en.getValue()));
                }
                if (this.isTableSummary.booleanValue()) {
                    ExecResult er = this.m_opm.execute();
                    for (String blknmr : this.m_howToSubmit.keySet()) {
                        Iterator<String> itStr = er.m_outMessages.iterator();
                        List<String> calcs = this.m_howToSubmit.get(blknmr);
                        ArrayList<String> calcsMarkedByBlock = new ArrayList<String>(calcs.size());
                        for (int i = 0; i < calcs.size(); ++i) {
                            calcsMarkedByBlock.add(blknmr + '|' + calcs.get(i));
                        }
                        this.m_opm.processSummary(itStr, this.m_patterns.get(blknmr), calcsMarkedByBlock);
                    }
                } else {
                    this.m_opm.runMonitor();
                }
                try {
                    long TIME = System.currentTimeMillis();
                    for (Map.Entry<String, List<IPerfMetric>> entry : PerfCollector.this.runtimeTableSummary.entrySet()) {
                        String blk_class = entry.getKey();
                        String perfClass = blk_class.split("\\|", 2)[1];
                        PerfRow runtimeRow = new PerfRow(perfClass, TIME, entry.getValue());
                        PerfCollector.this.m_to_submit.add(runtimeRow);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (message == null) {
                    message = e.getClass().getName();
                }
                PerfCollector.this.m_messageSubmitter.sendMessage(null, "Collector", "PERF", PerfCollector.this.m_monitorName, message, "warning", null);
            }
        }

        public void submitMonitorValue(String monitor, double v, String object, HashMap optionalVariables) {
            try {
                if (optionalVariables == null) {
                    this.submitTableSummary(v, object);
                } else if ("PUNCH_CARD_DUMMY".equals(object)) {
                    this.submitPunchCard(v, optionalVariables);
                } else {
                    this.submitLineByLine(v, optionalVariables);
                }
            }
            catch (Throwable e) {
                String message = e.getMessage();
                if (message == null) {
                    message = e.getClass().getName();
                }
                PerfCollector.this.m_messageSubmitter.sendMessage(null, "Collector", "PERF", monitor, message, "warning", null);
            }
        }

        private void submitPunchCard(double blockNumber, HashMap optionalVariables) {
            HashMap<String, Double> doubleValues = new HashMap<String, Double>();
            for (String variableName : optionalVariables.keySet()) {
                String variableValue = optionalVariables.get(variableName).toString();
                try {
                    doubleValues.put(variableName, Double.parseDouble(variableValue.replace(',', '.')));
                }
                catch (Throwable throwable) {}
            }
            this.submitPerformanceLines(blockNumber, doubleValues, optionalVariables, PerfCollector.PUNCH_CARD);
        }

        private void submitTableSummary(double v, String object) {
            String[] tmetric = object.split("\\|", 2);
            String blkNum = tmetric[0];
            String rest = tmetric[1];
            List<String> howToSubmitList = this.m_howToSubmit.get(blkNum);
            for (String h2s : howToSubmitList) {
                String[] temp = h2s.split("\\s+");
                if (temp == null || temp.length <= 1) continue;
                String perfDefine = temp[0];
                String[] arrPD = rest.split("\\s*\\|\\s*");
                String field = null;
                String type = null;
                String pclass = null;
                PerfDoubleMetric pm = null;
                if (arrPD.length == 3) {
                    pclass = arrPD[0];
                    type = arrPD[1];
                    field = arrPD[2];
                    if (type.equalsIgnoreCase("DOUBLE")) {
                        if (perfDefine.equals(rest)) {
                            pm = new PerfDoubleMetric(field, v);
                        }
                    } else if (type.equalsIgnoreCase("BIGINT")) {
                        if (perfDefine.equals(rest)) {
                            pm = new PerfLongMetric(field, (long)v);
                        }
                    } else if (type.equalsIgnoreCase("VARCHAR")) {
                        // empty if block
                    }
                }
                if (pm == null) continue;
                List<IPerfMetric> listForClass = PerfCollector.this.runtimeTableSummary.get(blkNum + '|' + pclass);
                if (listForClass == null) {
                    listForClass = new ArrayList<IPerfMetric>();
                    PerfCollector.this.runtimeTableSummary.put(blkNum + '|' + pclass, listForClass);
                }
                listForClass.add((IPerfMetric)pm);
            }
        }

        private void submitLineByLine(double blockNumber, HashMap optionalVariables) {
            HashMap<String, Double> values = new HashMap<String, Double>();
            for (String name : optionalVariables.keySet()) {
                if (!name.startsWith("svar")) continue;
                String val = (String)optionalVariables.get(name);
                try {
                    values.put(name.substring(1), Double.parseDouble(val.replace(',', '.')));
                }
                catch (Throwable throwable) {}
            }
            this.submitPerformanceLines(blockNumber, values, optionalVariables, PerfCollector.LINE_BY_LINE);
        }

        private void submitPerformanceLines(double blockNumber, Map<String, Double> doubleValues, HashMap optionalVariables, String opmType) {
            long TIME = System.currentTimeMillis();
            HashMap runtime = new HashMap();
            List<String> howToSubmitList = this.m_howToSubmit.get("block" + blockNumber);
            String rowkey = "";
            HashMap<String, Double> processedFieldValues = new HashMap<String, Double>();
            for (int ind = 0; ind < howToSubmitList.size(); ++ind) {
                String howToSubmit = howToSubmitList.get(ind);
                String[] arr1 = howToSubmit.split("\\s+");
                String perfDefine = arr1[0];
                String func = arr1[1];
                StringBuilder expressionBuilder = new StringBuilder();
                for (int j = 2; j < arr1.length; ++j) {
                    String token = arr1[j];
                    Double processed = (Double)processedFieldValues.get(token);
                    if (processed != null) {
                        token = "" + processed;
                    }
                    expressionBuilder.append(token).append(' ');
                }
                String expression = expressionBuilder.toString();
                String[] arr = perfDefine.split("\\s*\\|\\s*");
                String field = null;
                String type = null;
                String pclass = null;
                PerfDoubleMetric pm = null;
                if (arr.length != 3) continue;
                pclass = arr[0];
                type = arr[1];
                field = arr[2];
                if (type.equalsIgnoreCase("DOUBLE")) {
                    double res;
                    block25: {
                        res = 0.0;
                        if (PerfCollector.PUNCH_CARD.equals(opmType)) {
                            expression = expression.replaceAll("[<\\$>]", "");
                        }
                        try {
                            res = this.m_opm.calculateLine(doubleValues, expression, new LinkedHashMap<String, Double>());
                        }
                        catch (SyntaxException e) {
                            if (e.getMessage().contains("Division by 0")) break block25;
                            throw e;
                        }
                    }
                    if (func.equalsIgnoreCase("DELTA")) {
                        res = this.delta(rowkey + field, res);
                    }
                    pm = new PerfDoubleMetric(field, res);
                    processedFieldValues.put(field, res);
                } else if (type.equalsIgnoreCase("BIGINT")) {
                    double res;
                    block26: {
                        res = 0.0;
                        if (PerfCollector.PUNCH_CARD.equals(opmType)) {
                            expression = expression.replaceAll("[<\\$>]", "");
                        }
                        try {
                            res = this.m_opm.calculateLine(doubleValues, expression, new LinkedHashMap<String, Double>());
                        }
                        catch (SyntaxException e) {
                            if (e.getMessage().contains("Division by 0")) break block26;
                            throw e;
                        }
                    }
                    if (func.equalsIgnoreCase("DELTA")) {
                        res = this.delta(rowkey + field, res);
                    }
                    pm = new PerfLongMetric(field, (long)res);
                    processedFieldValues.put(field, res);
                } else {
                    expression = expression.trim();
                    if (PerfCollector.LINE_BY_LINE.equals(opmType)) {
                        for (int k = 0; k < optionalVariables.size(); ++k) {
                            String svarName = "svar" + (k + 1);
                            String val = (String)optionalVariables.get(svarName);
                            if (val == null) continue;
                            expression = expression.replace(svarName, val);
                        }
                    } else if (PerfCollector.PUNCH_CARD.equals(opmType)) {
                        expression = this.m_opm.replaceVariables(expression, optionalVariables, true);
                    }
                    try {
                        expression = expression.replace("<$AGENT_HOST>", PerfCollector.this.m_agentProps.getProperty("AGENT_HOST"));
                        expression = expression.replace("<$AGENT_IP>", PerfCollector.this.m_agentProps.getProperty("AGENT_IP"));
                        expression = expression.replace("<$AGENT_ID>", PerfCollector.this.m_agentProps.getProperty("AGENT_ID"));
                    }
                    catch (Throwable k) {
                        // empty catch block
                    }
                    pm = new PerfStringMetric(field, expression);
                    rowkey = rowkey + expression;
                }
                if (pm == null) continue;
                ArrayList<PerfDoubleMetric> listForClass = (ArrayList<PerfDoubleMetric>)runtime.get(pclass);
                if (listForClass == null) {
                    listForClass = new ArrayList<PerfDoubleMetric>();
                    runtime.put(pclass, listForClass);
                }
                boolean duplFound = false;
                for (int k = 0; k < listForClass.size(); ++k) {
                    IPerfMetric stored = (IPerfMetric)listForClass.get(k);
                    if (!stored.getName().equalsIgnoreCase(field)) continue;
                    duplFound = true;
                    listForClass.set(k, pm);
                    break;
                }
                if (duplFound) continue;
                listForClass.add(pm);
            }
            for (String perfClassName : runtime.keySet()) {
                List list = (List)runtime.get(perfClassName);
                if (list == null || list.isEmpty()) continue;
                PerfRow runtimeRow = new PerfRow(perfClassName, TIME, list);
                int posOfStored = PerfCollector.this.m_to_submit.indexOf(runtimeRow);
                if (posOfStored != -1) {
                    PerfRow stored = PerfCollector.this.m_to_submit.get(posOfStored);
                    stored.mergeFieldsFrom(runtimeRow);
                    continue;
                }
                PerfCollector.this.m_to_submit.add(runtimeRow);
            }
        }

        private double delta(String object, double res) {
            ArrayList<Number> al = new ArrayList<Number>();
            al.add(res);
            al.add(System.currentTimeMillis());
            if (this.m_previousValues.containsKey(object)) {
                ArrayList stored = (ArrayList)this.m_previousValues.get(object);
                try {
                    Double pr = (Double)stored.get(0);
                    res -= pr.doubleValue();
                    if (res < 0.0) {
                        res = 0.0;
                    }
                }
                catch (Throwable e) {
                    res = 0.0;
                }
            } else {
                res = 0.0;
            }
            this.m_previousValues.put(object, al);
            return res;
        }

        public void setInterval(long millis) {
            this.m_opm.setInterval(millis);
        }
    }
}

