/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitorExtPerf;
import com.blixx.ext.IMonitorSubmitter;
import com.blixx.ext.IPerfLog;
import com.blixx.ext.PerfDoubleMetric;
import com.blixx.ext.PerfStringMetric;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

public class PortCheck
implements IMonitorExtPerf {
    private int TIMEOUT = 30000;
    public String m_monitor = "";
    public IMonitorSubmitter m_submitter = null;
    public IPerfLog m_perfSubmitter = null;
    public IMessage m_messageSubmitter = null;
    public String[] m_urlStr = null;
    public long m_interval = 300000L;

    public static IMonitorExtPerf getInstance(String monitor, String[] urls) {
        PortCheck mon = new PortCheck();
        mon.m_monitor = monitor;
        LinkedList<String> args = new LinkedList<String>();
        for (int i = 0; i < urls.length; ++i) {
            String arg = urls[i];
            if (arg.startsWith("TIMEOUT=")) {
                int ch = arg.indexOf(61);
                String timeout = arg.substring(ch + 1).trim();
                mon.TIMEOUT = Integer.parseInt(timeout);
                continue;
            }
            if (arg == null || arg.trim().length() == 0) continue;
            args.add(arg.trim());
        }
        mon.m_urlStr = args.toArray(new String[0]);
        return mon;
    }

    public void setPerfSubmitter(IPerfLog submitter) {
        this.m_perfSubmitter = submitter;
    }

    public void setInterval(long ms) {
        this.m_interval = ms;
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
        this.m_submitter = submitter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String runMonitor() {
        for (String url : this.m_urlStr) {
            InetSocketAddress bindpoint;
            if (url == null || url.length() <= 0) continue;
            boolean udp = false;
            int startHost = 0;
            if (url.toLowerCase().startsWith("udp ")) {
                udp = true;
                startHost = 4;
            } else if (url.toLowerCase().startsWith("tcp ")) {
                startHost = 4;
            }
            int colon = url.indexOf(58);
            String host = "localhost";
            int port = -1;
            if (colon != -1) {
                host = url.substring(startHost, colon);
                try {
                    port = Integer.parseInt(url.substring(colon + 1));
                }
                catch (Throwable throwable) {}
            } else {
                try {
                    port = Integer.parseInt(url.substring(startHost));
                    url = host + ':' + port;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (port == -1) {
                this.m_submitter.submitMonitorValue(this.m_monitor, -7.0, url, null);
                continue;
            }
            HashMap<String, String> optVars = new HashMap<String, String>();
            optVars.put("host", host);
            optVars.put("port", "" + port);
            if (udp) {
                optVars.put("protocol", "UDP");
            } else {
                optVars.put("protocol", "TCP");
            }
            long connectTime = 0L;
            double value = -1.0;
            if (!udp) {
                Socket sc = new Socket();
                bindpoint = null;
                try {
                    bindpoint = new InetSocketAddress(host, port);
                    sc.setSoTimeout(this.TIMEOUT);
                    long start = System.currentTimeMillis();
                    sc.connect(bindpoint);
                    connectTime = System.currentTimeMillis() - start;
                    value = 5.0;
                }
                catch (Throwable e) {
                    value = -3.0;
                }
                finally {
                    try {
                        sc.close();
                    }
                    catch (Throwable start) {}
                }
            } else {
                DatagramSocket ds = null;
                bindpoint = null;
                try {
                    ds = new DatagramSocket();
                    bindpoint = new InetSocketAddress(host, port);
                    ds.setSoTimeout(this.TIMEOUT);
                    long start = System.currentTimeMillis();
                    ds.connect(bindpoint);
                    connectTime = System.currentTimeMillis() - start;
                    value = 5.0;
                }
                catch (Throwable e) {
                    value = -3.0;
                }
                finally {
                    try {
                        ds.close();
                    }
                    catch (Throwable start) {}
                }
            }
            this.m_submitter.submitMonitorValue(this.m_monitor, value, url, optVars);
            if (this.m_perfSubmitter == null) continue;
            ArrayList<Object> perfMetrics = new ArrayList<Object>();
            perfMetrics.add(new PerfStringMetric("HOST", host));
            if (udp) {
                perfMetrics.add(new PerfStringMetric("PROTOCOL", "UDP"));
            } else {
                perfMetrics.add(new PerfStringMetric("PROTOCOL", "TCP"));
            }
            perfMetrics.add(new PerfDoubleMetric("PORT", (double)port));
            perfMetrics.add(new PerfDoubleMetric("CTIME", (double)connectTime));
            perfMetrics.add(new PerfDoubleMetric("STATUS", value));
            this.m_perfSubmitter.submitPerfRow("IS_PORTCHECK", System.currentTimeMillis(), perfMetrics);
        }
        return null;
    }

    public void setMessageSubmitter(IMessage submitter) {
        this.m_messageSubmitter = submitter;
    }

    public void stop() {
    }
}

