/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.agent.util.NullMonSubmitter;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitorExtPerf;
import com.blixx.ext.IMonitorSubmitter;
import com.blixx.ext.IPerfLog;
import com.blixx.ext.PerfDoubleMetric;
import com.blixx.ext.PerfStringMetric;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.jradiusclient.RadiusAttribute;
import net.sourceforge.jradiusclient.RadiusClient;
import net.sourceforge.jradiusclient.RadiusPacket;
import net.sourceforge.jradiusclient.exception.InvalidParameterException;
import net.sourceforge.jradiusclient.exception.RadiusException;
import net.sourceforge.jradiusclient.util.ChapUtil;

public class RadiusMonitor
implements IMonitorExtPerf {
    public String m_monitor = "";
    public long m_connectTime = 0L;
    public long m_responseTime = 0L;
    public IMonitorSubmitter m_submitter = null;
    public IPerfLog m_perfSubmitter = null;
    public IMessage m_msgSubmitter = null;
    public List<RParam> m_hosts = new ArrayList<RParam>();

    public static RadiusMonitor getInstance(String monitor, String[] parameters) {
        RadiusMonitor mon = new RadiusMonitor();
        for (int i = 0; i < parameters.length; ++i) {
            List<RParam> list = mon.m_hosts;
            RadiusMonitor radiusMonitor = mon;
            radiusMonitor.getClass();
            list.add(radiusMonitor.new RParam(parameters[i]));
        }
        mon.m_monitor = monitor;
        return mon;
    }

    public void setPerfSubmitter(IPerfLog submitter) {
        this.m_perfSubmitter = submitter;
    }

    public void setInterval(long ms) {
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
        this.m_submitter = submitter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String runMonitor() {
        availability = -7;
        rc = null;
        for (i = 0; i < this.m_hosts.size(); ++i) {
            param = this.m_hosts.get(i);
            opts = new HashMap<String, Object>();
            opts.put("host", param.m_host);
            opts.put("user", param.m_user);
            this.m_responseTime = 0L;
            try {
                rc = new RadiusClient(param.m_host, param.m_auPort, param.m_acPort, param.m_sharedSecret, 10000);
                chapUtil = new ChapUtil();
                accessRequest = new RadiusPacket(1);
                user = new RadiusAttribute(1, param.m_user.getBytes());
                accessRequest.setAttribute(user);
                if (param.m_type.equals("chap")) {
                    chapChallenge = chapUtil.getNextChapChallenge(16);
                    accessRequest.setAttribute(new RadiusAttribute(3, RadiusMonitor.chapEncrypt(param.m_pass, chapChallenge, chapUtil)));
                    accessRequest.setAttribute(new RadiusAttribute(60, chapChallenge));
                } else {
                    accessRequest.setAttribute(new RadiusAttribute(2, param.m_pass.getBytes()));
                }
                if (param.m_attributes.size() > 0) {
                    for (Integer type : param.m_attributes.keySet()) {
                        val = param.m_attributes.get(type);
                        accessRequest.setAttribute(new RadiusAttribute(type, val.getBytes()));
                    }
                }
                start = System.currentTimeMillis();
                accessResponse = rc.authenticate(accessRequest, 3);
                this.m_connectTime = System.currentTimeMillis() - start;
                switch (accessResponse.getPacketType()) {
                    case 2: {
                        availability = 5;
                        ** break;
lbl35:
                        // 1 sources

                        break;
                    }
                    case 3: {
                        availability = 1;
                        ** break;
lbl39:
                        // 1 sources

                        break;
                    }
                    case 11: {
                        availability = 5;
                        ** break;
lbl43:
                        // 1 sources

                        break;
                    }
                    default: {
                        availability = -2;
                        break;
                    }
                }
            }
            catch (RadiusException e) {
                opts.put("error", e.getMessage());
                availability = 3;
            }
            catch (InvalidParameterException e) {
                opts.put("error", e.getMessage());
                availability = 3;
            }
            finally {
                try {
                    rc.finalize();
                }
                catch (Throwable e) {}
            }
            totalTime = this.m_connectTime + this.m_responseTime;
            if (availability < 0) {
                totalTime = -1L;
            }
            if (totalTime < 0L) {
                this.m_responseTime = -1L;
                this.m_connectTime = -1L;
            }
            opts.put("method", param.m_type);
            opts.put("time", totalTime);
            opts.put("ctime", this.m_connectTime);
            opts.put("rtime", this.m_responseTime);
            this.m_submitter.submitMonitorValue(this.m_monitor, (double)totalTime, param.m_user + "@" + param.m_type + "@" + param.m_host + ":TIME", opts);
            this.m_submitter.submitMonitorValue(this.m_monitor, (double)availability, param.m_user + "@" + param.m_type + "@" + param.m_host + ":AVAILABILITY", opts);
            if (this.m_perfSubmitter == null) continue;
            perfMetrics = new ArrayList<Object>();
            perfMetrics.add(new PerfStringMetric("HOST", param.m_host));
            perfMetrics.add(new PerfDoubleMetric("PORT", (double)param.m_auPort));
            perfMetrics.add(new PerfStringMetric("OBJECT", param.m_user));
            perfMetrics.add(new PerfStringMetric("METHOD", param.m_type));
            perfMetrics.add(new PerfDoubleMetric("RTIME", (double)this.m_responseTime));
            perfMetrics.add(new PerfDoubleMetric("CTIME", (double)this.m_connectTime));
            perfMetrics.add(new PerfDoubleMetric("TTIME", (double)totalTime));
            perfMetrics.add(new PerfDoubleMetric("STATUS", (double)availability));
            this.m_perfSubmitter.submitPerfRow("IS_RADIUS", System.currentTimeMillis(), perfMetrics);
        }
        return null;
    }

    public void setMessageSubmitter(IMessage submitter) {
        this.m_msgSubmitter = submitter;
    }

    public void stop() {
    }

    private static byte[] chapEncrypt(String plainText, byte[] chapChallenge, ChapUtil chapUtil) {
        byte chapIdentifier = chapUtil.getNextChapIdentifier();
        byte[] chapPassword = new byte[17];
        chapPassword[0] = chapIdentifier;
        System.arraycopy(ChapUtil.chapEncrypt(chapIdentifier, plainText.getBytes(), chapChallenge), 0, chapPassword, 1, 16);
        return chapPassword;
    }

    public static void main(String[] args) {
        RadiusMonitor pm = RadiusMonitor.getInstance("OK5", new String[]{"-h localhost -s testing123 -u testuser -p testpw"});
        pm.setMonitorSubmitter(new NullMonSubmitter());
        pm.runMonitor();
        pm = RadiusMonitor.getInstance("OK5", new String[]{"-h localhost -s testing123 -u testuser -p testpw -m chap"});
        pm.setMonitorSubmitter(new NullMonSubmitter());
        pm.runMonitor();
        pm = RadiusMonitor.getInstance("LOGIN_FAILED1", new String[]{"-h localhost -s testing123 -u testuser -p ggggggg"});
        pm.setMonitorSubmitter(new NullMonSubmitter());
        pm.runMonitor();
    }

    public class RParam {
        public static final String CHAP = "chap";
        public static final String PAP = "pap";
        public String m_host = null;
        public String m_sharedSecret = null;
        public int m_auPort = 1812;
        public int m_acPort = 1813;
        public String m_user = null;
        public String m_pass = null;
        public String m_type = "pap";
        public Map<Integer, String> m_attributes = new LinkedHashMap<Integer, String>();

        public RParam(String input) {
            String[] params = input.split("\\s+");
            for (int i = 0; i < params.length; ++i) {
                String flag = params[i];
                if (flag.equalsIgnoreCase("-h")) {
                    this.m_host = params[++i];
                    continue;
                }
                if (flag.equalsIgnoreCase("-s")) {
                    this.m_sharedSecret = params[++i];
                    continue;
                }
                if (flag.equalsIgnoreCase("-au")) {
                    this.m_auPort = Integer.parseInt(params[++i]);
                    continue;
                }
                if (flag.equalsIgnoreCase("-ac")) {
                    this.m_acPort = Integer.parseInt(params[++i]);
                    continue;
                }
                if (flag.equalsIgnoreCase("-u")) {
                    this.m_user = params[++i];
                    continue;
                }
                if (flag.equalsIgnoreCase("-p")) {
                    this.m_pass = params[++i];
                    continue;
                }
                if (flag.equalsIgnoreCase("-m")) {
                    if (!params[++i].equalsIgnoreCase(CHAP)) continue;
                    this.m_type = CHAP;
                    continue;
                }
                if (!flag.matches("[-]\\d+")) continue;
                try {
                    int num = Integer.parseInt(flag.substring(1));
                    String attrValue = params[++i];
                    this.m_attributes.put(num, attrValue);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

