/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.agent.util.Exec;
import com.blixx.agent.util.ExecResult;
import com.blixx.agent.util.Utils;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitorExtPerf;
import com.blixx.ext.IMonitorSubmitter;
import com.blixx.ext.IPerfLog;
import java.io.File;

public class RunExe
implements IMonitorExtPerf {
    public String m_monitor = "";
    public IMonitorSubmitter m_monSubmitter = null;
    public IPerfLog m_perfSubmitter = null;
    public long m_interval = 300000L;
    public IMessage m_msgSubmitter = null;
    public String[] m_args = null;

    public static RunExe getInstance(String monitor, String[] args) {
        RunExe mon = new RunExe();
        mon.m_monitor = monitor;
        mon.m_args = args;
        return mon;
    }

    public void setPerfSubmitter(IPerfLog submitter) {
        this.m_perfSubmitter = submitter;
    }

    public void setInterval(long ms) {
        this.m_interval = ms;
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
        this.m_monSubmitter = submitter;
    }

    public String runMonitor() {
        String execStrFull = null;
        StringBuilder sb = new StringBuilder();
        for (String s : this.m_args) {
            sb.append(s).append(' ');
        }
        execStrFull = sb.toString();
        execStrFull = execStrFull.trim();
        String[] args = Utils.processQuoted(execStrFull);
        for (int i = 0; i < args.length; ++i) {
            args[i] = Utils.removeQuotesStrict(args[i]);
        }
        String output = null;
        try {
            ExecResult result = new Exec().runNoCMD(new File("spi"), (int)this.m_interval / 1000, args, true);
            this.m_monSubmitter.submitMonitorValue(this.m_monitor, (double)result.resultCode, null, null);
            output = result.getOutput();
            if (result.resultCode != 0) {
                throw new RuntimeException(result.toStringOnError());
            }
        }
        catch (Throwable e) {
            RuntimeException re = new RuntimeException(e.getMessage());
            re.setStackTrace(e.getStackTrace());
            throw re;
        }
        return output;
    }

    public void setMessageSubmitter(IMessage submitter) {
        this.m_msgSubmitter = submitter;
    }

    public void stop() {
    }
}

