/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.agent.monitors.SSHMonitor;
import com.blixx.agent.util.NullMonSubmitter;
import com.blixx.agent.util.Utils;
import com.blixx.ext.IMonitorExtPerf;
import com.blixx.ext.IPerfLog;
import com.blixx.ext.PerfDoubleMetric;
import com.blixx.ext.PerfStringMetric;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.SFTPException;
import com.trilead.ssh2.SFTPv3Client;
import com.trilead.ssh2.SFTPv3DirectoryEntry;
import com.trilead.ssh2.SFTPv3FileHandle;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class SFTPMonitor
extends SSHMonitor
implements IMonitorExtPerf {
    private String m_path;
    private double m_bytes = 0.0;
    private long m_responseTime = 0L;
    public IPerfLog m_perfSubmitter = null;

    public static SFTPMonitor getInstance(String monitorName, String[] parameters) {
        SFTPMonitor mon = new SFTPMonitor();
        mon.m_monitor = monitorName;
        mon.m_hostnames = parameters;
        return mon;
    }

    @Override
    public String runMonitor() {
        for (int i = 0; i < this.m_hostnames.length; ++i) {
            this.m_bytes = 0.0;
            this.m_responseTime = 0L;
            this.m_connectTime = 0L;
            int availability = -4;
            double connectTime = -1.0;
            double speed = -1.0;
            HashMap<String, Object> opts = new HashMap<String, Object>();
            String[] args = Utils.split(this.m_hostnames[i]);
            String user = "anonymous";
            String pass = "FTPSMonitor@boom";
            String hostname = null;
            this.m_path = null;
            int port = 22;
            try {
                String up;
                URL url = new URL(args[0]);
                hostname = url.getHost();
                if (url.getPort() != -1) {
                    port = url.getPort();
                }
                if ((up = url.getUserInfo()) != null) {
                    int eop;
                    String[] upa = up.split(":");
                    user = upa[0];
                    if (upa.length == 2 && (eop = (pass = upa[1]).indexOf(59)) != -1) {
                        pass = pass.substring(0, eop);
                    }
                }
                if (url.getPath().length() > 1) {
                    this.m_path = url.getPath().substring(1);
                }
                opts.put("path", url.getPath());
                opts.put("host", hostname);
                opts.put("user", user);
            }
            catch (MalformedURLException e1) {
                opts.put("error", "Invalid FTP URL");
                this.m_submitter.submitMonitorValue(this.m_monitor, -7.0, "parameter #" + i, opts);
                return null;
            }
            long start = System.currentTimeMillis();
            try {
                this.check(hostname, port, user, pass);
                availability = 5;
            }
            catch (UnknownHostException e) {
                availability = -6;
            }
            catch (ConnectException e) {
                availability = -4;
            }
            catch (SFTPException e) {
                if (e.getServerErrorCode() == 2 || e.getServerErrorCode() == 10) {
                    availability = 4;
                } else if (e.getServerErrorCode() == 3) {
                    availability = 2;
                } else {
                    availability = 3;
                    opts.put("error", e.getMessage());
                }
            }
            catch (IOException e) {
                Throwable tr = e.getCause();
                availability = tr instanceof UnknownHostException ? -6 : (e.getMessage().indexOf("authentication failed") != -1 ? 1 : (tr instanceof ConnectException ? -3 : -5));
            }
            opts.put("bytes", this.m_bytes);
            if (this.m_bytes > 0.0) {
                double bd = this.m_bytes;
                double t = this.m_responseTime;
                speed = bd * 1000.0 / t / 1024.0;
                opts.put("speed", speed);
            } else {
                opts.put("speed", -1);
            }
            long totalTime = this.m_connectTime + this.m_responseTime;
            if (totalTime <= 0L) {
                this.m_responseTime = -1L;
                this.m_connectTime = -1L;
                totalTime = -1L;
            }
            opts.put("time", totalTime);
            opts.put("ctime", this.m_connectTime);
            opts.put("rtime", this.m_responseTime);
            if (this.m_path == null) {
                this.m_path = "";
            }
            this.m_submitter.submitMonitorValue(this.m_monitor, (double)totalTime, hostname + "/" + this.m_path + ":TIME", opts);
            this.m_submitter.submitMonitorValue(this.m_monitor, (double)availability, hostname + "/" + this.m_path + ":AVAILABILITY", opts);
            if (this.m_perfSubmitter == null) continue;
            ArrayList<Object> perfMetrics = new ArrayList<Object>();
            perfMetrics.add(new PerfStringMetric("HOST", hostname));
            perfMetrics.add(new PerfDoubleMetric("PORT", (double)port));
            perfMetrics.add(new PerfStringMetric("OBJECT", this.m_path));
            perfMetrics.add(new PerfDoubleMetric("RTIME", (double)this.m_responseTime));
            perfMetrics.add(new PerfDoubleMetric("CTIME", (double)this.m_connectTime));
            perfMetrics.add(new PerfDoubleMetric("TTIME", (double)totalTime));
            perfMetrics.add(new PerfDoubleMetric("SPEED", speed));
            perfMetrics.add(new PerfDoubleMetric("STATUS", (double)availability));
            this.m_perfSubmitter.submitPerfRow("IS_SFTP", System.currentTimeMillis(), perfMetrics);
        }
        return null;
    }

    @Override
    protected void execCommand(Connection conn, long start) throws IOException {
        SFTPv3Client client = new SFTPv3Client(conn);
        this.m_connectTime = System.currentTimeMillis() - start;
        long start2 = System.currentTimeMillis();
        if (this.m_path != null && !this.m_path.endsWith("/")) {
            SFTPv3FileHandle file = client.openFileRO(this.m_path);
            long pointer = 0L;
            byte[] arr = new byte[16000];
            int c = -1;
            while ((c = client.read(file, pointer, arr, 0, 16000)) != -1) {
                this.m_bytes += (double)c;
                pointer += (long)c;
            }
            this.m_responseTime = System.currentTimeMillis() - start + 1L;
        } else {
            String path = ".";
            if (this.m_path != null && this.m_path.length() > 0) {
                path = this.m_path;
            }
            Vector list = client.ls(path);
            this.m_responseTime = System.currentTimeMillis() - start + 1L;
            for (int i = 0; i < list.size(); ++i) {
                SFTPv3DirectoryEntry e = (SFTPv3DirectoryEntry)list.get(i);
                this.m_bytes += (double)e.longEntry.length();
            }
        }
        client.close();
    }

    @Override
    public void setPerfSubmitter(IPerfLog submitter) {
        this.m_perfSubmitter = submitter;
    }

    public static void main(String[] args) {
        String monitor = "OK5";
        String url = "ftp://root:blixxgw@blixxgw/";
        SFTPMonitor.check(monitor, url);
        monitor = "OK_FILE";
        url = "ftp://root:blixx0nly@rhel4.blixx.de/install.log.syslog";
        SFTPMonitor.check(monitor, url);
    }

    private static void check(String monitor, String url) {
        SFTPMonitor fm = new SFTPMonitor();
        fm.m_hostnames = new String[]{url};
        fm.m_monitor = monitor;
        fm.setMonitorSubmitter(new NullMonSubmitter());
        fm.runMonitor();
    }
}

