/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.agent.util.NullMonSubmitter;
import com.blixx.agent.util.Utils;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitorExtPerf;
import com.blixx.ext.IMonitorSubmitter;
import com.blixx.ext.IPerfLog;
import com.blixx.ext.PerfDoubleMetric;
import com.blixx.ext.PerfStringMetric;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.net.smtp.SMTPClient;
import org.apache.commons.net.smtp.SMTPReply;

public class SMTPMonitor
implements IMonitorExtPerf {
    public String[] m_hostnames = null;
    public String m_monitor = "";
    public long m_connectTime = 0L;
    public long m_responseTime = 0L;
    public IMonitorSubmitter m_submitter = null;
    public IPerfLog m_perfSubmitter = null;

    public static SMTPMonitor getInstance(String monitor, String[] parameters) {
        SMTPMonitor mon = new SMTPMonitor();
        mon.m_hostnames = parameters;
        mon.m_monitor = monitor;
        return mon;
    }

    public void setInterval(long ms) {
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
        this.m_submitter = submitter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String runMonitor() {
        for (int i = 0; i < this.m_hostnames.length; ++i) {
            int availability = -3;
            double connectTime = -1.0;
            String[] args = Utils.split(this.m_hostnames[i]);
            String hostname = args[0];
            int port = 25;
            int posC = hostname.indexOf(58);
            if (posC != -1) {
                hostname = args[0].substring(0, posC);
                String portStr = args[0].substring(posC + 1);
                try {
                    port = Integer.parseInt(portStr);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            String user = null;
            String pass = null;
            if (args.length > 1) {
                user = args[1];
                if (args.length > 2) {
                    pass = args[2];
                }
            }
            long start = System.currentTimeMillis();
            SMTPClient client = new SMTPClient();
            client.setDefaultTimeout(10000);
            HashMap<String, Object> opts = new HashMap<String, Object>();
            opts.put("host", hostname);
            try {
                client.connect(hostname, port);
                int replyCode = client.getReplyCode();
                if (SMTPReply.isPositiveCompletion(replyCode)) {
                    boolean isOK = client.login();
                    this.m_connectTime = System.currentTimeMillis() - start + 1L;
                    availability = client.getReplyCode();
                    if (isOK) {
                        start = System.currentTimeMillis();
                        boolean request = true;
                        if (user != null) {
                            request = client.verify(user);
                            availability = client.getReplyCode();
                            if (!request) {
                                opts.put("error", "" + client.getReplyString());
                            }
                        } else {
                            request = client.sendNoOp();
                            availability = client.getReplyCode();
                            if (!request) {
                                opts.put("error", "" + client.getReplyString());
                            }
                        }
                        this.m_responseTime = System.currentTimeMillis() - start + 1L;
                    } else {
                        this.m_responseTime = 0L;
                    }
                } else {
                    availability = replyCode;
                    opts.put("error", "" + client.getReplyString());
                }
                long totalTime = this.m_connectTime + this.m_responseTime;
                opts.put("time", totalTime);
                opts.put("ctime", this.m_connectTime);
                opts.put("rtime", this.m_responseTime);
            }
            catch (UnknownHostException e) {
                availability = -6;
            }
            catch (SocketException e) {
                availability = -4;
                try {
                    InetAddress addr = InetAddress.getByName(hostname);
                    if (addr.isReachable(3000)) {
                        availability = -3;
                    }
                }
                catch (Throwable addr) {
                    // empty catch block
                }
            }
            catch (SocketTimeoutException e) {
                availability = -4;
                try {
                    InetAddress addr = InetAddress.getByName(hostname);
                    if (addr.isReachable(3000)) {
                        availability = -3;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            catch (IOException e) {
                availability = -5;
            }
            finally {
                try {
                    client.logout();
                }
                catch (Throwable e) {}
                try {
                    client.disconnect();
                }
                catch (Throwable e) {}
            }
            long totalTime = this.m_connectTime + this.m_responseTime;
            if (availability < 0) {
                totalTime = -1L;
            }
            if (totalTime < 0L) {
                this.m_responseTime = -1L;
                this.m_connectTime = -1L;
            }
            if (user == null) {
                user = "noop";
            }
            this.m_submitter.submitMonitorValue(this.m_monitor, (double)totalTime, hostname + ":" + user + ":TIME", opts);
            this.m_submitter.submitMonitorValue(this.m_monitor, (double)availability, hostname + ":" + user + ":AVAILABILITY", opts);
            if (this.m_perfSubmitter == null) continue;
            ArrayList<Object> perfMetrics = new ArrayList<Object>();
            perfMetrics.add(new PerfStringMetric("HOST", hostname));
            perfMetrics.add(new PerfDoubleMetric("PORT", (double)port));
            perfMetrics.add(new PerfStringMetric("OBJECT", user));
            perfMetrics.add(new PerfDoubleMetric("RTIME", (double)this.m_responseTime));
            perfMetrics.add(new PerfDoubleMetric("CTIME", (double)this.m_connectTime));
            perfMetrics.add(new PerfDoubleMetric("TTIME", (double)totalTime));
            perfMetrics.add(new PerfDoubleMetric("STATUS", (double)availability));
            this.m_perfSubmitter.submitPerfRow("IS_SMTP", System.currentTimeMillis(), perfMetrics);
        }
        return null;
    }

    public void setMessageSubmitter(IMessage submitter) {
    }

    public void stop() {
    }

    public void setPerfSubmitter(IPerfLog submitter) {
        this.m_perfSubmitter = submitter;
    }

    public static void main(String[] args) {
        SMTPMonitor smtp = SMTPMonitor.getInstance("OK5", new String[]{"emano b_streshnyev@blixx.de"});
        smtp.setMonitorSubmitter(new NullMonSubmitter());
        smtp.runMonitor();
        smtp = SMTPMonitor.getInstance("UnknownUser4", new String[]{"emano b_streshnyev@boom.test"});
        smtp.setMonitorSubmitter(new NullMonSubmitter());
        smtp.runMonitor();
        smtp = SMTPMonitor.getInstance("UnknownUser4", new String[]{"www.blixx.com b_streshnyev@boom.test"});
        smtp.setMonitorSubmitter(new NullMonSubmitter());
        smtp.runMonitor();
        smtp = SMTPMonitor.getInstance("HostUnknown-6", new String[]{"emano4 b_streshnyev"});
        smtp.setMonitorSubmitter(new NullMonSubmitter());
        smtp.runMonitor();
        smtp = SMTPMonitor.getInstance("NoSMTPServer-4", new String[]{"localhost b_streshnyev"});
        smtp.setMonitorSubmitter(new NullMonSubmitter());
        smtp.runMonitor();
    }
}

