/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.agent.util.NullMonSubmitter;
import com.blixx.agent.util.Utils;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitorExtPerf;
import com.blixx.ext.IMonitorSubmitter;
import com.blixx.ext.IPerfLog;
import com.blixx.ext.PerfDoubleMetric;
import com.blixx.ext.PerfStringMetric;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.InteractiveCallback;
import com.trilead.ssh2.KnownHosts;
import com.trilead.ssh2.ServerHostKeyVerifier;
import com.trilead.ssh2.Session;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;

public class SSHMonitor
implements IMonitorExtPerf {
    protected AdvancedVerifier VERIFIER = new AdvancedVerifier();
    protected String knownHostPath = "sshmonitor.known_hosts";
    protected String idDSAPath = "sshmonitor.dsa";
    protected String idRSAPath = "sshmonitor.rsa";
    protected KnownHosts database = new KnownHosts();
    protected long m_timeout = 60000L;
    protected String[] m_hostnames = null;
    protected String m_monitor = "";
    protected long m_connectTime = 0L;
    protected IMonitorSubmitter m_submitter = null;
    protected IMessage m_msgSubmitter = null;
    public IPerfLog m_perfSubmitter = null;

    public static SSHMonitor getInstance(String monitorName, String[] parameters) {
        SSHMonitor mon = new SSHMonitor();
        mon.m_hostnames = parameters;
        mon.m_monitor = monitorName;
        return mon;
    }

    public void setInterval(long ms) {
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
        this.m_submitter = submitter;
    }

    public String runMonitor() {
        for (int i = 0; i < this.m_hostnames.length; ++i) {
            int availability = -3;
            double connectTime = -1.0;
            HashMap<String, String> opts = new HashMap<String, String>();
            String[] args = Utils.split(this.m_hostnames[i]);
            if (args.length != 3) continue;
            String hostname = args[0];
            int port = 22;
            int colon = hostname.indexOf(58);
            if (colon != -1) {
                hostname = hostname.substring(0, colon);
                try {
                    port = Integer.parseInt(hostname.substring(colon + 1));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            opts.put("host", hostname);
            String user = null;
            String pass = null;
            if (args.length > 1) {
                user = args[1];
                if (args.length > 2) {
                    pass = args[2];
                }
            }
            if (user != null) {
                opts.put("user", user);
            } else {
                opts.put("user", "none");
            }
            long start = System.currentTimeMillis();
            try {
                this.check(hostname, port, user, pass);
                availability = 5;
            }
            catch (UnknownHostException e) {
                availability = -6;
            }
            catch (ConnectException e) {
                availability = -3;
                try {
                    InetAddress addr = InetAddress.getByName(hostname);
                    if (!addr.isReachable(3000)) {
                        availability = -4;
                    }
                }
                catch (Throwable addr) {}
            }
            catch (IOException e) {
                Throwable tr = e.getCause();
                if (tr instanceof UnknownHostException) {
                    availability = -6;
                }
                if (e.getMessage().indexOf("authentication failed") != -1) {
                    availability = 1;
                }
                if (tr instanceof ConnectException) {
                    availability = -3;
                    try {
                        InetAddress addr = InetAddress.getByName(hostname);
                        if (!addr.isReachable(3000)) {
                            availability = -4;
                        }
                    }
                    catch (Throwable throwable) {}
                }
                e.printStackTrace();
                availability = -3;
            }
            if (availability < 0) {
                this.m_connectTime = -1L;
            }
            this.m_submitter.submitMonitorValue(this.m_monitor, (double)this.m_connectTime, hostname + ":TIME", opts);
            this.m_submitter.submitMonitorValue(this.m_monitor, (double)availability, hostname + ":AVAILABILITY", opts);
            if (this.m_perfSubmitter == null) continue;
            ArrayList<Object> perfMetrics = new ArrayList<Object>();
            perfMetrics.add(new PerfStringMetric("HOST", hostname));
            perfMetrics.add(new PerfDoubleMetric("PORT", (double)port));
            perfMetrics.add(new PerfStringMetric("OBJECT", user));
            perfMetrics.add(new PerfDoubleMetric("CTIME", (double)this.m_connectTime));
            perfMetrics.add(new PerfDoubleMetric("STATUS", (double)availability));
            this.m_perfSubmitter.submitPerfRow("IS_SSH", System.currentTimeMillis(), perfMetrics);
        }
        return null;
    }

    public void setMessageSubmitter(IMessage submitter) {
        this.m_msgSubmitter = submitter;
    }

    public void stop() {
    }

    public void setPerfSubmitter(IPerfLog submitter) {
        this.m_perfSubmitter = submitter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(String hostname, int port, String username, String password) throws IOException {
        Connection conn = null;
        try {
            long start;
            block23: {
                File knownHostFile = new File(this.knownHostPath);
                if (!knownHostFile.exists()) {
                    knownHostFile.createNewFile();
                }
                try {
                    this.database.addHostkeys(knownHostFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                conn = new Connection(hostname);
                String[] hostkeyAlgos = this.database.getPreferredServerHostkeyAlgorithmOrder(hostname);
                if (hostkeyAlgos != null) {
                    conn.setServerHostKeyAlgorithms(hostkeyAlgos);
                }
                start = System.currentTimeMillis();
                conn.connect(this.VERIFIER);
                boolean enableKeyboardInteractive = true;
                boolean enableDSA = true;
                boolean enableRSA = true;
                String lastError = null;
                while (true) {
                    boolean res;
                    if ((enableDSA || enableRSA) && conn.isAuthMethodAvailable(username, "publickey")) {
                        File key;
                        if (enableDSA) {
                            key = new File(this.idDSAPath);
                            if (key.exists()) {
                                res = conn.authenticateWithPublicKey(username, key, username);
                                if (res) break block23;
                                lastError = "DSA authentication failed.";
                            }
                            enableDSA = false;
                        }
                        if (!enableRSA) continue;
                        key = new File(this.idRSAPath);
                        if (key.exists()) {
                            res = conn.authenticateWithPublicKey(username, key, password);
                            if (res) break block23;
                            lastError = "RSA authentication failed.";
                        }
                        enableRSA = false;
                        continue;
                    }
                    if (enableKeyboardInteractive && conn.isAuthMethodAvailable(username, "keyboard-interactive")) {
                        InteractiveLogic il = new InteractiveLogic(lastError, password);
                        res = conn.authenticateWithKeyboardInteractive(username, il);
                        if (!res) {
                            if (il.getPromptCount() == 0) {
                                lastError = "Keyboard-interactive does not work.";
                                enableKeyboardInteractive = false;
                                continue;
                            }
                            lastError = "Keyboard-interactive authentication failed.";
                            continue;
                        }
                    } else {
                        if (!conn.isAuthMethodAvailable(username, "password")) break;
                        boolean res2 = conn.authenticateWithPassword(username, password);
                        if (!res2) {
                            lastError = "Password authentication failed.";
                            continue;
                        }
                    }
                    break block23;
                    break;
                }
                throw new IOException("authentication failed. No supported authentication methods available.");
            }
            this.execCommand(conn, start);
        }
        finally {
            try {
                conn.close();
            }
            catch (Throwable throwable) {}
        }
    }

    protected void execCommand(Connection conn, long start) throws IOException {
        Session sess = null;
        try {
            sess = conn.openSession();
            this.m_connectTime = System.currentTimeMillis() - start;
            sess.execCommand("exit");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            sess.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        SSHMonitor tm = SSHMonitor.getInstance("OK", new String[]{"sunny root sunny"});
        tm.setMonitorSubmitter(new NullMonSubmitter());
        tm.runMonitor();
        tm = SSHMonitor.getInstance("WrongPassword1", new String[]{"sunny root vvvvv"});
        tm.setMonitorSubmitter(new NullMonSubmitter());
        tm.runMonitor();
        tm = SSHMonitor.getInstance("UnknownHost-6", new String[]{"vvvvvv root vvvvv"});
        tm.setMonitorSubmitter(new NullMonSubmitter());
        tm.runMonitor();
        tm = SSHMonitor.getInstance("TelnetNotRunning-3", new String[]{"blixx22 root vvvvv"});
        tm.setMonitorSubmitter(new NullMonSubmitter());
        tm.runMonitor();
    }

    static class InteractiveLogic
    implements InteractiveCallback {
        int promptCount = 0;
        String lastError;
        String m_password;

        public InteractiveLogic(String lastError, String password) {
            this.lastError = lastError;
            this.m_password = password;
        }

        @Override
        public String[] replyToChallenge(String name, String instruction, int numPrompts, String[] prompt, boolean[] echo) throws IOException {
            String[] result = new String[numPrompts];
            for (int i = 0; i < numPrompts; ++i) {
                String[] content = new String[]{this.lastError, name, instruction, prompt[i]};
                if (this.lastError != null) {
                    this.lastError = null;
                }
                result[i] = this.m_password;
                ++this.promptCount;
            }
            return result;
        }

        public int getPromptCount() {
            return this.promptCount;
        }
    }

    class AdvancedVerifier
    implements ServerHostKeyVerifier {
        AdvancedVerifier() {
        }

        @Override
        public boolean verifyServerHostKey(String hostname, int port, String serverHostKeyAlgorithm, byte[] serverHostKey) throws Exception {
            String message;
            String host = hostname;
            String algo = serverHostKeyAlgorithm;
            int result = SSHMonitor.this.database.verifyHostkey(hostname, serverHostKeyAlgorithm, serverHostKey);
            switch (result) {
                case 0: {
                    return true;
                }
                case 1: {
                    message = "Do you want to accept the hostkey (type " + algo + ") from " + host + " ?\n";
                    break;
                }
                case 2: {
                    message = "WARNING! SSH certificate for " + host + " has changed!";
                    SSHMonitor.this.m_msgSubmitter.sendMessage(hostname, "SSHD", "IS", "Certificate", message, "critical", null);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            String hexFingerprint = KnownHosts.createHexFingerprint(serverHostKeyAlgorithm, serverHostKey);
            String bubblebabbleFingerprint = KnownHosts.createBubblebabbleFingerprint(serverHostKeyAlgorithm, serverHostKey);
            message = message + "Hex Fingerprint: " + hexFingerprint + "\nBubblebabble Fingerprint: " + bubblebabbleFingerprint;
            String hashedHostname = KnownHosts.createHashedHostname(hostname);
            SSHMonitor.this.database.addHostkey(new String[]{hashedHostname}, serverHostKeyAlgorithm, serverHostKey);
            try {
                KnownHosts.addHostkeyToFile(new File(SSHMonitor.this.knownHostPath), new String[]{hashedHostname}, serverHostKeyAlgorithm, serverHostKey);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
    }
}

