/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.agent.monitors.AsyncEventProcessingMonitor;
import com.blixx.ext.IMonitor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class Syslogd
extends AsyncEventProcessingMonitor<Packet> {
    public static String[] facilities = new String[]{"Kernel", "User", "Mail", "Daemon", "Auth", "Syslog", "Lpr", "News", "Uucp", "Cron", "Reserved10", "Reserver11", "Reserved12", "Reserved13", "Reserved14", "Reserved15", "Local0", "Local1", "Local2", "Local3", "Local4", "Local5", "Local6", "Local7"};
    public static String[] levels = new String[]{"Emerg", "Alert", "Critical", "Error", "Warning", "Notice", "Info", "Debug"};
    public static String[] severities = new String[]{"critical", "critical", "critical", "major", "warning", "normal", "normal", "unknown"};
    protected static final String APPLICATION = "SYSLOG";
    protected static final String GROUP = "SYSLOG";
    protected int m_port = 514;
    protected int m_deepestLevel = 4;
    protected List<Pattern> m_acceptTextPatterns = new ArrayList<Pattern>();
    protected List<Pattern> m_acceptFacilitiesPatterns = new ArrayList<Pattern>();
    protected List<Pattern> m_acceptHostPatterns = new ArrayList<Pattern>();
    private DatagramSocket m_socket;

    Syslogd(String monName, String[] parameters) {
        super(monName);
        if (parameters != null && parameters.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (String parameter : parameters) {
                sb.append(parameter);
                sb.append(" ");
            }
            parameters = sb.toString().split("\\s+");
            try {
                for (int i = 0; i < parameters.length; i += 2) {
                    Pattern p;
                    if (parameters[i].trim().equalsIgnoreCase("-p")) {
                        this.m_port = Integer.parseInt(parameters[i + 1]);
                        continue;
                    }
                    if (parameters[i].trim().equalsIgnoreCase("-l")) {
                        this.m_deepestLevel = Integer.parseInt(parameters[i + 1]);
                        continue;
                    }
                    if (parameters[i].trim().equalsIgnoreCase("-tp")) {
                        p = Pattern.compile(parameters[i + 1]);
                        this.m_acceptTextPatterns.add(p);
                        continue;
                    }
                    if (parameters[i].trim().equalsIgnoreCase("-fp")) {
                        p = Pattern.compile(parameters[i + 1]);
                        this.m_acceptFacilitiesPatterns.add(p);
                        continue;
                    }
                    if (!parameters[i].trim().equalsIgnoreCase("-hp")) continue;
                    p = Pattern.compile(parameters[i + 1]);
                    this.m_acceptHostPatterns.add(p);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error in arguments: " + sb, e);
            }
        }
        this.m_eventProcessor = new PacketProcessor();
        this.m_eventFiler = new PacketListener();
    }

    public static IMonitor getInstance(String monitorName, String[] parameters) {
        return new Syslogd(monitorName, parameters);
    }

    @Override
    public void stop() {
        super.stop();
        if (this.m_socket != null) {
            try {
                this.m_socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static int extractFacility(int code) {
        return (code & 0x3F8) >> 3;
    }

    public static int extractPriority(int code) {
        return code & 7;
    }

    public static class Packet {
        public InetAddress m_host;
        public byte[] m_data;
        public int m_len = 0;

        public Packet(DatagramPacket dp) {
            this.m_host = dp.getAddress();
            this.m_data = dp.getData();
            this.m_len = dp.getLength();
        }
    }

    public class PacketProcessor
    extends AsyncEventProcessingMonitor.EventProcessor {
        public void process(Packet dp) {
            try {
                String msg = new String(dp.m_data, 0, dp.m_len, "US-ASCII");
                int lb = msg.indexOf(60);
                int rb = msg.indexOf(62);
                int priCode = 0;
                String priStr = msg.substring(lb + 1, rb);
                try {
                    priCode = Integer.parseInt(priStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                int fc = Syslogd.extractFacility(priCode);
                int level = Syslogd.extractPriority(priCode);
                if (level > Syslogd.this.m_deepestLevel) {
                    return;
                }
                String fcStr = facilities[fc];
                if (Syslogd.this.m_acceptFacilitiesPatterns.size() > 0) {
                    boolean accept = false;
                    for (Pattern pattern : Syslogd.this.m_acceptFacilitiesPatterns) {
                        if (!pattern.matcher(fcStr).matches()) continue;
                        accept = true;
                        break;
                    }
                    if (!accept) {
                        return;
                    }
                }
                String host = dp.m_host.getHostName();
                if (Syslogd.this.m_acceptHostPatterns.size() > 0) {
                    boolean accept = false;
                    for (Pattern p : Syslogd.this.m_acceptHostPatterns) {
                        if (!p.matcher(fcStr).matches()) continue;
                        accept = true;
                        break;
                    }
                    if (!accept) {
                        return;
                    }
                }
                String lev = levels[level];
                msg = '(' + lev + ')' + msg.substring(rb + 1);
                if (Syslogd.this.m_acceptTextPatterns.size() > 0) {
                    boolean bl;
                    boolean bl2 = false;
                    for (Pattern p : Syslogd.this.m_acceptTextPatterns) {
                        if (!p.matcher(msg).matches()) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        return;
                    }
                }
                Syslogd.this.m_msgSubmitter.sendMessage(host, "SYSLOG", "SYSLOG", fcStr, msg, severities[level], null);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    private class PacketListener
    implements Runnable {
        private PacketListener() {
        }

        @Override
        public void run() {
            try {
                int len = 65536;
                while (!Syslogd.this.m_stop) {
                    try {
                        this.ensureSocket();
                        DatagramPacket packet = new DatagramPacket(new byte[65536], 65536);
                        Syslogd.this.m_socket.receive(packet);
                        Syslogd.this.m_queue.add(new Packet(packet));
                    }
                    catch (SocketTimeoutException packet) {
                    }
                    catch (IOException ex) {
                        this.sendMonitorError(ex);
                    }
                }
            }
            catch (Throwable e) {
                this.sendMonitorError(e);
            }
        }

        private void ensureSocket() throws InterruptedException {
            if (Syslogd.this.m_socket != null && Syslogd.this.m_socket.isBound() && !Syslogd.this.m_socket.isClosed()) {
                return;
            }
            if (Syslogd.this.m_socket != null) {
                Syslogd.this.m_socket.close();
            }
            for (int i = 0; i < 10; ++i) {
                try {
                    Syslogd.this.m_socket = new DatagramSocket(Syslogd.this.m_port);
                    Syslogd.this.m_socket.setSoTimeout(10000);
                    return;
                }
                catch (Throwable e) {
                    Thread.sleep(1000L);
                    continue;
                }
            }
            throw new RuntimeException(Syslogd.this.m_port + " port is busy, Can't start listener.");
        }

        private void sendMonitorError(Throwable e) {
            Syslogd.this.m_msgSubmitter.sendMessage(null, "SYSLOG", "SYSLOG", Syslogd.this.m_monitorName, "Error in Syslogd monitor: " + e.getMessage(), "warning", null);
        }
    }
}

