/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.agent.util.NullMonSubmitter;
import com.blixx.agent.util.Utils;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitorExtPerf;
import com.blixx.ext.IMonitorSubmitter;
import com.blixx.ext.IPerfLog;
import com.blixx.ext.PerfDoubleMetric;
import com.blixx.ext.PerfStringMetric;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.net.telnet.TelnetClient;

public class TelnetMonitor
implements IMonitorExtPerf {
    public String[] m_hostnames = null;
    public String m_monitor = "";
    public long m_connectTime = 0L;
    public IMonitorSubmitter m_submitter = null;
    public IPerfLog m_perfSubmitter = null;
    TelnetClient tc = null;

    public static TelnetMonitor getInstance(String monitor, String[] hostnames) {
        TelnetMonitor tm = new TelnetMonitor();
        tm.m_monitor = monitor;
        tm.m_hostnames = hostnames;
        return tm;
    }

    public void setInterval(long ms) {
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
        this.m_submitter = submitter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String runMonitor() {
        for (int i = 0; i < this.m_hostnames.length; ++i) {
            int availability = -3;
            HashMap<String, String> opts = new HashMap<String, String>();
            double connectTime = -1.0;
            String[] args = Utils.split(this.m_hostnames[i]);
            if (args.length != 3) continue;
            String hostname = args[0];
            opts.put("host", hostname);
            int port = 23;
            int posC = hostname.indexOf(58);
            if (posC != -1) {
                hostname = args[0].substring(0, posC);
                String portStr = args[0].substring(posC + 1);
                try {
                    port = Integer.parseInt(portStr);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            String user = null;
            String pass = null;
            if (args.length > 1) {
                user = args[1];
                if (args.length > 2) {
                    pass = args[2];
                }
            }
            long start = System.currentTimeMillis();
            this.tc = new TelnetClient();
            try {
                this.tc.connect(hostname, port);
                long end = this.read(this.tc.getInputStream(), this.tc.getOutputStream(), user, pass);
                connectTime = end - start;
                availability = 5;
            }
            catch (UnknownHostException e) {
                availability = -6;
            }
            catch (ConnectException e) {
                availability = -3;
                try {
                    InetAddress addr = InetAddress.getByName(hostname);
                    if (!addr.isReachable(3000)) {
                        availability = -4;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            catch (WrongPassword e) {
                availability = 1;
            }
            catch (NoLogin e) {
                availability = -2;
            }
            catch (IOException e) {
                availability = -5;
            }
            finally {
                try {
                    this.tc.disconnect();
                }
                catch (Throwable e) {}
            }
            if (availability < 0) {
                connectTime = -1.0;
            }
            this.m_submitter.submitMonitorValue(this.m_monitor, connectTime, hostname + ":TIME", opts);
            this.m_submitter.submitMonitorValue(this.m_monitor, (double)availability, hostname + ":AVAILABILITY", opts);
            if (this.m_perfSubmitter == null) continue;
            ArrayList<Object> perfMetrics = new ArrayList<Object>();
            perfMetrics.add(new PerfStringMetric("HOST", hostname));
            perfMetrics.add(new PerfDoubleMetric("PORT", (double)port));
            perfMetrics.add(new PerfStringMetric("OBJECT", user));
            perfMetrics.add(new PerfDoubleMetric("CTIME", (double)this.m_connectTime));
            perfMetrics.add(new PerfDoubleMetric("STATUS", (double)availability));
            this.m_perfSubmitter.submitPerfRow("IS_TELNET", System.currentTimeMillis(), perfMetrics);
        }
        return null;
    }

    private long read(InputStream inputStream, OutputStream outputStream, String user, String password) throws IOException, WrongPassword, NoLogin {
        byte[] arr = new byte[16000];
        StringBuffer sb = new StringBuffer();
        long loggedTime = -1L;
        int len = -1;
        int step = 0;
        while ((len = inputStream.read(arr)) != -1) {
            String str = new String(arr, 0, len);
            sb.append(str);
            String sbt = sb.toString();
            if (inputStream.available() != 0 || !sbt.endsWith(": ") && !sbt.endsWith("# ")) continue;
            String text = "";
            switch (step) {
                case 0: {
                    if (user == null || password == null) {
                        if (str.trim().endsWith("login:")) {
                            return 0L;
                        }
                        throw new NoLogin();
                    }
                    text = user + '\r';
                    outputStream.write(text.getBytes());
                    outputStream.flush();
                    ++step;
                    break;
                }
                case 1: {
                    text = password + '\r';
                    outputStream.write(text.getBytes());
                    outputStream.flush();
                    ++step;
                    break;
                }
                case 2: {
                    loggedTime = System.currentTimeMillis();
                    if (str.trim().endsWith("login:")) {
                        throw new WrongPassword();
                    }
                    text = "exit\r";
                    outputStream.write(text.getBytes());
                    outputStream.flush();
                    ++step;
                }
            }
        }
        return loggedTime;
    }

    public void setMessageSubmitter(IMessage submitter) {
    }

    public void stop() {
    }

    public void setPerfSubmitter(IPerfLog submitter) {
        this.m_perfSubmitter = submitter;
    }

    public static void main(String[] args) {
        TelnetMonitor tm = TelnetMonitor.getInstance("OK", new String[]{"sunny root sunny"});
        tm.setMonitorSubmitter(new NullMonSubmitter());
        tm.runMonitor();
        tm = TelnetMonitor.getInstance("WrongPassword", new String[]{"sunny root vvvvv"});
        tm.setMonitorSubmitter(new NullMonSubmitter());
        tm.runMonitor();
        tm = TelnetMonitor.getInstance("UnknownHost", new String[]{"vvvvvv root vvvvv"});
        tm.setMonitorSubmitter(new NullMonSubmitter());
        tm.runMonitor();
        tm = TelnetMonitor.getInstance("TelnetNotRunning", new String[]{"debm10.mytest.de root vvvvv"});
        tm.setMonitorSubmitter(new NullMonSubmitter());
        tm.runMonitor();
    }

    public static class NoLogin
    extends Exception {
    }

    public static class WrongPassword
    extends Exception {
    }
}

