/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.agent.util.Exec;
import com.blixx.agent.util.ExecResult;
import com.blixx.agent.util.Utils;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitorExt;
import com.blixx.ext.IMonitorSubmitter;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class Trigger
implements IMonitorExt {
    public String m_monitor = "";
    public String m_cmd = null;
    public String m_cmdStop = null;
    IMonitorSubmitter m_monSubmitter = null;
    IMessage m_msgSubmitter = null;
    Process m_process = null;
    Map<String, String> env = new HashMap<String, String>();

    public static Trigger getInstance(String monitor, String[] args) {
        Trigger tm = new Trigger();
        tm.m_monitor = monitor;
        tm.m_cmd = "";
        tm.m_cmd = tm.m_cmd + args[0];
        if (args.length > 1) {
            tm.m_cmdStop = args[1].trim();
            tm.stop();
        }
        tm.m_cmd = tm.m_cmd.trim();
        tm.runMonitor();
        return tm;
    }

    private static void startCollector(Trigger tm) {
        File workDir = new File(".");
        File spiDir = new File("spi");
        if (spiDir.exists() && spiDir.isDirectory()) {
            workDir = spiDir;
        }
        try {
            String[] args = Utils.processQuoted(tm.m_cmd);
            for (int i = 0; i < args.length; ++i) {
                args[i] = Utils.removeQuotesStrict(args[i]);
            }
            ProcessBuilder pb = new ProcessBuilder(args);
            pb.directory(workDir);
            for (Map.Entry<Object, Object> en : System.getProperties().entrySet()) {
                if (!(en.getValue() instanceof String) || !(en.getKey() instanceof String)) continue;
                pb.environment().put((String)en.getKey(), (String)en.getValue());
            }
            tm.m_process = pb.start();
            Thread.sleep(1000L);
            try {
                StringBuilder sb = tm.readStreams(tm.m_process);
                throw new RuntimeException(sb.toString());
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
            }
        }
        catch (Throwable e) {
            RuntimeException re = new RuntimeException(e.getMessage());
            re.setStackTrace(e.getStackTrace());
            throw re;
        }
    }

    private StringBuilder readStreams(Process process) throws IOException {
        int res = process.exitValue();
        StringBuilder sb = new StringBuilder();
        sb.append("Process exits with result code: ").append(res).append("\n");
        byte[] arr = new byte[1024];
        int readBytes = -1;
        while ((readBytes = process.getErrorStream().read(arr)) != -1) {
            if (sb.indexOf("STDERR:") == -1) {
                sb.append("STDERR:\n");
            }
            sb.append(new String(arr, 0, readBytes));
        }
        readBytes = -1;
        while ((readBytes = process.getInputStream().read(arr)) != -1) {
            if (sb.indexOf("STDOUT:") == -1) {
                sb.append("STDOUT:\n");
            }
            sb.append(new String(arr, 0, readBytes));
        }
        return sb;
    }

    public void setInterval(long ms) {
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
        this.m_monSubmitter = submitter;
    }

    public String runMonitor() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("POLICY_NAME", this.m_monitor);
        double res = 0.0;
        String msg = "Binary is running";
        if (this.m_process == null) {
            Trigger.startCollector(this);
            msg = "Binary is started";
        } else {
            try {
                res = this.m_process.exitValue();
                StringBuilder sb = null;
                try {
                    sb = this.readStreams(this.m_process);
                    vars.put("output", sb.toString());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (res == 0.0) {
                    res = 0.5;
                    msg = "Unexpected stop of the triggered binary detected. Restarted.";
                    vars.put("RC", "0");
                } else {
                    msg = "Unexpected stop of the triggered binary detected. Restarted.";
                    vars.put("RC", "" + res);
                }
                Trigger.startCollector(this);
            }
            catch (IllegalThreadStateException e) {
                try {
                    this.readStreams(this.m_process);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        try {
            this.m_msgSubmitter.sendMessage(null, "TRIGGER", "BOOM", this.m_monitor, msg, "normal", vars);
            this.m_monSubmitter.submitMonitorValue(this.m_monitor, res, null, vars);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public void setMessageSubmitter(IMessage submitter) {
        this.m_msgSubmitter = submitter;
    }

    public void stop() {
        try {
            File workDir = new File(".");
            File spiDir = new File("spi");
            if (spiDir.exists() && spiDir.isDirectory()) {
                workDir = spiDir;
            }
            if (this.m_cmdStop != null) {
                String[] args = Utils.processQuoted(this.m_cmdStop);
                for (int i = 0; i < args.length; ++i) {
                    args[i] = Utils.removeQuotesStrict(args[i]);
                }
                Runtime.getRuntime().exec(args, Exec.envp, workDir);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Thread.sleep(1000L);
            this.m_process.destroy();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void readWindowsEnv() {
        try {
            ExecResult er = Exec.exec2("cmd /c \"set\"", new File("."), 10);
            for (String line : er.m_outMessages) {
                int chEq = line.indexOf(61);
                this.env.put(line.substring(0, chEq), line.substring(chEq + 1));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

