/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.util;

import com.blixx.agent.util.ShabalUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FileHash {
    public File m_file = null;
    public String m_digest = "";
    public long m_size = 0L;
    public long m_time = -1L;

    public FileHash(File f) {
        try {
            this.m_file = f;
            if (this.m_file != null && this.m_file.exists()) {
                this.m_size = this.m_file.length();
                if (this.m_file.isFile()) {
                    this.m_digest = ShabalUtils.getShabal256Hex(this.m_file);
                    this.m_time = this.m_file.lastModified();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean equals(Object obj) {
        boolean isEQ = false;
        if (obj instanceof FileHash && obj != null) {
            FileHash second = (FileHash)obj;
            if (this.m_file == null && second.m_file == null) {
                isEQ = true;
            } else if (this.m_file != null && second.m_file != null && this.m_file.getAbsolutePath().equals(second.m_file.getAbsolutePath()) && this.m_size == second.m_size && this.m_digest.equals(second.m_digest)) {
                isEQ = true;
            }
        }
        return isEQ;
    }

    public int hashCode() {
        return (int)this.m_size;
    }

    public boolean isFileExist() {
        return this.m_file.exists();
    }

    public boolean isFile() {
        return this.m_file.isFile();
    }

    public long getSize() {
        return this.m_size;
    }

    public String getDigestString() {
        return this.m_digest;
    }

    public String getLastModifiedTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return this.m_time > 0L ? sdf.format(new Date(this.m_time)) : "";
    }
}

