/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.util;

import com.blixx.agent.util.Exec;
import com.blixx.agent.util.FileHash;
import com.blixx.agent.util.RotatingFile;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class GlobScanner {
    static final FileFilter dirFilter = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.isDirectory();
        }
    };

    public static HashMap<String, RotatingFile> findFiles(String pathPattern) {
        HashMap<String, RotatingFile> current;
        List<String> split = GlobScanner.splitPathPattern(pathPattern);
        String first = split.remove(0);
        if (Exec.isWindows && (first.equals("*:") || first.equals("**:"))) {
            current = new HashMap();
            for (File drive : File.listRoots()) {
                current.putAll(GlobScanner.scan(drive, split));
            }
        } else {
            File root;
            if (GlobScanner.isWildcard(first)) {
                root = new File(".");
                split.add(0, first);
            } else {
                root = new File(first);
            }
            current = GlobScanner.scan(root, split);
        }
        return current;
    }

    public static HashMap<String, FileHash> findAllFiles(String pathPattern) {
        HashMap<String, FileHash> current;
        List<String> split = GlobScanner.splitPathPattern(pathPattern);
        String first = split.remove(0);
        if (Exec.isWindows && (first.equals("*:") || first.equals("**:"))) {
            current = new HashMap();
            for (File drive : File.listRoots()) {
                current.putAll(GlobScanner.scanAll(drive, split));
            }
        } else {
            File root;
            if (GlobScanner.isWildcard(first)) {
                root = new File(".");
                split.add(0, first);
            } else {
                root = new File(first);
            }
            current = GlobScanner.scanAll(root, split);
        }
        return current;
    }

    public static HashMap<String, RotatingFile> scan(File root, List<String> splitPath) {
        HashMap<String, RotatingFile> result = new HashMap<String, RotatingFile>();
        if (splitPath.isEmpty()) {
            if (root.isFile()) {
                RotatingFile rf = new RotatingFile(root, root.getAbsolutePath(), null);
                result.put(rf.keyPath, rf);
            }
            return result;
        }
        if (!root.isDirectory()) {
            return result;
        }
        Stack<Item> stack = new Stack<Item>();
        Item initial = new Item(root, splitPath);
        initial.key = root.getAbsolutePath();
        stack.push(initial);
        while (!stack.isEmpty()) {
            Item it = (Item)stack.pop();
            assert (!it.pattern.isEmpty());
            String childPattern = it.pattern.remove(0);
            boolean goRecursive = childPattern.equals("**");
            while (goRecursive && !it.pattern.isEmpty() && (childPattern = it.pattern.remove(0)).equals("**")) {
            }
            if (goRecursive) {
                for (File subdir : it.file.listFiles(dirFilter)) {
                    LinkedList<String> recursivePattern = new LinkedList<String>(it.pattern);
                    recursivePattern.add(0, childPattern);
                    recursivePattern.add(0, "**");
                    Item recursive = new Item(subdir, recursivePattern);
                    recursive.key = it.incKey(subdir.getName());
                    recursive.groups = it.groups;
                    stack.push(recursive);
                }
            }
            if (!GlobScanner.isWildcard(childPattern)) {
                File f = new File(it.file, childPattern);
                if (it.pattern.isEmpty()) {
                    RotatingFile rf;
                    if (!f.isFile() || (rf = result.get(it.key)) != null && rf.file.lastModified() >= f.lastModified()) continue;
                    result.put(it.key, new RotatingFile(f, it.key, it.getGroups()));
                    continue;
                }
                if (!f.isDirectory()) continue;
                it.file = f;
                it.key = it.incKey(childPattern);
                stack.push(it);
                continue;
            }
            Matcher matcher = new Matcher(childPattern);
            for (String name : it.file.list()) {
                List<String> groups;
                String key;
                boolean matches = matcher.matches(name);
                if (!matches) continue;
                File child = new File(it.file, name);
                if (GlobScanner.isGroupWildcard(childPattern)) {
                    key = it.key;
                    groups = it.incGroups(name);
                } else {
                    key = it.incKey(name);
                    groups = it.groups;
                }
                if (child.isFile()) {
                    RotatingFile rf;
                    if (!it.pattern.isEmpty() || (rf = result.get(key)) != null && rf.file.lastModified() >= child.lastModified()) continue;
                    result.put(key, new RotatingFile(child, key, it.getGroups(groups)));
                    continue;
                }
                if (it.pattern.isEmpty()) continue;
                Item next = new Item(child, new ArrayList<String>(it.pattern));
                next.key = key;
                next.groups = groups;
                stack.push(next);
            }
        }
        return result;
    }

    public static HashMap<String, FileHash> scanAll(File root, List<String> splitPath) {
        HashMap<String, FileHash> result = new HashMap<String, FileHash>();
        if (splitPath.isEmpty()) {
            if (root.isFile()) {
                FileHash rf = new FileHash(root);
                result.put(root.getAbsolutePath(), rf);
            }
            return result;
        }
        if (!root.isDirectory()) {
            return result;
        }
        Stack<Item> stack = new Stack<Item>();
        Item initial = new Item(root, splitPath);
        initial.key = root.getAbsolutePath();
        stack.push(initial);
        while (!stack.isEmpty()) {
            Item it = (Item)stack.pop();
            assert (!it.pattern.isEmpty());
            String childPattern = it.pattern.remove(0);
            boolean goRecursive = childPattern.equals("**");
            while (goRecursive && !it.pattern.isEmpty() && (childPattern = it.pattern.remove(0)).equals("**")) {
            }
            if (goRecursive) {
                for (File subdir : it.file.listFiles(dirFilter)) {
                    LinkedList<String> recursivePattern = new LinkedList<String>(it.pattern);
                    recursivePattern.add(0, childPattern);
                    recursivePattern.add(0, "**");
                    Item recursive = new Item(subdir, recursivePattern);
                    recursive.key = it.incKey(subdir.getName());
                    recursive.groups = it.groups;
                    stack.push(recursive);
                }
            }
            if (!GlobScanner.isWildcard(childPattern)) {
                File f = new File(it.file, childPattern);
                if (it.pattern.isEmpty()) {
                    if (!f.isFile()) continue;
                    result.put(f.getAbsolutePath(), new FileHash(f));
                    continue;
                }
                if (!f.isDirectory()) continue;
                it.file = f;
                it.key = it.incKey(childPattern);
                stack.push(it);
                continue;
            }
            Matcher matcher = new Matcher(childPattern);
            for (String name : it.file.list()) {
                List<String> groups;
                String key;
                boolean matches = matcher.matches(name);
                if (!matches) continue;
                File child = new File(it.file, name);
                if (GlobScanner.isGroupWildcard(childPattern)) {
                    key = it.key;
                    groups = it.incGroups(name);
                } else {
                    key = it.incKey(name);
                    groups = it.groups;
                }
                if (child.isFile()) {
                    if (!it.pattern.isEmpty()) continue;
                    result.put(child.getAbsolutePath(), new FileHash(child));
                    continue;
                }
                if (it.pattern.isEmpty()) continue;
                Item next = new Item(child, new ArrayList<String>(it.pattern));
                next.key = key;
                next.groups = groups;
                stack.push(next);
            }
        }
        return result;
    }

    public static boolean isWildcard(String p) {
        return p.indexOf("*") != -1;
    }

    static boolean isGroupWildcard(String p) {
        assert (GlobScanner.isWildcard(p));
        return p.indexOf("**") == -1;
    }

    public static List<String> splitPathPattern(String p) {
        ArrayList<String> result = new ArrayList<String>();
        p = p.replace("\\", "/");
        boolean isUNC = Exec.isWindows && p.startsWith("//");
        p = p.replace("//", "/");
        int lastSep = 0;
        int lastSplit = 0;
        boolean gotWildcard = false;
        for (int i = 0; i < p.length(); ++i) {
            char ch = p.charAt(i);
            if (ch == '/') {
                lastSep = i;
                if (!gotWildcard) continue;
                result.add(p.substring(lastSplit, lastSep));
                lastSplit = lastSep + 1;
                gotWildcard = false;
                continue;
            }
            if (ch != '*' || gotWildcard) continue;
            gotWildcard = true;
            if (lastSep == 0 && p.charAt(0) == '/') {
                result.add("/");
                lastSplit = 1;
                continue;
            }
            if (lastSplit >= lastSep) continue;
            result.add(p.substring(lastSplit, lastSep));
            lastSplit = lastSep + 1;
        }
        if (lastSplit != p.length()) {
            result.add(p.substring(lastSplit));
        }
        Iterator it = result.iterator();
        while (it.hasNext()) {
            if (((String)it.next()).length() != 0) continue;
            it.remove();
        }
        if (isUNC) {
            result.set(0, "\\\\" + result.get(0));
        }
        return result;
    }

    public static class Matcher {
        final ArrayList<String> cards;
        final boolean anyStart;
        final boolean anyEnd;

        public Matcher(String pattern) {
            this.cards = Matcher.pattern2cards(pattern);
            this.anyStart = pattern.charAt(0) == '*';
            this.anyEnd = pattern.charAt(pattern.length() - 1) == '*';
        }

        static ArrayList<String> pattern2cards(String pattern) {
            ArrayList<String> cards = new ArrayList<String>();
            for (String s : pattern.split("\\*")) {
                if (s.length() == 0) continue;
                cards.add(s);
            }
            return cards;
        }

        public boolean matches(String name) {
            if (!this.anyStart && !name.startsWith(this.cards.get(0))) {
                return false;
            }
            if (!this.anyEnd && !name.endsWith(this.cards.get(this.cards.size() - 1))) {
                return false;
            }
            int pos = 0;
            for (String card : this.cards) {
                int idx = name.indexOf(card, pos);
                if (idx == -1) {
                    return false;
                }
                pos = idx + 1;
            }
            return true;
        }
    }

    static final class Item {
        List<String> pattern;
        File file;
        List<String> groups;
        String key;

        public Item(File file, List<String> pattern) {
            this.file = file;
            this.pattern = pattern;
        }

        public String toString() {
            return "Item{pattern=" + this.pattern + ", file=" + this.file.getAbsolutePath() + ", groups=" + this.groups + ", key='" + this.key + '\'' + '}';
        }

        public String[] getGroups() {
            return this.getGroups(this.groups);
        }

        public String[] getGroups(List<String> groups) {
            return groups == null ? null : groups.toArray(new String[groups.size()]);
        }

        public List<String> incGroups(String next) {
            LinkedList<String> tmp = new LinkedList<String>();
            if (this.groups != null) {
                tmp.addAll(this.groups);
            }
            tmp.add(next);
            return tmp;
        }

        public String incKey(String next) {
            if (this.key == null) {
                return next;
            }
            return this.key + "/" + next;
        }
    }
}

