/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class STLogger
implements FileFilter {
    private PrintStream m_log = System.out;
    private String m_dir = ".";
    private String m_currentFile = null;
    private String FILE_PREFIX = "RTlog_";
    public int m_level = 1;
    public int LEVEL_1 = 1;
    public int LEVEL_2 = 2;
    public int LEVEL_3 = 3;
    public int LEVEL_OFF = 0;
    public static SimpleDateFormat m_sdf_rtlogger = new SimpleDateFormat("yyMMdd HH:mm:ss");
    public static final long sevendays = 604800000L;

    public STLogger() {
    }

    public STLogger(String dir, String prefix) {
        this.setDir(dir, prefix);
    }

    public void print(int level, String msg) {
        if (msg == null) {
            return;
        }
        if (level <= 0) {
            this.getPrintStream();
        }
        if (level <= this.m_level && msg.trim().length() > 0) {
            this.getPrintStream().println(this.getTime() + " <" + level + "> " + msg.replaceAll("\n", "\t"));
        }
    }

    public void print(int level, String msg, Throwable e) {
        if (level <= this.m_level) {
            this.getPrintStream().println(this.getTime() + " <" + level + "> " + msg + " Exception:" + e.getMessage());
            e.printStackTrace(this.m_log);
        }
    }

    public void print(int level, String msg, Object[] params) {
        if (level <= this.m_level) {
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    msg = msg.replace("{" + i + "}", "" + params[i]);
                }
            }
            this.getPrintStream().println(this.getTime() + " <" + level + "> " + msg.replaceAll("\n", "\t"));
        }
    }

    public void printAsIs(int level, String msg) {
        if (msg == null) {
            return;
        }
        if (level <= this.m_level) {
            this.getPrintStream().println(msg);
        }
    }

    public PrintStream getPrintStream() {
        if (this.m_log.checkError()) {
            this.setDir(this.m_dir, this.FILE_PREFIX);
        } else {
            String fname = this.getCurrentFilename(this.m_dir);
            if (fname != null && !fname.equals(this.m_currentFile)) {
                try {
                    this.m_log.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.setDir(this.m_dir, this.FILE_PREFIX);
            }
        }
        return this.m_log;
    }

    public void setPrintStream(PrintStream out) {
        this.m_log = out;
    }

    public String getDir() {
        return this.m_dir;
    }

    public void setDir(String logFileDir, String prefix) {
        this.m_dir = logFileDir;
        this.setPrefix(prefix);
        try {
            this.m_currentFile = this.getCurrentFilename(this.m_dir);
            if (this.m_currentFile != null) {
                FileOutputStream fos = new FileOutputStream(this.m_currentFile, true);
                this.setPrintStream(new PrintStream(fos));
            }
            this.printAsIs(0, "\n");
            this.print(0, " ================  NEW START  ================\n");
            this.deleteOlds(logFileDir);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private String getCurrentFilename(String logFileDir) {
        if (logFileDir == null) {
            return null;
        }
        if (!logFileDir.endsWith(File.pathSeparator)) {
            logFileDir = logFileDir + File.separator;
        }
        String fname = null;
        Calendar rightNow = Calendar.getInstance();
        StringBuffer mid = new StringBuffer();
        mid.append(this.FILE_PREFIX);
        mid.append(rightNow.get(1)).append(".");
        mid.append(rightNow.get(2) + 1).append(".");
        mid.append(rightNow.get(5));
        mid.append(".log");
        fname = logFileDir + mid.toString();
        return fname;
    }

    private void deleteOlds(String logFileDir) {
        try {
            File[] oldfiles;
            String dir = logFileDir;
            if (dir.endsWith(File.separator)) {
                dir = logFileDir.substring(0, logFileDir.length() - 1);
            }
            if ((oldfiles = new File(dir).listFiles(this)) != null) {
                for (int i = 0; i < oldfiles.length; ++i) {
                    String name2 = oldfiles[i].getName();
                    oldfiles[i].delete();
                    this.print(4, "Old logfile: " + name2 + " removed");
                }
            }
        }
        catch (RuntimeException e) {
            this.print(4, "Err removing logfile: ", e);
        }
    }

    public String getFilePrefix() {
        return this.FILE_PREFIX;
    }

    private void setPrefix(String prefix) {
        this.FILE_PREFIX = prefix;
    }

    public String getTime() {
        Date d = new Date();
        return m_sdf_rtlogger.format(d);
    }

    public void setLevel(int i) {
        this.print(1, "Loglevel set to " + i);
        this.m_level = i;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.m_log.close();
    }

    public int getCurrentLevel() {
        return this.m_level;
    }

    @Override
    public boolean accept(File pathname) {
        boolean isOldLogFile = false;
        if (pathname.getName().startsWith(this.getFilePrefix()) && pathname.getName().endsWith(".log") && pathname.lastModified() < System.currentTimeMillis() - 604800000L) {
            isOldLogFile = true;
        }
        return isOldLogFile;
    }
}

