/*
 * Decompiled with CFR 0.152.
 */
package com.boom.utils;

import com.boom.utils.JNRPEClientException;
import com.boom.utils.ReturnValue;
import com.boom.utils.Status;
import com.boom.utils.jrpe.net.JNRPERequest;
import com.boom.utils.jrpe.net.JNRPEResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class JNRPEClient {
    private static final int DEFAULT_TIMEOUT = 10;
    public static final int DEFAULT_PORT = 5666;
    private final String serverIPorURL;
    private final int serverPort;
    private final boolean useSSL;
    private int communicationTimeout = 10;

    public JNRPEClient(String sJNRPEServerIP, int iJNRPEServerPort, boolean bSSL) {
        this.serverIPorURL = sJNRPEServerIP;
        this.serverPort = iJNRPEServerPort;
        this.useSSL = bSSL;
    }

    private TrustManager getTrustManager() {
        return new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        };
    }

    public final ReturnValue sendCommand(String sCommandName, String ... arguments) throws JNRPEClientException {
        SocketFactory socketFactory = null;
        Socket s = null;
        try {
            if (!this.useSSL) {
                socketFactory = SocketFactory.getDefault();
                s = socketFactory.createSocket();
            } else {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, null, new SecureRandom());
                sslContext.init(null, new TrustManager[]{this.getTrustManager()}, new SecureRandom());
                socketFactory = sslContext.getSocketFactory();
                s = socketFactory.createSocket();
                ((SSLSocket)s).setEnabledCipherSuites(((SSLSocket)s).getSupportedCipherSuites());
            }
            s.setSoTimeout(this.communicationTimeout * 1000);
            s.connect(new InetSocketAddress(this.serverIPorURL, this.serverPort));
            JNRPERequest req = new JNRPERequest(sCommandName, arguments);
            s.getOutputStream().write(req.toByteArray());
            InputStream in = s.getInputStream();
            JNRPEResponse res = new JNRPEResponse(in);
            ReturnValue returnValue = new ReturnValue(Status.fromIntValue(res.getResultCode()), res.getMessage());
            return returnValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JNRPEClientException(e);
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public final void setTimeout(int iTimeout) {
        this.communicationTimeout = iTimeout;
    }

    public final int getTimeout() {
        return this.communicationTimeout;
    }
}

