/*
 * Decompiled with CFR 0.152.
 */
package com.boom.utils;

import com.boom.utils.ReturnValue;
import java.math.BigDecimal;
import java.text.DecimalFormat;

class PerformanceData {
    private final String label;
    private final BigDecimal performanceValue;
    private final ReturnValue.UnitOfMeasure unitOfMeasure;
    private final String unit;
    private final String warningRange;
    private final String criticalRange;
    private final BigDecimal minimumValue;
    private final BigDecimal maximumValue;
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.000000");

    public PerformanceData(String perfLabel, BigDecimal value, ReturnValue.UnitOfMeasure uom, String warnRange, String critRange, BigDecimal minValue, BigDecimal maxValue) {
        this.label = perfLabel;
        this.performanceValue = value;
        this.unitOfMeasure = uom;
        this.warningRange = warnRange;
        this.criticalRange = critRange;
        this.minimumValue = minValue;
        this.maximumValue = maxValue;
        this.unit = null;
    }

    public PerformanceData(String perfLabel, BigDecimal value, String unitofMeasure, String warnRange, String critRange, BigDecimal minValue, BigDecimal maxValue) {
        this.label = perfLabel;
        this.performanceValue = value;
        this.unitOfMeasure = null;
        this.warningRange = warnRange;
        this.criticalRange = critRange;
        this.minimumValue = minValue;
        this.maximumValue = maxValue;
        this.unit = unitofMeasure;
    }

    public String toPerformanceString() {
        StringBuffer res = new StringBuffer().append(this.quote(this.label)).append("=").append(DECIMAL_FORMAT.format(this.performanceValue));
        if (this.unitOfMeasure != null) {
            switch (this.unitOfMeasure) {
                case milliseconds: {
                    res.append("ms");
                    break;
                }
                case microseconds: {
                    res.append("us");
                    break;
                }
                case seconds: {
                    res.append("s");
                    break;
                }
                case bytes: {
                    res.append("B");
                    break;
                }
                case kilobytes: {
                    res.append("KB");
                    break;
                }
                case megabytes: {
                    res.append("MB");
                    break;
                }
                case gigabytes: {
                    res.append("GB");
                    break;
                }
                case terabytes: {
                    res.append("TB");
                    break;
                }
                case percentage: {
                    res.append("%");
                    break;
                }
                case counter: {
                    res.append("c");
                    break;
                }
            }
        }
        if (this.unit != null) {
            res.append(this.unit);
        }
        res.append(";");
        if (this.warningRange != null) {
            res.append(this.warningRange);
        }
        res.append(";");
        if (this.criticalRange != null) {
            res.append(this.criticalRange);
        }
        res.append(";");
        if (this.minimumValue != null) {
            res.append(DECIMAL_FORMAT.format(this.minimumValue));
        }
        res.append(";");
        if (this.maximumValue != null) {
            res.append(DECIMAL_FORMAT.format(this.maximumValue));
        }
        while (res.charAt(res.length() - 1) == ';') {
            res.deleteCharAt(res.length() - 1);
        }
        return res.toString();
    }

    private String quote(String lbl) {
        if (lbl.indexOf(32) == -1) {
            return lbl;
        }
        return new StringBuffer("'").append(lbl).append("'").toString();
    }
}

