/*
 * Decompiled with CFR 0.152.
 */
package com.boom.utils;

import com.boom.utils.PerformanceData;
import com.boom.utils.Status;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public final class ReturnValue {
    private final List<PerformanceData> performanceDataList = new ArrayList<PerformanceData>();
    private Status statusCode;
    private String messageString;

    public ReturnValue() {
    }

    public ReturnValue(String message) {
        this.statusCode = Status.OK;
        this.messageString = message;
    }

    @Deprecated
    public ReturnValue(int returnCode, String message) {
        this.statusCode = Status.fromIntValue(returnCode);
        this.messageString = message;
    }

    public ReturnValue(Status status, String message) {
        this.statusCode = status;
        this.messageString = message;
    }

    @Deprecated
    public ReturnValue withReturnCode(int returnCode) {
        this.statusCode = Status.fromIntValue(returnCode);
        return this;
    }

    public ReturnValue withStatus(Status status) {
        if (status == null) {
            throw new IllegalArgumentException("Status cannot be null");
        }
        this.statusCode = status;
        return this;
    }

    public ReturnValue withMessage(String message) {
        this.messageString = message;
        return this;
    }

    @Deprecated
    public int getReturnCode() {
        return this.statusCode.intValue();
    }

    public Status getStatus() {
        return this.statusCode;
    }

    public String getMessage() {
        if (this.performanceDataList.isEmpty()) {
            return this.messageString;
        }
        StringBuffer res = new StringBuffer(this.messageString).append("|");
        for (PerformanceData pd : this.performanceDataList) {
            res.append(pd.toPerformanceString()).append(' ');
        }
        return res.toString();
    }

    public ReturnValue withPerformanceData(String label, Long value, UnitOfMeasure uom, String warningRange, String criticalRange, Long minimumValue, Long maximumValue) {
        BigDecimal bdValue = null;
        BigDecimal bdMin = null;
        BigDecimal bdMax = null;
        if (value != null) {
            bdValue = new BigDecimal(value);
        }
        if (minimumValue != null) {
            bdMin = new BigDecimal(minimumValue);
        }
        if (maximumValue != null) {
            bdMax = new BigDecimal(maximumValue);
        }
        this.performanceDataList.add(new PerformanceData(label, bdValue, uom, warningRange, criticalRange, bdMin, bdMax));
        return this;
    }

    public ReturnValue withPerformanceData(String label, BigDecimal value, UnitOfMeasure uom, String warningRange, String criticalRange, BigDecimal minimumValue, BigDecimal maximumValue) {
        this.performanceDataList.add(new PerformanceData(label, value, uom, warningRange, criticalRange, minimumValue, maximumValue));
        return this;
    }

    public ReturnValue withPerformanceData(String label, BigDecimal value, String unit, String warningRange, String criticalRange, BigDecimal minimumValue, BigDecimal maximumValue) {
        this.performanceDataList.add(new PerformanceData(label, value, unit, warningRange, criticalRange, minimumValue, maximumValue));
        return this;
    }

    public static enum UnitOfMeasure {
        microseconds,
        milliseconds,
        seconds,
        percentage,
        bytes,
        kilobytes,
        megabytes,
        gigabytes,
        terabytes,
        counter;

    }
}

