/*
 * Decompiled with CFR 0.152.
 */
package com.boom.utils.jrpe.net;

import com.boom.utils.jrpe.net.BadCRCException;
import com.boom.utils.jrpe.net.PacketType;
import com.boom.utils.jrpe.net.PacketVersion;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Random;
import java.util.zip.CRC32;

class JNRPEProtocolPacket {
    private static final int MAX_PACKETBUFFER_LENGTH = 1024;
    private Charset charset = Charset.forName("UTF-8");
    private int crcValue;
    private int packetTypeCode;
    private int packetVersion;
    private int resultCode;
    private byte[] byteBufferAry = new byte[1024];
    private final byte[] dummyBytesAry = new byte[2];

    JNRPEProtocolPacket() {
    }

    int getCRC() {
        return this.crcValue;
    }

    PacketType getPacketType() {
        return PacketType.fromIntValue(this.packetTypeCode);
    }

    public PacketVersion getPacketVersion() {
        return PacketVersion.fromIntValue(this.packetVersion);
    }

    void setCRC(int crc) {
        this.crcValue = crc;
    }

    protected void setPacketType(PacketType packetType) {
        this.packetTypeCode = packetType.intValue();
    }

    public void setPacketVersion(PacketVersion version) {
        this.packetVersion = version.intValue();
    }

    public void setCharset(Charset newCharset) {
        this.charset = newCharset;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(int status) {
        this.resultCode = status;
    }

    public void validate() throws BadCRCException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        try {
            dout.writeShort(this.packetVersion);
            dout.writeShort(this.packetTypeCode);
            dout.writeInt(0);
            dout.writeShort(this.resultCode);
            dout.write(this.byteBufferAry);
            dout.write(this.dummyBytesAry);
            dout.close();
            byte[] vBytes = bout.toByteArray();
            CRC32 crcAlg = new CRC32();
            crcAlg.update(vBytes);
            if ((int)crcAlg.getValue() != this.crcValue) {
                throw new BadCRCException("Bad CRC");
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected byte[] getBuffer() {
        return this.byteBufferAry;
    }

    protected String getPacketString() {
        byte[] buffer = this.getBuffer();
        int zeroIndex = this.getByteIndex(buffer, (byte)0);
        if (zeroIndex == -1) {
            return new String(buffer);
        }
        return new String(buffer, 0, zeroIndex);
    }

    public int getByteIndex(byte[] array, byte b) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != b) continue;
            return i;
        }
        return -1;
    }

    private void initRandomBuffer() {
        Random r = new Random(System.currentTimeMillis());
        r.nextBytes(this.byteBufferAry);
        r.nextBytes(this.dummyBytesAry);
    }

    protected void setBuffer(String buffer) {
        this.initRandomBuffer();
        this.byteBufferAry = Arrays.copyOf(buffer.getBytes(this.charset), 1024);
    }

    void setDummy(byte[] dummyBytes) {
        if (dummyBytes == null || dummyBytes.length != 2) {
            throw new IllegalArgumentException("Dummy bytes array must have exactly two elements");
        }
        System.arraycopy(dummyBytes, 0, this.dummyBytesAry, 0, 2);
    }

    byte[] getDummy() {
        return this.dummyBytesAry;
    }

    void updateCRC() {
        this.setCRC(0);
        CRC32 crcAlg = new CRC32();
        crcAlg.update(this.toByteArray());
        this.setCRC((int)crcAlg.getValue());
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        try {
            dout.writeShort(this.packetVersion);
            dout.writeShort(this.packetTypeCode);
            dout.writeInt(this.crcValue);
            dout.writeShort(this.resultCode);
            dout.write(this.byteBufferAry);
            dout.write(this.dummyBytesAry);
            dout.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return bout.toByteArray();
    }

    protected void fromInputStream(InputStream in) throws IOException {
        DataInputStream din = new DataInputStream(in);
        this.packetVersion = din.readShort();
        this.packetTypeCode = din.readShort();
        this.crcValue = din.readInt();
        this.resultCode = din.readShort();
        din.readFully(this.byteBufferAry);
        din.readFully(this.dummyBytesAry);
    }
}

