/*
 * Decompiled with CFR 0.152.
 */
package com.boom.utils.jrpe.net;

import com.boom.utils.jrpe.net.JNRPEProtocolPacket;
import com.boom.utils.jrpe.net.PacketType;
import com.boom.utils.jrpe.net.PacketVersion;
import org.apache.commons.lang.text.StrMatcher;
import org.apache.commons.lang.text.StrTokenizer;

public class JNRPERequest
extends JNRPEProtocolPacket {
    public JNRPERequest() {
        this.setPacketType(PacketType.QUERY);
    }

    public JNRPERequest(String commandName, String ... arguments) {
        this.init(commandName, arguments);
        this.updateCRC();
    }

    JNRPERequest(String commandName, String sArguments) {
        this.init(commandName, sArguments);
    }

    private void init(String commandName, String ... arguments) {
        if (arguments != null) {
            if (arguments.length == 1) {
                this.init(commandName, arguments[0]);
                return;
            }
            String[] ary = new String[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                ary[i] = arguments[i].indexOf(33) == -1 ? arguments[i] : "'" + arguments[i] + "'";
            }
            char delimiter = '!';
            this.init(commandName, JNRPERequest.join(delimiter, ary));
        } else {
            this.init(commandName, (String)null);
        }
    }

    private void init(String commandName, String argumentsString) {
        String tmpArgumentsString = argumentsString;
        if (tmpArgumentsString != null && tmpArgumentsString.startsWith("!")) {
            tmpArgumentsString = tmpArgumentsString.substring(1);
        }
        String fullCommandString = !JNRPERequest.isBlank(tmpArgumentsString) ? commandName + "!" + tmpArgumentsString : commandName;
        this.setPacketVersion(PacketVersion.VERSION_2);
        super.setPacketType(PacketType.QUERY);
        super.setBuffer(fullCommandString);
    }

    public final String getCommand() {
        String[] partsAry = this.split(this.getPacketString());
        return partsAry[0];
    }

    public final String[] getArguments() {
        String[] partsAry = this.split(this.getPacketString());
        String[] argsAry = new String[partsAry.length - 1];
        System.arraycopy(partsAry, 1, argsAry, 0, argsAry.length);
        return argsAry;
    }

    private String[] split(String sCommandLine) {
        return JNRPERequest.split(sCommandLine, '!', false);
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String join(char delimiter, String[] ary) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ary.length; ++i) {
            if (i > 0) {
                sb.append(delimiter);
            }
            sb.append(ary[i]);
        }
        return sb.toString();
    }

    public static String[] split(String string, char separator, boolean ignoreQuotes) {
        StrTokenizer strtok = new StrTokenizer(string, StrMatcher.charMatcher(separator), StrMatcher.quoteMatcher());
        return strtok.getTokenArray();
    }
}

