/*
 * Decompiled with CFR 0.152.
 */
package net.objecthunter.exp4j;

import java.util.ArrayList;
import java.util.List;
import net.objecthunter.exp4j.ExpressionBuilder;
import net.objecthunter.exp4j.function.Function;
import net.objecthunter.exp4j.operator.Operator;

public class OpmExpressionBuilder
extends ExpressionBuilder {
    public OpmExpressionBuilder(String expression) {
        super(expression);
        this.operator(this.getAdditionalOperators()).functions(this.getAdditionalFunctions());
    }

    private List<Operator> getAdditionalOperators() {
        ArrayList<Operator> operators = new ArrayList<Operator>();
        operators.add(new Operator("*", 2, true, 500){

            @Override
            public double apply(double ... args) {
                return args[0] * args[1];
            }
        });
        operators.add(new Operator("/", 2, true, 500){

            @Override
            public double apply(double ... args) {
                if (args[1] == 0.0) {
                    throw new ArithmeticException("Division by zero!");
                }
                return args[0] / args[1];
            }
        });
        operators.add(new Operator("\\", 2, true, 500){

            @Override
            public double apply(double ... args) {
                if (args[0] == 0.0) {
                    throw new ArithmeticException("Division by zero!");
                }
                return args[1] / args[0];
            }
        });
        return operators;
    }

    private List<Function> getAdditionalFunctions() {
        ArrayList<Function> functions = new ArrayList<Function>();
        functions.add(new Function("floor", 2){

            @Override
            public double apply(double ... args) {
                double factor = Math.pow(10.0, args[1]);
                return Math.floor(args[0] * factor) / factor;
            }
        });
        functions.add(new Function("ceil", 2){

            @Override
            public double apply(double ... args) {
                double factor = Math.pow(10.0, args[1]);
                return Math.ceil(args[0] * factor) / factor;
            }
        });
        functions.add(new Function("round", 2){

            @Override
            public double apply(double ... args) {
                double factor = Math.pow(10.0, args[1]);
                return (double)Math.round(args[0] * factor) / factor;
            }
        });
        return functions;
    }
}

