/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jradiusclient;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import net.sourceforge.jradiusclient.RadiusAttribute;
import net.sourceforge.jradiusclient.RadiusPacket;
import net.sourceforge.jradiusclient.exception.InvalidParameterException;
import net.sourceforge.jradiusclient.exception.RadiusException;

public class RadiusClient {
    private static byte[] NAS_ID;
    private static byte[] NAS_IP;
    private static final int AUTH_LOOP_COUNT = 3;
    private static final int ACCT_LOOP_COUNT = 3;
    private static final int DEFAULT_AUTH_PORT = 1812;
    private static final int DEFAULT_ACCT_PORT = 1813;
    private static final int DEFAULT_SOCKET_TIMEOUT = 6000;
    private String sharedSecret = "";
    private InetAddress hostname = null;
    private int authenticationPort = 1812;
    private int accountingPort = 1813;
    private DatagramSocket socket = null;
    private int socketTimeout = 6000;
    private MessageDigest md5MessageDigest;

    public RadiusClient(String hostname, String sharedSecret) throws RadiusException, InvalidParameterException {
        this(hostname, 1812, 1813, sharedSecret, 6000);
    }

    public RadiusClient(String hostname, int authPort, int acctPort, String sharedSecret) throws RadiusException, InvalidParameterException {
        this(hostname, authPort, acctPort, sharedSecret, 6000);
    }

    public RadiusClient(String hostname, int authPort, int acctPort, String sharedSecret, int sockTimeout) throws RadiusException, InvalidParameterException {
        this.setHostname(hostname);
        this.setSharedSecret(sharedSecret);
        try {
            this.socket = new DatagramSocket();
        }
        catch (SocketException sex) {
            throw new RadiusException(sex.getMessage());
        }
        this.setTimeout(sockTimeout);
        try {
            this.md5MessageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsaex) {
            throw new RadiusException(nsaex.getMessage());
        }
        this.setAuthPort(authPort);
        this.setAcctPort(acctPort);
    }

    public RadiusPacket authenticate(RadiusPacket accessRequest) throws RadiusException, InvalidParameterException {
        return this.authenticate(accessRequest, 3);
    }

    public RadiusPacket authenticate(RadiusPacket accessRequest, int retries) throws RadiusException, InvalidParameterException {
        byte code;
        if (null == accessRequest) {
            throw new InvalidParameterException("accessRequest parameter cannot be null");
        }
        if (retries < 0) {
            throw new InvalidParameterException("retries must be zero or greater!");
        }
        if (retries == 0) {
            retries = 3;
        }
        if ((code = accessRequest.getPacketType()) != 1) {
            throw new InvalidParameterException("Invalid packet type submitted to authenticate");
        }
        byte identifier = accessRequest.getPacketIdentifier();
        byte[] requestAuthenticator = this.makeRFC2865RequestAuthenticator();
        try {
            byte[] userPass = accessRequest.getAttribute(2).getValue();
            if (userPass.length > 0) {
                byte[] encryptedPass = this.encodePapPassword(userPass, requestAuthenticator);
                accessRequest.setAttribute(new RadiusAttribute(2, encryptedPass));
            }
        }
        catch (RadiusException userPass) {
            // empty catch block
        }
        accessRequest.setAttribute(new RadiusAttribute(32, NAS_ID));
        byte[] requestAttributes = accessRequest.getAttributeBytes();
        short length = (short)(20 + requestAttributes.length);
        DatagramPacket packet = this.composeRadiusPacket(this.getAuthPort(), code, identifier, length, requestAuthenticator, requestAttributes);
        RadiusPacket responsePacket = null;
        packet = this.sendReceivePacket(packet, retries);
        if (packet == null) {
            throw new RadiusException("null returned from sendReceivePacket");
        }
        responsePacket = this.checkRadiusPacket(packet, identifier, requestAuthenticator);
        return responsePacket;
    }

    public RadiusPacket account(RadiusPacket requestPacket) throws InvalidParameterException, RadiusException {
        if (null == requestPacket) {
            throw new InvalidParameterException("requestPacket parameter cannot be null");
        }
        byte code = requestPacket.getPacketType();
        if (code != 4) {
            throw new InvalidParameterException("Invalid type passed in for RadiusPacket");
        }
        try {
            requestPacket.getAttribute(1);
            requestPacket.getAttribute(40);
            requestPacket.getAttribute(44);
            requestPacket.getAttribute(6);
        }
        catch (RadiusException rex) {
            throw new InvalidParameterException("Missing RadiusAttribute in Accounting RequestPacket: " + rex.getMessage());
        }
        byte identifier = requestPacket.getPacketIdentifier();
        requestPacket.setAttribute(new RadiusAttribute(32, NAS_ID));
        byte[] requestAttributesBytes = requestPacket.getAttributeBytes();
        short length = (short)(20 + requestAttributesBytes.length);
        byte[] requestAuthenticator = this.makeRFC2866RequestAuthenticator(code, identifier, length, requestAttributesBytes);
        DatagramPacket packet = this.composeRadiusPacket(this.getAcctPort(), code, identifier, length, requestAuthenticator, requestAttributesBytes);
        RadiusPacket responsePacket = null;
        packet = this.sendReceivePacket(packet, 3);
        if (packet != null) {
            responsePacket = this.checkRadiusPacket(packet, identifier, requestAuthenticator);
            if (5 != responsePacket.getPacketType()) {
                throw new RadiusException("The radius Server responded with an incorrect response type.");
            }
        } else {
            throw new RadiusException("null returned from sendReceivePacket");
        }
        return responsePacket;
    }

    private byte[] encodePapPassword(byte[] userPass, byte[] requestAuthenticator) {
        int i;
        byte[] userPassBytes = null;
        if (userPass.length > 128) {
            userPassBytes = new byte[128];
            System.arraycopy(userPass, 0, userPassBytes, 0, 128);
        } else {
            userPassBytes = userPass;
        }
        byte[] encryptedPass = null;
        encryptedPass = userPassBytes.length < 128 ? (userPassBytes.length % 16 == 0 ? new byte[userPassBytes.length] : new byte[userPassBytes.length / 16 * 16 + 16]) : new byte[128];
        System.arraycopy(userPassBytes, 0, encryptedPass, 0, userPassBytes.length);
        for (int i2 = userPassBytes.length; i2 < encryptedPass.length; ++i2) {
            encryptedPass[i2] = 0;
        }
        this.md5MessageDigest.reset();
        this.md5MessageDigest.update(this.sharedSecret.getBytes());
        this.md5MessageDigest.update(requestAuthenticator);
        byte[] bn = this.md5MessageDigest.digest();
        for (i = 0; i < 16; ++i) {
            encryptedPass[i] = (byte)(bn[i] ^ encryptedPass[i]);
        }
        if (encryptedPass.length > 16) {
            for (i = 16; i < encryptedPass.length; i += 16) {
                this.md5MessageDigest.reset();
                this.md5MessageDigest.update(this.sharedSecret.getBytes());
                this.md5MessageDigest.update(encryptedPass, i - 16, 16);
                bn = this.md5MessageDigest.digest();
                for (int j = 0; j < 16; ++j) {
                    encryptedPass[i + j] = (byte)(bn[j] ^ encryptedPass[i + j]);
                }
            }
        }
        return encryptedPass;
    }

    private byte[] makeRFC2865RequestAuthenticator() {
        byte[] requestAuthenticator = new byte[16];
        Random r = new Random();
        for (int i = 0; i < 16; ++i) {
            requestAuthenticator[i] = (byte)r.nextInt();
        }
        this.md5MessageDigest.reset();
        this.md5MessageDigest.update(this.sharedSecret.getBytes());
        this.md5MessageDigest.update(requestAuthenticator);
        return this.md5MessageDigest.digest();
    }

    private byte[] makeRFC2865ResponseAuthenticator(byte code, byte identifier, short length, byte[] requestAuthenticator, byte[] responseAttributeBytes) {
        this.md5MessageDigest.reset();
        this.md5MessageDigest.update(code);
        this.md5MessageDigest.update(identifier);
        this.md5MessageDigest.update((byte)(length >> 8));
        this.md5MessageDigest.update((byte)(length & 0xFF));
        this.md5MessageDigest.update(requestAuthenticator, 0, requestAuthenticator.length);
        this.md5MessageDigest.update(responseAttributeBytes, 0, responseAttributeBytes.length);
        this.md5MessageDigest.update(this.sharedSecret.getBytes());
        return this.md5MessageDigest.digest();
    }

    private byte[] makeRFC2866RequestAuthenticator(byte code, byte identifier, short length, byte[] requestAttributes) {
        byte[] requestAuthenticator = new byte[16];
        for (int i = 0; i < 16; ++i) {
            requestAuthenticator[i] = 0;
        }
        this.md5MessageDigest.reset();
        this.md5MessageDigest.update(code);
        this.md5MessageDigest.update(identifier);
        this.md5MessageDigest.update((byte)(length >> 8));
        this.md5MessageDigest.update((byte)(length & 0xFF));
        this.md5MessageDigest.update(requestAuthenticator, 0, requestAuthenticator.length);
        this.md5MessageDigest.update(requestAttributes, 0, requestAttributes.length);
        this.md5MessageDigest.update(this.sharedSecret.getBytes());
        return this.md5MessageDigest.digest();
    }

    public String getHostname() {
        return this.hostname.getHostName();
    }

    private void setHostname(String hostname) throws InvalidParameterException {
        if (hostname == null) {
            throw new InvalidParameterException("Hostname can not be null!");
        }
        if (hostname.trim().equals("")) {
            throw new InvalidParameterException("Hostname can not be empty or all blanks!");
        }
        try {
            this.hostname = InetAddress.getByName(hostname);
        }
        catch (UnknownHostException uhex) {
            throw new InvalidParameterException("Hostname failed InetAddress.getByName() validation!");
        }
    }

    public int getAuthPort() {
        return this.authenticationPort;
    }

    private void setAuthPort(int port) throws InvalidParameterException {
        if (port <= 0 || port >= 65536) {
            throw new InvalidParameterException("Port value out of range!");
        }
        this.authenticationPort = port;
    }

    public int getAcctPort() {
        return this.accountingPort;
    }

    private void setAcctPort(int port) throws InvalidParameterException {
        if (port <= 0 || port >= 65536) {
            throw new InvalidParameterException("Port value out of range!");
        }
        this.accountingPort = port;
    }

    public String getSharedSecret() {
        return this.sharedSecret;
    }

    private void setSharedSecret(String sharedSecret) throws InvalidParameterException {
        if (sharedSecret == null) {
            throw new InvalidParameterException("Shared secret can not be null!");
        }
        if (sharedSecret.equals("")) {
            throw new InvalidParameterException("Shared secret can not be an empty string!");
        }
        this.sharedSecret = sharedSecret;
    }

    public int getTimeout() {
        return this.socketTimeout;
    }

    private void setTimeout(int socket_timeout) throws InvalidParameterException {
        if (socket_timeout < 0) {
            throw new InvalidParameterException("A negative timeout value is not allowed!");
        }
        this.socketTimeout = socket_timeout;
        try {
            if (null == this.socket) {
                this.socket = new DatagramSocket();
            }
            this.socket.setSoTimeout(this.socketTimeout);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    private RadiusPacket checkRadiusPacket(DatagramPacket packet, byte requestIdentifier, byte[] requestAuthenticator) throws RadiusException {
        ByteArrayInputStream bais = new ByteArrayInputStream(packet.getData());
        DataInputStream input = new DataInputStream(bais);
        try {
            int returnCode = -1;
            int packetLength = packet.getLength();
            byte code = input.readByte();
            returnCode = code & 0xFF;
            byte identifierByte = input.readByte();
            if (identifierByte != requestIdentifier) {
                throw new RadiusException("The RADIUS Server returned the wrong Identifier.");
            }
            short length = (short)(input.readShort() & 0xFFFF);
            byte[] responseAuthenticator = new byte[16];
            input.readFully(responseAuthenticator);
            byte[] responseAttributeBytes = new byte[length - 20];
            input.readFully(responseAttributeBytes);
            byte[] myResponseAuthenticator = this.makeRFC2865ResponseAuthenticator(code, identifierByte, length, requestAuthenticator, responseAttributeBytes);
            if (responseAuthenticator.length != 16 || myResponseAuthenticator.length != 16) {
                throw new RadiusException("Authenticator length is incorrect.");
            }
            for (int i = 0; i < responseAuthenticator.length; ++i) {
                if (responseAuthenticator[i] == myResponseAuthenticator[i]) continue;
                throw new RadiusException("Authenticators do not match, response packet not validated!");
            }
            RadiusPacket responsePacket = new RadiusPacket(returnCode, identifierByte);
            int attributesLength = responseAttributeBytes.length;
            if (attributesLength > 0) {
                int attributeLength;
                DataInputStream attributeInput = new DataInputStream(new ByteArrayInputStream(responseAttributeBytes));
                for (int left = 0; left < attributesLength; left += attributeLength) {
                    int attributeType = attributeInput.readByte() & 0xFF;
                    attributeLength = attributeInput.readByte() & 0xFF;
                    byte[] attributeValue = new byte[attributeLength - 2];
                    attributeInput.read(attributeValue, 0, attributeLength - 2);
                    responsePacket.setAttribute(new RadiusAttribute(attributeType, attributeValue));
                }
                attributeInput.close();
            }
            RadiusPacket radiusPacket = responsePacket;
            return radiusPacket;
        }
        catch (IOException ioex) {
            throw new RadiusException(ioex.getMessage());
        }
        catch (InvalidParameterException ipex) {
            throw new RadiusException("Invalid response attributes sent back from server.");
        }
        finally {
            try {
                input.close();
                bais.close();
            }
            catch (IOException iOException) {}
        }
    }

    private DatagramPacket composeRadiusPacket(int port, byte code, byte identifier, short length, byte[] requestAuthenticator, byte[] requestAttributes) throws RadiusException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(baos);
        DatagramPacket packet_out = null;
        try {
            output.writeByte(code);
            output.writeByte(identifier);
            output.writeShort(length);
            output.write(requestAuthenticator, 0, 16);
            output.write(requestAttributes, 0, requestAttributes.length);
            packet_out = new DatagramPacket(new byte[length], length);
            packet_out.setPort(port);
            packet_out.setAddress(this.hostname);
            packet_out.setLength(length);
            packet_out.setData(baos.toByteArray());
            output.close();
            baos.close();
        }
        catch (IOException ioex) {
            throw new RadiusException(ioex.getMessage());
        }
        return packet_out;
    }

    private DatagramPacket sendReceivePacket(DatagramPacket packet_out, int retry) throws RadiusException {
        if (packet_out.getLength() > 4096) {
            throw new RadiusException("Packet too big!");
        }
        if (packet_out.getLength() < 20) {
            throw new RadiusException("Packet too short !");
        }
        DatagramPacket packet_in = new DatagramPacket(new byte[4096], 4096);
        for (int i = 1; i <= retry; ++i) {
            try {
                this.socket.send(packet_out);
                this.socket.receive(packet_in);
                return packet_in;
            }
            catch (IOException ioex) {
                if (i != retry) continue;
                throw new RadiusException(ioex.getMessage());
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("RadiusClient: HostName = ");
        sb.append(this.getHostname());
        sb.append(" Port = ");
        sb.append(Integer.toString(this.getAuthPort()));
        sb.append(" Shared Secret = ");
        sb.append(this.getSharedSecret());
        return sb.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof RadiusClient)) {
            return false;
        }
        RadiusClient that = (RadiusClient)object;
        if (this.getHostname().equals(that.getHostname()) && this.getAuthPort() == that.getAuthPort() && this.getSharedSecret().equals(that.getSharedSecret())) {
            return true;
        }
        return true;
    }

    public int hashCode() {
        StringBuffer sb = new StringBuffer(this.getHostname());
        sb.append(Integer.toString(this.getAuthPort()));
        sb.append(this.getSharedSecret());
        return sb.toString().hashCode();
    }

    protected void closeSocket() {
        this.socket.close();
    }

    public void finalize() throws Throwable {
        this.closeSocket();
        super.finalize();
    }

    static {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            NAS_ID = localHost.getHostName().getBytes();
            NAS_IP = localHost.getHostAddress().getBytes();
        }
        catch (UnknownHostException uhex) {
            throw new RuntimeException(uhex.getMessage());
        }
    }
}

