/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jradiusclient;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.jradiusclient.RadiusAttribute;
import net.sourceforge.jradiusclient.exception.InvalidParameterException;
import net.sourceforge.jradiusclient.exception.RadiusException;

public class RadiusPacket {
    public static final int MIN_PACKET_LENGTH = 20;
    public static final int MAX_PACKET_LENGTH = 4096;
    public static final short RADIUS_HEADER_LENGTH = 20;
    public static final String EMPTYSTRING = "";
    public static final int ACCESS_REQUEST = 1;
    public static final int ACCESS_ACCEPT = 2;
    public static final int ACCESS_REJECT = 3;
    public static final int ACCOUNTING_REQUEST = 4;
    public static final int ACCOUNTING_RESPONSE = 5;
    public static final int ACCOUNTING_STATUS = 6;
    public static final int PASSWORD_REQUEST = 7;
    public static final int PASSWORD_ACCEPT = 8;
    public static final int PASSWORD_REJECT = 9;
    public static final int ACCOUNTING_MESSAGE = 10;
    public static final int ACCESS_CHALLENGE = 11;
    public static final int STATUS_SERVER = 12;
    public static final int STATUS_CLIENT = 13;
    public static final int RESERVED = 255;
    private static Object nextPacketIdLock = new Object();
    private static byte nextPacketId = 0;
    private int packetType = 0;
    private byte packetIdentifier = 0;
    private Map attributes;

    public RadiusPacket(int type) throws InvalidParameterException {
        this(type, RadiusPacket.getAndIncrementPacketIdentifier(), new ArrayList());
    }

    public RadiusPacket(int type, byte identifier) throws InvalidParameterException {
        this(type, identifier, new ArrayList());
    }

    public RadiusPacket(int type, List attributeList) throws InvalidParameterException {
        this(type, RadiusPacket.getAndIncrementPacketIdentifier(), attributeList);
    }

    public RadiusPacket(int type, byte identifier, List attributeList) throws InvalidParameterException {
        if (type < 1 || type > 256) {
            throw new InvalidParameterException("Type was out of bounds");
        }
        if (null == attributeList) {
            throw new InvalidParameterException("Attribute List was null");
        }
        this.packetType = type;
        this.packetIdentifier = identifier;
        this.attributes = new HashMap();
        this.setAttributes(attributeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(RadiusAttribute radiusAttribute) throws InvalidParameterException {
        if (null == radiusAttribute) {
            throw new InvalidParameterException("radiusAttribute was null");
        }
        this.validateAttribute(radiusAttribute);
        Map map = this.attributes;
        synchronized (map) {
            this.attributes.put(new Integer(radiusAttribute.getType()), radiusAttribute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(List attributeList) throws InvalidParameterException {
        if (null == attributeList) {
            throw new InvalidParameterException("Attribute List was null");
        }
        Iterator iter = attributeList.iterator();
        while (iter.hasNext()) {
            RadiusAttribute tempRa;
            try {
                tempRa = (RadiusAttribute)iter.next();
                this.validateAttribute(tempRa);
            }
            catch (ClassCastException ccex) {
                throw new InvalidParameterException("Attribute List contained an entry that was not a net.sourceforge.jradiusclient.RadiusAttribute");
            }
            Map map = this.attributes;
            synchronized (map) {
                this.attributes.put(new Integer(tempRa.getType()), tempRa);
            }
        }
    }

    protected void validateAttribute(RadiusAttribute attribute) throws InvalidParameterException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RadiusAttribute getAttribute(int attributeType) throws InvalidParameterException, RadiusException {
        if (attributeType < 0 || attributeType > 256) {
            throw new InvalidParameterException("attributeType is out of bounds");
        }
        RadiusAttribute tempRa = null;
        Map map = this.attributes;
        synchronized (map) {
            tempRa = (RadiusAttribute)this.attributes.get(new Integer(attributeType));
        }
        if (null == tempRa) {
            throw new RadiusException("No attribute found for type " + attributeType);
        }
        return tempRa;
    }

    public Collection getAttributes() {
        return this.attributes.values();
    }

    public byte getPacketType() {
        return (byte)this.packetType;
    }

    public byte getPacketIdentifier() {
        return this.packetIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final byte[] getAttributeBytes() throws RadiusException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        Map map = this.attributes;
        synchronized (map) {
            Iterator attributeList = this.attributes.values().iterator();
            while (attributeList.hasNext()) {
                try {
                    bytes.write(((RadiusAttribute)attributeList.next()).getBytes());
                }
                catch (IOException ioex) {
                    throw new RadiusException("Error writing bytes to ByteArrayOutputStream!!!");
                }
            }
            return bytes.toByteArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte getAndIncrementPacketIdentifier() {
        Object object = nextPacketIdLock;
        synchronized (object) {
            byte by = nextPacketId;
            nextPacketId = (byte)(by + 1);
            return by;
        }
    }
}

