/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jradiusclient;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import net.sourceforge.jradiusclient.RadiusAttribute;
import net.sourceforge.jradiusclient.RadiusClient;
import net.sourceforge.jradiusclient.RadiusPacket;
import net.sourceforge.jradiusclient.exception.InvalidParameterException;
import net.sourceforge.jradiusclient.exception.RadiusException;
import net.sourceforge.jradiusclient.packets.AccountingRequest;
import net.sourceforge.jradiusclient.packets.ChapAccessRequest;
import net.sourceforge.jradiusclient.packets.PapAccessRequest;
import net.sourceforge.jradiusclient.util.ChapUtil;

public class TestRadiusClient {
    public static String getUsage() {
        return "usage: TestRadiusClient -s RadiusServer -S sharedSecret [--authPort=1812] [--acctPort=1813]";
    }

    public static void main(String[] args) {
        int authport = 1812;
        int acctport = 1813;
        String host = "localhost";
        String sharedSecret = "testing123";
        StringBuffer portSb = new StringBuffer();
        RadiusClient rc = null;
        try {
            rc = new RadiusClient(host, authport, acctport, sharedSecret);
        }
        catch (RadiusException rex) {
            TestRadiusClient.log(rex.getMessage());
            TestRadiusClient.log(TestRadiusClient.getUsage());
            System.exit(4);
        }
        catch (InvalidParameterException ivpex) {
            TestRadiusClient.log("Unable to create Radius Client due to invalid parameter!");
            TestRadiusClient.log(ivpex.getMessage());
            TestRadiusClient.log(TestRadiusClient.getUsage());
            System.exit(5);
        }
        ChapUtil chapUtil = new ChapUtil();
        BufferedReader inputReader = new BufferedReader(new InputStreamReader(System.in));
        TestRadiusClient.basicAuthenticate(rc, chapUtil, inputReader);
        TestRadiusClient.advAuthenticate(rc, chapUtil, inputReader);
    }

    private static void basicAuthenticate(RadiusClient rc, ChapUtil chapUtil, BufferedReader inputReader) {
        try {
            boolean attributes = false;
            boolean continueTest = true;
            String userName = null;
            String userPass = null;
            String authMethod = null;
            System.out.println("Performing tests using basic classes: ");
            while (continueTest) {
                boolean more;
                attributes = false;
                RadiusPacket accessRequest = new RadiusPacket(1);
                System.out.print("Username: ");
                userName = inputReader.readLine();
                RadiusAttribute userNameAttribute = new RadiusAttribute(1, userName.getBytes());
                accessRequest.setAttribute(userNameAttribute);
                System.out.print("Password: ");
                userPass = inputReader.readLine();
                System.out.print("Authentication method [PAP | chap]: ");
                authMethod = inputReader.readLine();
                if (authMethod.equalsIgnoreCase("chap")) {
                    byte[] chapChallenge = chapUtil.getNextChapChallenge(16);
                    accessRequest.setAttribute(new RadiusAttribute(3, TestRadiusClient.chapEncrypt(userPass, chapChallenge, chapUtil)));
                    accessRequest.setAttribute(new RadiusAttribute(60, chapChallenge));
                } else {
                    accessRequest.setAttribute(new RadiusAttribute(2, userPass.getBytes()));
                }
                System.out.print("Additional Attributes? [y|N]:");
                boolean bl = more = inputReader.readLine().equalsIgnoreCase("y");
                while (more) {
                    System.out.print("Attribute Type:");
                    int type = Integer.parseInt(inputReader.readLine());
                    System.out.print("AttributeValue:");
                    byte[] value = inputReader.readLine().getBytes();
                    accessRequest.setAttribute(new RadiusAttribute(type, value));
                    System.out.print("Additional Attributes? [y|N]:");
                    more = inputReader.readLine().equalsIgnoreCase("y");
                }
                RadiusPacket accessResponse = rc.authenticate(accessRequest);
                switch (accessResponse.getPacketType()) {
                    case 2: {
                        TestRadiusClient.log("User " + userName + " authenticated");
                        TestRadiusClient.printAttributes(accessResponse);
                        TestRadiusClient.basicAccount(rc, userName);
                        break;
                    }
                    case 3: {
                        TestRadiusClient.log("User " + userName + " NOT authenticated");
                        TestRadiusClient.printAttributes(accessResponse);
                        break;
                    }
                    case 11: {
                        String reply = new String(accessResponse.getAttribute(18).getValue());
                        TestRadiusClient.log("User " + userName + " Challenged with " + reply);
                        break;
                    }
                    default: {
                        TestRadiusClient.log("Whoa, what kind of RadiusPacket is this " + accessResponse.getPacketType());
                    }
                }
                System.out.print("Another Basic Test [ Y | n ]: ");
                authMethod = inputReader.readLine();
                if (!authMethod.equalsIgnoreCase("n")) continue;
                continueTest = false;
            }
        }
        catch (InvalidParameterException ivpex) {
            TestRadiusClient.log(ivpex.getMessage());
        }
        catch (RadiusException rex) {
            TestRadiusClient.log(rex.getMessage());
        }
        catch (IOException ioex) {
            TestRadiusClient.log(ioex.getMessage());
        }
    }

    private static byte[] chapEncrypt(String plainText, byte[] chapChallenge, ChapUtil chapUtil) {
        byte chapIdentifier = chapUtil.getNextChapIdentifier();
        byte[] chapPassword = new byte[17];
        chapPassword[0] = chapIdentifier;
        System.arraycopy(ChapUtil.chapEncrypt(chapIdentifier, plainText.getBytes(), chapChallenge), 0, chapPassword, 1, 16);
        return chapPassword;
    }

    private static void basicAccount(RadiusClient rc, String userName) throws InvalidParameterException, RadiusException {
        RadiusPacket accountRequest = new RadiusPacket(4);
        accountRequest.setAttribute(new RadiusAttribute(1, userName.getBytes()));
        accountRequest.setAttribute(new RadiusAttribute(40, new byte[]{0, 0, 0, 1}));
        accountRequest.setAttribute(new RadiusAttribute(44, "bob".getBytes()));
        accountRequest.setAttribute(new RadiusAttribute(6, new byte[]{0, 0, 0, 1}));
        RadiusPacket accountResponse = rc.account(accountRequest);
        switch (accountResponse.getPacketType()) {
            case 10: {
                TestRadiusClient.log("User " + userName + " got ACCOUNTING_MESSAGE response");
                break;
            }
            case 5: {
                TestRadiusClient.log("User " + userName + " got ACCOUNTING_RESPONSE response");
                break;
            }
            case 6: {
                TestRadiusClient.log("User " + userName + " got ACCOUNTING_STATUS response");
                break;
            }
            default: {
                TestRadiusClient.log("User " + userName + " got invalid response " + accountResponse.getPacketType());
            }
        }
        TestRadiusClient.printAttributes(accountResponse);
    }

    private static void advAuthenticate(RadiusClient rc, ChapUtil chapUtil, BufferedReader inputReader) {
        try {
            boolean attributes = false;
            boolean continueTest = true;
            String userName = null;
            String userPass = null;
            String authMethod = null;
            System.out.println("Performing tests using advanced classes: ");
            while (continueTest) {
                boolean more;
                attributes = false;
                RadiusPacket accessRequest = null;
                System.out.print("Username: ");
                userName = inputReader.readLine();
                System.out.print("Password: ");
                userPass = inputReader.readLine();
                System.out.print("Authentication method [PAP | chap]: ");
                authMethod = inputReader.readLine();
                accessRequest = authMethod.equalsIgnoreCase("chap") ? new ChapAccessRequest(userName, userPass) : new PapAccessRequest(userName, userPass);
                System.out.print("Additional Attributes? [y|N]:");
                boolean bl = more = inputReader.readLine().equalsIgnoreCase("y");
                while (more) {
                    System.out.print("Attribute Type:");
                    int type = Integer.parseInt(inputReader.readLine());
                    System.out.print("AttributeValue:");
                    byte[] value = inputReader.readLine().getBytes();
                    accessRequest.setAttribute(new RadiusAttribute(type, value));
                    System.out.print("Additional Attributes? [y|N]:");
                    more = inputReader.readLine().equalsIgnoreCase("y");
                }
                RadiusPacket accessResponse = rc.authenticate(accessRequest);
                switch (accessResponse.getPacketType()) {
                    case 2: {
                        TestRadiusClient.log("User " + userName + " authenticated");
                        TestRadiusClient.printAttributes(accessResponse);
                        TestRadiusClient.advAccount(rc, userName);
                        break;
                    }
                    case 3: {
                        TestRadiusClient.log("User " + userName + " NOT authenticated");
                        TestRadiusClient.printAttributes(accessResponse);
                        break;
                    }
                    case 11: {
                        String reply = new String(accessResponse.getAttribute(18).getValue());
                        TestRadiusClient.log("User " + userName + " Challenged with " + reply);
                        break;
                    }
                    default: {
                        TestRadiusClient.log("Whoa, what kind of RadiusPacket is this " + accessResponse.getPacketType());
                    }
                }
                System.out.print("Another Advanced Test [ Y | n ]: ");
                authMethod = inputReader.readLine();
                if (!authMethod.equalsIgnoreCase("n")) continue;
                continueTest = false;
            }
        }
        catch (InvalidParameterException ivpex) {
            TestRadiusClient.log(ivpex.getMessage());
        }
        catch (RadiusException rex) {
            TestRadiusClient.log(rex.getMessage());
        }
        catch (IOException ioex) {
            TestRadiusClient.log(ioex.getMessage());
        }
    }

    private static void advAccount(RadiusClient rc, String userName) throws InvalidParameterException, RadiusException {
        AccountingRequest accountRequest = new AccountingRequest(userName, new byte[]{0, 0, 0, 1}, userName);
        RadiusPacket accountResponse = rc.account(accountRequest);
        switch (accountResponse.getPacketType()) {
            case 10: {
                TestRadiusClient.log("User " + userName + " got ACCOUNTING_MESSAGE response");
                break;
            }
            case 5: {
                TestRadiusClient.log("User " + userName + " got ACCOUNTING_RESPONSE response");
                break;
            }
            case 6: {
                TestRadiusClient.log("User " + userName + " got ACCOUNTING_STATUS response");
                break;
            }
            default: {
                TestRadiusClient.log("User " + userName + " got invalid response " + accountResponse.getPacketType());
            }
        }
        TestRadiusClient.printAttributes(accountResponse);
    }

    private static void printAttributes(RadiusPacket rp) {
        Iterator attributes = rp.getAttributes().iterator();
        System.out.println("Response Packet Attributes");
        System.out.println("\tType\tValue");
        while (attributes.hasNext()) {
            RadiusAttribute tempRa = (RadiusAttribute)attributes.next();
            System.out.println("\t" + tempRa.getType() + "\t" + new String(tempRa.getValue()));
        }
    }

    private static void log(String message) {
        System.out.print("TestRadiusClient: ");
        System.out.println(message);
    }
}

