/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jradiusclient.jaas;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.sourceforge.jradiusclient.jaas.RadiusCallback;

public class RadiusLoginHandler
implements CallbackHandler {
    public static final String JAAS_MODULE_KEY = "JRadiusClientLoginModule";
    private String name;
    private String password;
    private String clientIP;
    private String hostName;
    private String sharedSecret;
    private int authPort;
    private int acctPort;
    private String callingStationID;
    private int numRetries;
    private int timeout;

    public RadiusLoginHandler(String name, String password, String clientIP, String callingStationID, String radiusHostname, String sharedSecret, int authPort, int acctPort, int retries, int timeout) {
        if (name == null || password == null || clientIP == null) {
            throw new IllegalArgumentException("Arguments cannont be null");
        }
        this.name = name;
        this.password = password;
        this.clientIP = clientIP;
        this.callingStationID = callingStationID;
        this.hostName = radiusHostname;
        this.sharedSecret = sharedSecret;
        this.authPort = authPort;
        this.acctPort = acctPort;
        this.numRetries = retries;
        this.timeout = timeout;
    }

    public void login() throws LoginException {
        LoginContext loginContext = new LoginContext(JAAS_MODULE_KEY, this);
        loginContext.login();
    }

    @Override
    public void handle(Callback[] callback) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callback.length; ++i) {
            this.handle(callback[i]);
        }
    }

    protected void handle(Callback callback) throws UnsupportedCallbackException {
        if (callback instanceof NameCallback) {
            ((NameCallback)callback).setName(this.name);
        } else if (callback instanceof PasswordCallback) {
            ((PasswordCallback)callback).setPassword(this.password.toCharArray());
        } else if (callback instanceof TextInputCallback) {
            ((TextInputCallback)callback).setText(this.clientIP);
        } else if (callback instanceof RadiusCallback) {
            RadiusCallback radiusCallback = (RadiusCallback)callback;
            radiusCallback.setHostName(this.hostName);
            radiusCallback.setSharedSecret(this.sharedSecret);
            radiusCallback.setAuthPort(this.authPort);
            radiusCallback.setAcctPort(this.acctPort);
            radiusCallback.setCallingStationID(this.callingStationID);
            radiusCallback.setNumRetries(this.numRetries);
            radiusCallback.setTimeout(this.timeout);
        } else {
            throw new UnsupportedCallbackException(callback);
        }
    }
}

