/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jradiusclient.packets;

import net.sourceforge.jradiusclient.RadiusAttribute;
import net.sourceforge.jradiusclient.RadiusPacket;
import net.sourceforge.jradiusclient.attributes.ChapChallengeAttribute;
import net.sourceforge.jradiusclient.attributes.ChapPasswordAttribute;
import net.sourceforge.jradiusclient.attributes.UserNameAttribute;
import net.sourceforge.jradiusclient.exception.InvalidParameterException;
import net.sourceforge.jradiusclient.util.ChapUtil;

public class ChapAccessRequest
extends RadiusPacket {
    private static final ChapUtil chapUtil = new ChapUtil();
    private boolean initialized = false;

    public ChapAccessRequest(String userName, byte[] chapEncryptedPassword, byte chapIndentifier, byte[] chapChallenge) throws InvalidParameterException {
        super(1);
        this.initialize(userName, chapEncryptedPassword, chapIndentifier, chapChallenge);
    }

    public ChapAccessRequest(String userName, String plaintextPassword) throws InvalidParameterException {
        this(userName, plaintextPassword.getBytes(), 16);
    }

    public ChapAccessRequest(String userName, byte[] plaintextPassword) throws InvalidParameterException {
        this(userName, plaintextPassword, 16);
    }

    public ChapAccessRequest(String userName, byte[] plaintextPassword, int challengeSize) throws InvalidParameterException {
        super(1);
        byte chapIndentifier = chapUtil.getNextChapIdentifier();
        byte[] chapChallenge = chapUtil.getNextChapChallenge(challengeSize);
        byte[] chapEncryptedPassword = ChapUtil.chapEncrypt(chapIndentifier, plaintextPassword, chapChallenge);
        this.initialize(userName, chapEncryptedPassword, chapIndentifier, chapChallenge);
    }

    private void initialize(String userName, byte[] chapEncryptedPassword, byte chapIndentifier, byte[] chapChallenge) throws InvalidParameterException {
        this.setAttribute(new UserNameAttribute(userName));
        this.setAttribute(new ChapPasswordAttribute(chapIndentifier, chapEncryptedPassword));
        this.setAttribute(new ChapChallengeAttribute(chapChallenge));
        this.initialized = true;
    }

    @Override
    public void validateAttribute(RadiusAttribute radiusAttribute) throws InvalidParameterException {
        if (this.initialized && (radiusAttribute.getType() == 1 || radiusAttribute.getType() == 3 || radiusAttribute.getType() == 60)) {
            throw new InvalidParameterException("Already initialized, cannot reset username, chap password or chap challenge.");
        }
        if (radiusAttribute.getType() == 2) {
            throw new InvalidParameterException("Already initialized, cannot set USER_PASSWORD in a CHAP Access Request.");
        }
    }
}

