/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jradiusclient.packets;

import net.sourceforge.jradiusclient.RadiusAttribute;
import net.sourceforge.jradiusclient.RadiusPacket;
import net.sourceforge.jradiusclient.attributes.UserNameAttribute;
import net.sourceforge.jradiusclient.attributes.UserPasswordAttribute;
import net.sourceforge.jradiusclient.exception.InvalidParameterException;

public class PapAccessRequest
extends RadiusPacket {
    private boolean initialized = false;

    public PapAccessRequest(String userName, String plaintextPassword) throws InvalidParameterException {
        this(userName, plaintextPassword.getBytes());
    }

    public PapAccessRequest(String userName, byte[] plaintextPassword) throws InvalidParameterException {
        super(1);
        this.setAttribute(new UserNameAttribute(userName));
        this.setAttribute(new UserPasswordAttribute(plaintextPassword));
        this.initialized = true;
    }

    @Override
    public void validateAttribute(RadiusAttribute radiusAttribute) throws InvalidParameterException {
        if (this.initialized && radiusAttribute.getType() == 1) {
            throw new InvalidParameterException("Already initialized, cannot reset username.");
        }
    }
}

