/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.WireParseException;

public class LOCRecord
extends Record {
    private static final long serialVersionUID = 9058224788126750409L;
    private static NumberFormat w2 = new DecimalFormat();
    private static NumberFormat w3;
    private long size;
    private long hPrecision;
    private long vPrecision;
    private long latitude;
    private long longitude;
    private long altitude;

    LOCRecord() {
    }

    @Override
    Record getObject() {
        return new LOCRecord();
    }

    public LOCRecord(Name name, int dclass, long ttl, double latitude, double longitude, double altitude, double size, double hPrecision, double vPrecision) {
        super(name, 29, dclass, ttl);
        this.latitude = (long)(latitude * 3600.0 * 1000.0 + 2.147483648E9);
        this.longitude = (long)(longitude * 3600.0 * 1000.0 + 2.147483648E9);
        this.altitude = (long)((altitude + 100000.0) * 100.0);
        this.size = (long)(size * 100.0);
        this.hPrecision = (long)(hPrecision * 100.0);
        this.vPrecision = (long)(vPrecision * 100.0);
    }

    @Override
    void rrFromWire(DNSInput in) throws IOException {
        int version = in.readU8();
        if (version != 0) {
            throw new WireParseException("Invalid LOC version");
        }
        this.size = LOCRecord.parseLOCformat(in.readU8());
        this.hPrecision = LOCRecord.parseLOCformat(in.readU8());
        this.vPrecision = LOCRecord.parseLOCformat(in.readU8());
        this.latitude = in.readU32();
        this.longitude = in.readU32();
        this.altitude = in.readU32();
    }

    private double parseFixedPoint(String s) {
        if (s.matches("^-?\\d+$")) {
            return Integer.parseInt(s);
        }
        if (s.matches("^-?\\d+\\.\\d*$")) {
            String[] parts = s.split("\\.");
            double value = Integer.parseInt(parts[0]);
            double fraction = Integer.parseInt(parts[1]);
            if (value < 0.0) {
                fraction *= -1.0;
            }
            int digits = parts[1].length();
            return value + fraction / Math.pow(10.0, digits);
        }
        throw new NumberFormatException();
    }

    private long parsePosition(Tokenizer st, String type) throws IOException {
        boolean isLatitude = type.equals("latitude");
        int deg = 0;
        int min = 0;
        double sec = 0.0;
        deg = st.getUInt16();
        if (deg > 180 || deg > 90 && isLatitude) {
            throw st.exception("Invalid LOC " + type + " degrees");
        }
        String s = st.getString();
        try {
            min = Integer.parseInt(s);
            if (min < 0 || min > 59) {
                throw st.exception("Invalid LOC " + type + " minutes");
            }
            s = st.getString();
            sec = this.parseFixedPoint(s);
            if (sec < 0.0 || sec >= 60.0) {
                throw st.exception("Invalid LOC " + type + " seconds");
            }
            s = st.getString();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (s.length() != 1) {
            throw st.exception("Invalid LOC " + type);
        }
        long value = (long)(1000.0 * (sec + (double)(60L * ((long)min + 60L * (long)deg))));
        char c = Character.toUpperCase(s.charAt(0));
        if (isLatitude && c == 'S' || !isLatitude && c == 'W') {
            value = -value;
        } else if (isLatitude && c != 'N' || !isLatitude && c != 'E') {
            throw st.exception("Invalid LOC " + type);
        }
        return value += 0x80000000L;
    }

    private long parseDouble(Tokenizer st, String type, boolean required, long min, long max, long defaultValue) throws IOException {
        Tokenizer.Token token = st.get();
        if (token.isEOL()) {
            if (required) {
                throw st.exception("Invalid LOC " + type);
            }
            st.unget();
            return defaultValue;
        }
        String s = token.value;
        if (s.length() > 1 && s.charAt(s.length() - 1) == 'm') {
            s = s.substring(0, s.length() - 1);
        }
        try {
            long value = (long)(100.0 * this.parseFixedPoint(s));
            if (value < min || value > max) {
                throw st.exception("Invalid LOC " + type);
            }
            return value;
        }
        catch (NumberFormatException e) {
            throw st.exception("Invalid LOC " + type);
        }
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.latitude = this.parsePosition(st, "latitude");
        this.longitude = this.parsePosition(st, "longitude");
        this.altitude = this.parseDouble(st, "altitude", true, -10000000L, 4284967295L, 0L) + 10000000L;
        this.size = this.parseDouble(st, "size", false, 0L, 9000000000L, 100L);
        this.hPrecision = this.parseDouble(st, "horizontal precision", false, 0L, 9000000000L, 1000000L);
        this.vPrecision = this.parseDouble(st, "vertical precision", false, 0L, 9000000000L, 1000L);
    }

    private void renderFixedPoint(StringBuffer sb, NumberFormat formatter, long value, long divisor) {
        sb.append(value / divisor);
        if ((value %= divisor) != 0L) {
            sb.append(".");
            sb.append(formatter.format(value));
        }
    }

    private String positionToString(long value, char pos, char neg) {
        char direction;
        StringBuffer sb = new StringBuffer();
        long temp = value - 0x80000000L;
        if (temp < 0L) {
            temp = -temp;
            direction = neg;
        } else {
            direction = pos;
        }
        sb.append(temp / 3600000L);
        sb.append(" ");
        sb.append((temp %= 3600000L) / 60000L);
        sb.append(" ");
        this.renderFixedPoint(sb, w3, temp %= 60000L, 1000L);
        sb.append(" ");
        sb.append(direction);
        return sb.toString();
    }

    @Override
    String rrToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.positionToString(this.latitude, 'N', 'S'));
        sb.append(" ");
        sb.append(this.positionToString(this.longitude, 'E', 'W'));
        sb.append(" ");
        this.renderFixedPoint(sb, w2, this.altitude - 10000000L, 100L);
        sb.append("m ");
        this.renderFixedPoint(sb, w2, this.size, 100L);
        sb.append("m ");
        this.renderFixedPoint(sb, w2, this.hPrecision, 100L);
        sb.append("m ");
        this.renderFixedPoint(sb, w2, this.vPrecision, 100L);
        sb.append("m");
        return sb.toString();
    }

    public double getLatitude() {
        return (double)(this.latitude - 0x80000000L) / 3600000.0;
    }

    public double getLongitude() {
        return (double)(this.longitude - 0x80000000L) / 3600000.0;
    }

    public double getAltitude() {
        return (double)(this.altitude - 10000000L) / 100.0;
    }

    public double getSize() {
        return (double)this.size / 100.0;
    }

    public double getHPrecision() {
        return (double)this.hPrecision / 100.0;
    }

    public double getVPrecision() {
        return (double)this.vPrecision / 100.0;
    }

    @Override
    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeU8(0);
        out.writeU8(this.toLOCformat(this.size));
        out.writeU8(this.toLOCformat(this.hPrecision));
        out.writeU8(this.toLOCformat(this.vPrecision));
        out.writeU32(this.latitude);
        out.writeU32(this.longitude);
        out.writeU32(this.altitude);
    }

    private static long parseLOCformat(int b) throws WireParseException {
        long out = b >> 4;
        int exp = b & 0xF;
        if (out > 9L || exp > 9) {
            throw new WireParseException("Invalid LOC Encoding");
        }
        while (exp-- > 0) {
            out *= 10L;
        }
        return out;
    }

    private int toLOCformat(long l) {
        int exp = 0;
        while (l > 9L) {
            exp = (byte)(exp + 1);
            l /= 10L;
        }
        return (int)((l << 4) + (long)exp);
    }

    static {
        w2.setMinimumIntegerDigits(2);
        w3 = new DecimalFormat();
        w3.setMinimumIntegerDigits(3);
    }
}

