/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.xbill.DNS.Master;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.ZoneTransferException;
import org.xbill.DNS.ZoneTransferIn;

public class Zone
implements Serializable {
    private static final long serialVersionUID = -9220510891189510942L;
    public static final int PRIMARY = 1;
    public static final int SECONDARY = 2;
    private Map data;
    private Name origin;
    private Object originNode;
    private int dclass = 1;
    private RRset NS;
    private SOARecord SOA;
    private boolean hasWild;

    private void validate() throws IOException {
        this.originNode = this.exactName(this.origin);
        if (this.originNode == null) {
            throw new IOException(this.origin + ": no data specified");
        }
        RRset rrset = this.oneRRset(this.originNode, 6);
        if (rrset == null || rrset.size() != 1) {
            throw new IOException(this.origin + ": exactly 1 SOA must be specified");
        }
        Iterator it = rrset.rrs();
        this.SOA = (SOARecord)it.next();
        this.NS = this.oneRRset(this.originNode, 2);
        if (this.NS == null) {
            throw new IOException(this.origin + ": no NS set specified");
        }
    }

    private final void maybeAddRecord(Record record) throws IOException {
        int rtype = record.getType();
        Name name = record.getName();
        if (rtype == 6 && !name.equals(this.origin)) {
            throw new IOException("SOA owner " + name + " does not match zone origin " + this.origin);
        }
        if (name.subdomain(this.origin)) {
            this.addRecord(record);
        }
    }

    public Zone(Name zone, String file) throws IOException {
        Record record;
        this.data = new TreeMap();
        if (zone == null) {
            throw new IllegalArgumentException("no zone name specified");
        }
        Master m = new Master(file, zone);
        this.origin = zone;
        while ((record = m.nextRecord()) != null) {
            this.maybeAddRecord(record);
        }
        this.validate();
    }

    public Zone(Name zone, Record[] records) throws IOException {
        this.data = new TreeMap();
        if (zone == null) {
            throw new IllegalArgumentException("no zone name specified");
        }
        this.origin = zone;
        for (int i = 0; i < records.length; ++i) {
            this.maybeAddRecord(records[i]);
        }
        this.validate();
    }

    private void fromXFR(ZoneTransferIn xfrin) throws IOException, ZoneTransferException {
        this.data = new TreeMap();
        this.origin = xfrin.getName();
        List records = xfrin.run();
        for (Record record : records) {
            this.maybeAddRecord(record);
        }
        if (!xfrin.isAXFR()) {
            throw new IllegalArgumentException("zones can only be created from AXFRs");
        }
        this.validate();
    }

    public Zone(ZoneTransferIn xfrin) throws IOException, ZoneTransferException {
        this.fromXFR(xfrin);
    }

    public Zone(Name zone, int dclass, String remote) throws IOException, ZoneTransferException {
        ZoneTransferIn xfrin = ZoneTransferIn.newAXFR(zone, remote, null);
        xfrin.setDClass(dclass);
        this.fromXFR(xfrin);
    }

    public Name getOrigin() {
        return this.origin;
    }

    public RRset getNS() {
        return this.NS;
    }

    public SOARecord getSOA() {
        return this.SOA;
    }

    public int getDClass() {
        return this.dclass;
    }

    private synchronized Object exactName(Name name) {
        return this.data.get(name);
    }

    private synchronized RRset[] allRRsets(Object types) {
        if (types instanceof List) {
            List typelist = (List)types;
            return typelist.toArray(new RRset[typelist.size()]);
        }
        RRset set = (RRset)types;
        return new RRset[]{set};
    }

    private synchronized RRset oneRRset(Object types, int type) {
        if (type == 255) {
            throw new IllegalArgumentException("oneRRset(ANY)");
        }
        if (types instanceof List) {
            List list = (List)types;
            for (int i = 0; i < list.size(); ++i) {
                RRset set = (RRset)list.get(i);
                if (set.getType() != type) continue;
                return set;
            }
        } else {
            RRset set = (RRset)types;
            if (set.getType() == type) {
                return set;
            }
        }
        return null;
    }

    private synchronized RRset findRRset(Name name, int type) {
        Object types = this.exactName(name);
        if (types == null) {
            return null;
        }
        return this.oneRRset(types, type);
    }

    private synchronized void addRRset(Name name, RRset rrset) {
        Object types;
        if (!this.hasWild && name.isWild()) {
            this.hasWild = true;
        }
        if ((types = this.data.get(name)) == null) {
            this.data.put(name, rrset);
            return;
        }
        int rtype = rrset.getType();
        if (types instanceof List) {
            List list = (List)types;
            for (int i = 0; i < list.size(); ++i) {
                RRset set = (RRset)list.get(i);
                if (set.getType() != rtype) continue;
                list.set(i, rrset);
                return;
            }
            list.add(rrset);
        } else {
            RRset set = (RRset)types;
            if (set.getType() == rtype) {
                this.data.put(name, rrset);
            } else {
                LinkedList<RRset> list = new LinkedList<RRset>();
                list.add(set);
                list.add(rrset);
                this.data.put(name, list);
            }
        }
    }

    private synchronized void removeRRset(Name name, int type) {
        Object types = this.data.get(name);
        if (types == null) {
            return;
        }
        if (types instanceof List) {
            List list = (List)types;
            for (int i = 0; i < list.size(); ++i) {
                RRset set = (RRset)list.get(i);
                if (set.getType() != type) continue;
                list.remove(i);
                if (list.size() == 0) {
                    this.data.remove(name);
                }
                return;
            }
        } else {
            RRset set = (RRset)types;
            if (set.getType() != type) {
                return;
            }
            this.data.remove(name);
        }
    }

    private synchronized SetResponse lookup(Name name, int type) {
        RRset rrset;
        Object types;
        Name tname;
        int olabels;
        if (!name.subdomain(this.origin)) {
            return SetResponse.ofType(1);
        }
        int labels = name.labels();
        for (int tlabels = olabels = this.origin.labels(); tlabels <= labels; ++tlabels) {
            RRset ns;
            boolean isExact;
            boolean isOrigin = tlabels == olabels;
            boolean bl = isExact = tlabels == labels;
            tname = isOrigin ? this.origin : (isExact ? name : new Name(name, labels - tlabels));
            types = this.exactName(tname);
            if (types == null) continue;
            if (!isOrigin && (ns = this.oneRRset(types, 2)) != null) {
                return new SetResponse(3, ns);
            }
            if (isExact && type == 255) {
                SetResponse sr = new SetResponse(6);
                RRset[] sets = this.allRRsets(types);
                for (int i = 0; i < sets.length; ++i) {
                    sr.addRRset(sets[i]);
                }
                return sr;
            }
            if (isExact) {
                rrset = this.oneRRset(types, type);
                if (rrset != null) {
                    SetResponse sr = new SetResponse(6);
                    sr.addRRset(rrset);
                    return sr;
                }
                rrset = this.oneRRset(types, 5);
                if (rrset != null) {
                    return new SetResponse(4, rrset);
                }
            } else {
                rrset = this.oneRRset(types, 39);
                if (rrset != null) {
                    return new SetResponse(5, rrset);
                }
            }
            if (!isExact) continue;
            return SetResponse.ofType(2);
        }
        if (this.hasWild) {
            for (int i = 0; i < labels - olabels; ++i) {
                tname = name.wild(i + 1);
                types = this.exactName(tname);
                if (types == null || (rrset = this.oneRRset(types, type)) == null) continue;
                SetResponse sr = new SetResponse(6);
                sr.addRRset(rrset);
                return sr;
            }
        }
        return SetResponse.ofType(1);
    }

    public SetResponse findRecords(Name name, int type) {
        return this.lookup(name, type);
    }

    public RRset findExactMatch(Name name, int type) {
        Object types = this.exactName(name);
        if (types == null) {
            return null;
        }
        return this.oneRRset(types, type);
    }

    public void addRRset(RRset rrset) {
        Name name = rrset.getName();
        this.addRRset(name, rrset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecord(Record r) {
        Name name = r.getName();
        int rtype = r.getRRsetType();
        Zone zone = this;
        synchronized (zone) {
            RRset rrset = this.findRRset(name, rtype);
            if (rrset == null) {
                rrset = new RRset(r);
                this.addRRset(name, rrset);
            } else {
                rrset.addRR(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRecord(Record r) {
        Name name = r.getName();
        int rtype = r.getRRsetType();
        Zone zone = this;
        synchronized (zone) {
            RRset rrset = this.findRRset(name, rtype);
            if (rrset == null) {
                return;
            }
            if (rrset.size() == 1 && rrset.first().equals(r)) {
                this.removeRRset(name, rtype);
            } else {
                rrset.deleteRR(r);
            }
        }
    }

    public Iterator iterator() {
        return new ZoneIterator(false);
    }

    public Iterator AXFR() {
        return new ZoneIterator(true);
    }

    private void nodeToString(StringBuffer sb, Object node) {
        RRset[] sets = this.allRRsets(node);
        for (int i = 0; i < sets.length; ++i) {
            RRset rrset = sets[i];
            Iterator it = rrset.rrs();
            while (it.hasNext()) {
                sb.append(it.next() + "\n");
            }
            it = rrset.sigs();
            while (it.hasNext()) {
                sb.append(it.next() + "\n");
            }
        }
    }

    public synchronized String toMasterFile() {
        Iterator zentries = this.data.entrySet().iterator();
        StringBuffer sb = new StringBuffer();
        this.nodeToString(sb, this.originNode);
        while (zentries.hasNext()) {
            Map.Entry entry = zentries.next();
            if (this.origin.equals(entry.getKey())) continue;
            this.nodeToString(sb, entry.getValue());
        }
        return sb.toString();
    }

    public String toString() {
        return this.toMasterFile();
    }

    class ZoneIterator
    implements Iterator {
        private Iterator zentries;
        private RRset[] current;
        private int count;
        private boolean wantLastSOA;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ZoneIterator(boolean axfr) {
            Zone zone = Zone.this;
            synchronized (zone) {
                this.zentries = Zone.this.data.entrySet().iterator();
            }
            this.wantLastSOA = axfr;
            RRset[] sets = Zone.this.allRRsets(Zone.this.originNode);
            this.current = new RRset[sets.length];
            int j = 2;
            for (int i = 0; i < sets.length; ++i) {
                int type = sets[i].getType();
                if (type == 6) {
                    this.current[0] = sets[i];
                    continue;
                }
                if (type == 2) {
                    this.current[1] = sets[i];
                    continue;
                }
                this.current[j++] = sets[i];
            }
        }

        @Override
        public boolean hasNext() {
            return this.current != null || this.wantLastSOA;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.current == null) {
                this.wantLastSOA = false;
                return Zone.this.oneRRset(Zone.this.originNode, 6);
            }
            RRset set = this.current[this.count++];
            if (this.count == this.current.length) {
                this.current = null;
                while (this.zentries.hasNext()) {
                    RRset[] sets;
                    Map.Entry entry = (Map.Entry)this.zentries.next();
                    if (entry.getKey().equals(Zone.this.origin) || (sets = Zone.this.allRRsets(entry.getValue())).length == 0) continue;
                    this.current = sets;
                    this.count = 0;
                    break;
                }
            }
            return set;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

