/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo.util;

import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.ServerConnection;
import java.lang.reflect.Constructor;

public class MorUtil {
    public static final String moPackageName = "com.vmware.vim25.mo";

    public static ManagedObjectReference[] createMORs(ManagedObject[] mos) {
        if (mos == null) {
            throw new IllegalArgumentException();
        }
        ManagedObjectReference[] mors = new ManagedObjectReference[mos.length];
        int i = 0;
        while (i < mos.length) {
            mors[i] = mos[i].getMOR();
            ++i;
        }
        return mors;
    }

    public static ManagedObject createExactManagedObject(ServerConnection sc, ManagedObjectReference mor) {
        if (mor == null) {
            return null;
        }
        String moType = mor.getType();
        try {
            Class<?> moClass = Class.forName("com.vmware.vim25.mo." + moType);
            Constructor<?> constructor = moClass.getConstructor(ServerConnection.class, ManagedObjectReference.class);
            return (ManagedObject)constructor.newInstance(sc, mor);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ManagedEntity createExactManagedEntity(ServerConnection sc, ManagedObjectReference mor) {
        return (ManagedEntity)MorUtil.createExactManagedObject(sc, mor);
    }

    public static ManagedEntity[] createManagedEntities(ServerConnection sc, ManagedObjectReference[] mors) {
        if (mors == null) {
            return new ManagedEntity[0];
        }
        ManagedEntity[] mes = new ManagedEntity[mors.length];
        int i = 0;
        while (i < mors.length) {
            mes[i] = MorUtil.createExactManagedEntity(sc, mors[i]);
            ++i;
        }
        return mes;
    }
}

