/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.snmp;

import com.blixx.boom.snmp.SystemUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class FileUtils {
    public static String invalidFileNameChars_regex = "[\"/*?<>:\\\\|@',;!% =]+";

    public static void copyFile(File source, File target) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(source);
            fos = new FileOutputStream(target);
            int count = -1;
            byte[] buffer = new byte[2048];
            while ((count = fis.read(buffer)) != -1) {
                fos.write(buffer, 0, count);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            fis.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            fos.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void appendFile(File source, File target) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(source);
            fos = new FileOutputStream(target, true);
            int count = -1;
            byte[] buffer = new byte[2048];
            while ((count = fis.read(buffer)) != -1) {
                fos.write(buffer, 0, count);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            fis.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            fos.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String resolveEnvVars(String in) {
        Set<String> keys = System.getenv().keySet();
        for (String key : keys) {
            String val = System.getenv(key);
            if (val == null) {
                val = "";
            }
            if (SystemUtils.OS == 1) {
                in = in.replace("%" + key + "%", val);
                continue;
            }
            in = in.replace("${" + key + "}", val);
            in = in.replace("$" + key, val);
        }
        return in;
    }

    public static void deleteDirectoryRecursive(String dirPath) throws IOException {
        boolean deleted = true;
        File dir = new File(dirPath);
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles();
            int i = 0;
            while (i < files.length) {
                String canonicalPath = files[i].getCanonicalPath();
                if (files[i].isFile()) {
                    deleted = files[i].delete();
                    if (!deleted) {
                        throw new IOException("Can't delete file " + canonicalPath);
                    }
                } else {
                    FileUtils.deleteDirectoryRecursive(canonicalPath);
                }
                ++i;
            }
            deleted = dir.delete();
            if (!deleted) {
                throw new IOException("Can't delete directory " + dir.getCanonicalPath());
            }
        }
    }

    public static List<File> getPathsRecursive(String dirPath) throws IOException {
        LinkedList<File> toCollect = new LinkedList<File>();
        File dir = new File(dirPath);
        if (dir.exists() && dir.isDirectory()) {
            toCollect.add(dir);
            File[] files = dir.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isFile()) {
                    toCollect.add(files[i]);
                } else {
                    toCollect.addAll(FileUtils.getPathsRecursive(files[i].getCanonicalPath()));
                }
                ++i;
            }
        }
        return toCollect;
    }

    public static String getValidFileName(String name) {
        return name.replaceAll(invalidFileNameChars_regex, "_");
    }

    public static String readFile(File file) throws IOException {
        StringBuffer sb;
        block13: {
            sb = new StringBuffer();
            InputStreamReader fr = null;
            try {
                try {
                    fr = new FileReader(file);
                    BufferedReader br = new BufferedReader(fr);
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        if (sb.length() > 0) {
                            sb.append('\n');
                        }
                        sb.append(line);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    try {
                        fr.close();
                    }
                    catch (Throwable throwable) {}
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    fr.close();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                fr.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    public static List<String> readFileAsList(File file) throws IOException {
        LinkedList<String> lines = new LinkedList<String>();
        InputStreamReader fr = null;
        try {
            try {
                fr = new FileReader(file);
                BufferedReader br = new BufferedReader(fr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    lines.add(line);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    fr.close();
                }
                catch (Throwable throwable) {}
            }
        }
        finally {
            try {
                fr.close();
            }
            catch (Throwable throwable) {}
        }
        return lines;
    }

    public static void writeFileAsList(File file, List<String> lines) throws IOException {
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(file, false);
                for (String line : lines) {
                    fos.write(line.getBytes());
                    fos.write(10);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    fos.close();
                }
                catch (Throwable throwable) {}
            }
        }
        finally {
            try {
                fos.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

