/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.snmp;

import com.blixx.boom.snmp.FileUtils;
import com.blixx.boom.snmp.LogFileFilterAll;
import com.blixx.boom.snmp.LogFileFilterWeekOlder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SALogger {
    private static final String LOG_EXTENSION = ".log";
    protected static final String LL_START = " <";
    protected static final String LL_END = "> ";
    protected int m_level = 1;
    public static int LEVEL_1 = 1;
    public static int LEVEL_2 = 2;
    public static int LEVEL_3 = 3;
    public static int LEVEL_OFF = 0;
    protected PrintStream m_log = System.out;
    protected String m_dir = null;
    protected String m_currentFile = null;
    protected String FILE_PREFIX = "RTlog_";
    protected int m_count = 1;
    protected long SIZE_LIMIT = 0L;
    protected int FILE_LIMIT = 0;
    protected static Map<PrintStream, File> m_streamMap = new ConcurrentHashMap<PrintStream, File>();
    protected static Map<String, File> m_logfiles = new ConcurrentHashMap<String, File>();
    public SimpleDateFormat m_sdf_rtlogger = new SimpleDateFormat("yyMMdd HH:mm:ss");
    public AtomicBoolean m_enabled = new AtomicBoolean(true);
    static Pattern m_pattern_size = Pattern.compile("\\s*(\\d+)\\s*(\\w*)\\s*");

    public SALogger() {
    }

    public SALogger(String dir, String prefix, int logCount, long sizelimit) {
        this.setMaxCount(logCount);
        this.setMaxSize(sizelimit);
        this.setDir(dir, prefix);
        this.checkLogLimits();
    }

    public boolean isEnabled() {
        return this.m_enabled.get();
    }

    public void setEnabled(boolean enabled) {
        if (this.m_enabled.compareAndSet(!enabled, enabled) && !enabled) {
            try {
                File f = m_streamMap.remove(this.m_log);
                this.closeAllStreams(f);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(int level, String msg) {
        block7: {
            if (msg == null || !this.isEnabled()) {
                return;
            }
            try {
                if (level > this.m_level || msg.trim().length() <= 0) break block7;
                StringBuffer sb = new StringBuffer();
                sb.append(this.getTime()).append(LL_START).append(level).append(LL_END).append(msg.replace('\n', '\t'));
                PrintStream printStream = this.getPrintStream(false);
                File f = m_streamMap.get(printStream);
                if (f != null) {
                    File file = f;
                    synchronized (file) {
                        printStream.println(sb.toString());
                        f.notify();
                        break block7;
                    }
                }
                printStream.println(sb.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(int level, StringBuffer msg) {
        block7: {
            try {
                if (msg == null || !this.isEnabled()) {
                    return;
                }
                if (level > this.m_level || msg.length() <= 0) break block7;
                msg.insert(0, LL_END);
                msg.insert(0, level);
                msg.insert(0, LL_START);
                msg.insert(0, this.getTime());
                PrintStream printStream = this.getPrintStream(false);
                File f = m_streamMap.get(printStream);
                if (f != null) {
                    File file = f;
                    synchronized (file) {
                        printStream.println(msg.toString());
                        f.notify();
                        break block7;
                    }
                }
                printStream.println(msg.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(int level, StringBuilder msg) {
        block7: {
            try {
                if (msg == null || !this.isEnabled()) {
                    return;
                }
                if (level > this.m_level || msg.length() <= 0) break block7;
                msg.insert(0, LL_END);
                msg.insert(0, level);
                msg.insert(0, LL_START);
                msg.insert(0, this.getTime());
                PrintStream printStream = this.getPrintStream(false);
                File f = m_streamMap.get(printStream);
                if (f != null) {
                    File file = f;
                    synchronized (file) {
                        printStream.println(msg.toString());
                        f.notify();
                        break block7;
                    }
                }
                printStream.println(msg.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStringDirect(String msg) {
        if (msg == null || !this.isEnabled()) {
            return;
        }
        PrintStream printStream = this.getPrintStream(false);
        File f = m_streamMap.get(printStream);
        if (f != null) {
            File file = f;
            synchronized (file) {
                printStream.println(msg.toString());
                f.notify();
            }
        } else {
            printStream.println(msg.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(int level, String msg, Throwable e) {
        block8: {
            if (msg == null || !this.isEnabled()) {
                return;
            }
            if (level <= this.m_level) {
                try {
                    StringBuffer sb = new StringBuffer();
                    sb.append(this.getTime()).append(LL_START).append(level).append(LL_END).append(msg).append(" Exception:").append(e.getMessage());
                    PrintStream printStream = this.getPrintStream(false);
                    File f = m_streamMap.get(printStream);
                    if (f != null) {
                        File file = f;
                        synchronized (file) {
                            printStream.println(sb.toString());
                            e.printStackTrace(this.m_log);
                            f.notify();
                            break block8;
                        }
                    }
                    printStream.println(sb.toString());
                    e.printStackTrace(this.m_log);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public void print(int level, String msg, Object ... arguments) {
        this.print(level, String.format(msg, arguments));
    }

    public PrintStream getPrintStream(boolean isDirChanged) {
        try {
            if (isDirChanged || this.m_log != System.out) {
                String old = this.m_currentFile;
                this.m_currentFile = this.getCurrentFilename();
                if (isDirChanged || this.m_currentFile != null && !this.m_currentFile.equals(old)) {
                    this.rotateLogfile(this.m_dir, this.m_currentFile);
                } else {
                    File cf = new File(this.m_currentFile);
                    if (!cf.exists() || this.m_log.checkError()) {
                        this.rotateLogfile(this.m_dir, this.m_currentFile);
                    }
                }
            }
        }
        catch (Throwable e) {
            this.setPrintStream(null, System.out);
        }
        return this.m_log;
    }

    public String getCurrentFileName() {
        return this.m_currentFile;
    }

    public void setPrintStream(File file, PrintStream out) {
        if (this.m_log != null && this.m_log != System.out && this.m_log != out) {
            this.closeAllStreams(m_streamMap.get(this.m_log));
        }
        if (file != null) {
            m_streamMap.put(out, file);
        }
        this.m_log = out;
    }

    public String getDir() {
        return this.m_dir;
    }

    public void setDir(String logFileDir, String prefix) {
        if (logFileDir == null) {
            this.m_dir = null;
            this.m_log = System.out;
            return;
        }
        this.setPrefix(prefix);
        this.checkLogLimits();
        logFileDir = SALogger.normalizePath(logFileDir);
        if (this.m_dir == null) {
            this.m_count = this.getMaxCountForToday(logFileDir);
        }
        boolean isDirChanged = !logFileDir.equals(this.m_dir);
        this.m_dir = logFileDir;
        File checkDir = new File(this.m_dir);
        if (!checkDir.exists()) {
            checkDir.mkdirs();
        }
        this.getPrintStream(isDirChanged);
    }

    public static String normalizePath(String logFileDir) {
        if (logFileDir == null || logFileDir.length() == 0) {
            return null;
        }
        logFileDir = FileUtils.resolveEnvVars(logFileDir);
        logFileDir = File.separator.equals("/") ? logFileDir.replace("\\", File.separator) : logFileDir.replace("/", File.separator);
        if (!logFileDir.endsWith(File.separator)) {
            logFileDir = String.valueOf(logFileDir) + File.separator;
        }
        return logFileDir;
    }

    protected int getMaxCountForToday(String logFileDir) {
        int maxExistingCounter;
        block6: {
            final String fullTodayPrefix = this.getTodayPrefix();
            maxExistingCounter = 1;
            try {
                File[] todayFiles = new File(logFileDir).listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.contains(fullTodayPrefix);
                    }
                });
                if (todayFiles != null && todayFiles.length > 0) {
                    int i = 0;
                    while (i < todayFiles.length) {
                        String name = todayFiles[i].getName();
                        name = name.replace(fullTodayPrefix, "");
                        name = name.replace(LOG_EXTENSION, "");
                        try {
                            int counter = Integer.parseInt(name);
                            maxExistingCounter = Math.max(maxExistingCounter, counter);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        ++i;
                    }
                    break block6;
                }
                maxExistingCounter = 1;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return maxExistingCounter;
    }

    protected String getTodayPrefix() {
        Calendar rightNow = Calendar.getInstance();
        int dom = rightNow.get(5);
        StringBuffer mid = new StringBuffer();
        mid.append(this.FILE_PREFIX);
        mid.append(rightNow.get(1)).append('.');
        mid.append(rightNow.get(2) + 1).append('.');
        mid.append(dom).append('_');
        return mid.toString();
    }

    protected void rotateLogfile(String directory, String newFilename) {
        try {
            String fullPath = String.valueOf(directory) + newFilename;
            File nlf = null;
            nlf = m_logfiles.get(fullPath);
            if (nlf == null) {
                nlf = new File(String.valueOf(directory) + newFilename);
                m_logfiles.put(fullPath, nlf);
            }
            FileOutputStream fos = new FileOutputStream(nlf, true);
            this.setPrintStream(nlf, new PrintStream(fos, true));
        }
        catch (Throwable e) {
            this.setPrintStream(null, System.out);
        }
        if (this.FILE_LIMIT > 0) {
            this.deleteOlds2(directory);
        } else {
            this.deleteOlds(directory);
        }
    }

    protected String getCurrentFilename() {
        String fname = null;
        try {
            fname = null;
            String mid = this.getTodayPrefix();
            this.m_count = this.getMaxCountForToday(this.getDir());
            StringBuffer fin = new StringBuffer();
            fin.append(mid);
            fin.append(this.m_count);
            fin.append(LOG_EXTENSION);
            fname = fin.toString();
            File f = new File(String.valueOf(this.m_dir) + fname);
            if (this.m_log != null) {
                try {
                    this.m_log.flush();
                }
                catch (Throwable throwable) {}
            }
            while (this.SIZE_LIMIT > 0L && f.length() > this.SIZE_LIMIT) {
                ++this.m_count;
                fin = new StringBuffer();
                fin.append(mid);
                fin.append(this.m_count);
                fin.append(LOG_EXTENSION);
                fname = fin.toString();
                f = new File(String.valueOf(this.m_dir) + fname);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return fname;
    }

    protected void checkLogLimits() {
        if (!(this.getMaxSize() != 0L && this.getMaxFileCount() != 0 || this.getMaxSize() == 0L && this.getMaxFileCount() == 0)) {
            this.setMaxCount(0);
        }
    }

    protected void deleteOlds(String logFileDir) {
        try {
            File[] oldfiles;
            String dir = logFileDir;
            if (dir.endsWith(File.separator)) {
                dir = logFileDir.substring(0, logFileDir.length() - 1);
            }
            if ((oldfiles = new File(dir).listFiles(new LogFileFilterWeekOlder(this.getFilePrefix()))) != null) {
                int i = 0;
                while (i < oldfiles.length) {
                    File file = oldfiles[i];
                    if (!file.delete()) {
                        this.closeAllStreams(file);
                        file.delete();
                    }
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void deleteOlds2(String logFileDir) {
        try {
            File[] oldfiles2 = new File(logFileDir).listFiles(new LogFileFilterAll(this.getFilePrefix(), null));
            Comparator<File> comp = new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    int check1;
                    long l2;
                    long l1 = o1.lastModified() / 1000L;
                    int n = l1 < (l2 = o2.lastModified() / 1000L) ? -1 : (check1 = l1 == l2 ? 0 : 1);
                    if (check1 == 0) {
                        String name1 = o1.getName();
                        String in1 = name1.substring(name1.lastIndexOf(95) + 1, name1.lastIndexOf(46));
                        String name2 = o2.getName();
                        String in2 = name2.substring(name2.lastIndexOf(95) + 1, name2.lastIndexOf(46));
                        Integer i1 = Integer.parseInt(in1);
                        Integer i2 = Integer.parseInt(in2);
                        check1 = i1.compareTo(i2);
                    }
                    return check1;
                }
            };
            Arrays.sort(oldfiles2, comp);
            if (oldfiles2 != null) {
                int i = 0;
                while (i < oldfiles2.length - this.FILE_LIMIT) {
                    File file = oldfiles2[i];
                    m_logfiles.remove(file.getName());
                    if (file.exists() && !file.delete()) {
                        this.closeAllStreams(file);
                        if (file.exists()) {
                            file.delete();
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void closeAllStreams(File file) {
        if (file == null) {
            return;
        }
        try {
            Iterator<Map.Entry<PrintStream, File>> it = m_streamMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<PrintStream, File> entry = it.next();
                File value = entry.getValue();
                if (file.equals(value)) {
                    PrintStream key = entry.getKey();
                    if (key != null) {
                        key.close();
                    }
                    it.remove();
                    continue;
                }
                if (value != null) continue;
                it.remove();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getFilePrefix() {
        return this.FILE_PREFIX;
    }

    protected void setPrefix(String prefix) {
        this.FILE_PREFIX = prefix;
    }

    public String getTime() {
        Date d = new Date();
        return this.m_sdf_rtlogger.format(d);
    }

    public void setLevel(int i) {
        this.print(1, "Loglevel set to " + this.m_level);
        this.m_level = i;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.m_log.close();
    }

    public int getCurrentLevel() {
        return this.m_level;
    }

    public long parseMaxSize(String size) {
        long di;
        long maxSize = 0xA00000L;
        Matcher m = m_pattern_size.matcher(size = size.toLowerCase());
        if (m.matches()) {
            String digits = m.group(1);
            di = 0L;
            try {
                di = Long.parseLong(digits);
            }
            catch (Throwable e) {
                throw new RuntimeException("invalid logfile size input string: " + size);
            }
        } else {
            throw new RuntimeException("invalid logfile size input string: " + size);
        }
        String suffix = m.group(2).toLowerCase();
        long mult = 1L;
        mult = suffix.equalsIgnoreCase("kb") ? 1024L : (suffix.equalsIgnoreCase("mb") || suffix.equalsIgnoreCase("m") ? 0x100000L : (suffix.equalsIgnoreCase("gb") ? 0x40000000L : 0x100000L));
        maxSize = di * mult;
        return maxSize;
    }

    public long getMaxSize() {
        return this.SIZE_LIMIT;
    }

    public long getMaxSizeMB() {
        return this.SIZE_LIMIT / 0x100000L;
    }

    public int getMaxFileCount() {
        return this.FILE_LIMIT;
    }

    public void setMaxCount(int maxLogFilesCount) {
        if (maxLogFilesCount > 0) {
            this.FILE_LIMIT = maxLogFilesCount;
        } else if (maxLogFilesCount == 0) {
            this.FILE_LIMIT = 0;
            this.SIZE_LIMIT = 0L;
        }
    }

    public void setMaxSize(long maxSize) {
        if (maxSize > 0L) {
            this.SIZE_LIMIT = maxSize;
        }
    }
}

