/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.snmp;

import com.blixx.boom.snmp.SNMPTrapd;
import com.blixx.ext.IAction;
import java.util.List;
import java.util.Map;
import org.snmp4j.security.UsmUser;
import org.snmp4j.security.UsmUserEntry;
import org.snmp4j.smi.OctetString;

public class SNMPConfAction
implements IAction {
    public String run(String[] parameters, int timeout) {
        String result = "Invalid parameters";
        if (parameters.length > 0) {
            if ("-status".equalsIgnoreCase(parameters[0])) {
                StringBuilder sb = new StringBuilder();
                sb.append("Running instances:\n");
                Map<String, SNMPTrapd> instances = SNMPTrapd.getInstances();
                for (Map.Entry<String, SNMPTrapd> en : instances.entrySet()) {
                    sb.append("Owner policy: ").append(en.getKey()).append("\n");
                    sb.append("Local ID: ").append(en.getValue().getLocalEngineID()).append("\n");
                    sb.append("Traps Count: ").append(en.getValue().getProcessesTrapsCount()).append("\n");
                    sb.append("Known Users: ").append("\n");
                    List<UsmUserEntry> list = en.getValue().getSsmp().getUSM().getUserTable().getUserEntries();
                    for (UsmUserEntry uu : list) {
                        UsmUser usmUser = uu.getUsmUser();
                        String engineID = "";
                        OctetString engineID_octet = uu.getEngineID();
                        if (engineID_octet != null) {
                            engineID = engineID_octet.toHexString().replace(":", "");
                        }
                        String user = usmUser.getSecurityName().toString();
                        String authType = SNMPTrapd.getType(usmUser.getAuthenticationProtocol());
                        String privType = SNMPTrapd.getType(uu.getUsmUser().getPrivacyProtocol());
                        sb.append("   ");
                        sb.append("engineID: \"").append(engineID).append("\", ");
                        sb.append("userName: \"").append(user).append("\", ");
                        sb.append("authType: \"").append(authType).append("\", ");
                        sb.append("privType: \"").append(privType).append("\"");
                        sb.append("\n");
                    }
                }
                result = sb.toString();
            } else if (!"-addUser".equals(parameters[0]) && !"-removeUser".equals(parameters[0]) && "-reloadUSMFile".equals(parameters[0])) {
                Map<String, SNMPTrapd> instances = SNMPTrapd.getInstances();
                for (Map.Entry<String, SNMPTrapd> en : instances.entrySet()) {
                    en.getValue().loadUSMFile(SNMPTrapd.USM_FILE);
                }
            }
        }
        return result;
    }
}

