/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.snmp;

import com.blixx.boom.snmp.Cryptor;
import com.blixx.boom.snmp.SALogger;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitor;
import com.blixx.ext.IMonitorExt;
import com.blixx.ext.IMonitorSubmitter;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.WriterConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.DatagramPacket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.PDUv1;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Snmp;
import org.snmp4j.event.AuthenticationFailureEvent;
import org.snmp4j.event.AuthenticationFailureListener;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.AuthHMAC192SHA256;
import org.snmp4j.security.AuthHMAC384SHA512;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.Priv3DES;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.security.nonstandard.PrivAES192With3DESKeyExtension;
import org.snmp4j.security.nonstandard.PrivAES256With3DESKeyExtension;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.test.OIDTextFormatter;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.MultiThreadedMessageDispatcher;
import org.snmp4j.util.SnmpConfigurator;
import org.snmp4j.util.ThreadPool;

public class SNMPTrapd
implements CommandResponder,
IMonitorExt,
Runnable,
AuthenticationFailureListener {
    public static final File USM_FILE = new File("spi/snmp/users.asf");
    public static final String COMMENT = "comment";
    public static final String PRIV_PASS = "privPass";
    public static final String PRIV_EN_PASS = "privEnPass";
    public static final String PRIV_TYPE = "privType";
    public static final String AUTH_EN_PASS = "authEnPass";
    public static final String AUTH_PASS = "authPass";
    public static final String AUTH_TYPE = "authType";
    public static final String USER = "user";
    public static final String ENGINE_ID = "engineID";
    public static final String AGENT_ID = "agentID";
    public static final String SYSUPTIME_VARNAME = "T";
    private static String TRAPOID = ".1.3.6.1.6.3.1.1.4.1.0";
    private static final String SNMP_TRAP_ENTERPRISE_ID = ".1.3.6.1.6.3.1.1.4.3.0";
    private static final String SNMP_TRAPS = ".1.3.6.1.6.3.1.1.5";
    private static final String SNMP_SYSUPTIME = ".1.3.6.1.2.1.1.3";
    private static final String SNMP_SYSUPTIME2 = ".1.3.6.1.2.1.1.3.0";
    private static final String GROUP_SNMP = "SNMP";
    private static final String APPL_SNMPTRAPD = "SNMPTrapd";
    private static final int ERROR_EXCEPTION = -1;
    public static Map<String, SNMPTrapd> m_instances = new ConcurrentHashMap<String, SNMPTrapd>(2);
    public IMessage m_msgSubmitter = null;
    public int m_port = 162;
    private String m_monitorName = null;
    private Thread m_listenerThread = null;
    public boolean m_printOutput = false;
    public AtomicBoolean m_running = new AtomicBoolean(true);
    Thread m_publischerThread = null;
    private Snmp m_trapSession = null;
    private Address listenAddress;
    public USM m_usm;
    private byte[] m_localEngineID = OctetString.fromHexString("80:01:01:01:00:01:01:01").toByteArray();
    private Map<String, Long> m_unknownSecurityNameErrors = new HashMap<String, Long>();
    private Map<Address, String> m_serviceEngineIDs = new ConcurrentHashMap<Address, String>();
    static Map<String, String> GENERIC_TRAPS = new HashMap<String, String>(14, 0.99f);
    public static SALogger m_logger;
    private AtomicLong processedTraps = new AtomicLong(0L);
    private long startTimeNs = -1L;
    Pattern userPattern = Pattern.compile("(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s*");
    Pattern snmp4jEnginePattern1 = Pattern.compile("[0-9a-fxA-F]+");
    Pattern snmp4jEnginePattern2 = Pattern.compile("[0-9a-fA-F:]+");

    static {
        GENERIC_TRAPS.put("1.3.6.1.6.3.1.1.5.1", "0");
        GENERIC_TRAPS.put("1.3.6.1.6.3.1.1.5.2", "1");
        GENERIC_TRAPS.put("1.3.6.1.6.3.1.1.5.3", "2");
        GENERIC_TRAPS.put("1.3.6.1.6.3.1.1.5.4", "3");
        GENERIC_TRAPS.put("1.3.6.1.6.3.1.1.5.5", "4");
        GENERIC_TRAPS.put("1.3.6.1.6.3.1.1.5.6", "5");
        GENERIC_TRAPS.put(".1.3.6.1.6.3.1.1.5.1", "0");
        GENERIC_TRAPS.put(".1.3.6.1.6.3.1.1.5.2", "1");
        GENERIC_TRAPS.put(".1.3.6.1.6.3.1.1.5.3", "2");
        GENERIC_TRAPS.put(".1.3.6.1.6.3.1.1.5.4", "3");
        GENERIC_TRAPS.put(".1.3.6.1.6.3.1.1.5.5", "4");
        GENERIC_TRAPS.put(".1.3.6.1.6.3.1.1.5.6", "5");
        m_logger = new SALogger();
    }

    public static Map<String, SNMPTrapd> getInstances() {
        return m_instances;
    }

    public static IMonitor getInstance(String monitorName, String[] parameters) throws InitException {
        SNMPTrapd instance = m_instances.get(monitorName);
        if (instance == null) {
            instance = new SNMPTrapd();
            instance.m_monitorName = monitorName;
            ArrayList<String> usmLines = new ArrayList<String>();
            if (parameters != null && parameters.length > 0) {
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (i < parameters.length) {
                    sb.append(parameters[i]);
                    if (i < parameters.length - 1) {
                        sb.append(" ");
                    }
                    ++i;
                }
                ArrayList<String> list = new ArrayList<String>();
                Matcher m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(sb.toString());
                while (m.find()) {
                    list.add(m.group(1).replace("\"", ""));
                }
                parameters = list.toArray(new String[0]);
                try {
                    int i2 = 0;
                    while (i2 < parameters.length) {
                        String param = parameters[i2].trim();
                        if (param.equalsIgnoreCase("-p")) {
                            instance.m_port = Integer.parseInt(parameters[++i2]);
                        } else {
                            if (param.equalsIgnoreCase("-usm")) {
                                try {
                                    String line = parameters[++i2];
                                    usmLines.add(line);
                                }
                                catch (ArrayIndexOutOfBoundsException e) {
                                    throw new InitException("Incorrect parameters. One of the -usm parameters missed a value");
                                }
                            }
                            if (param.equalsIgnoreCase("-engineIDhex")) {
                                try {
                                    instance.m_localEngineID = OctetString.fromHexString(parameters[++i2]).toByteArray();
                                }
                                catch (Throwable e) {
                                    throw new InitException("Incorrect parameters -engineIDhex. String format expected: 80:01:01:01:00:01:01:01");
                                }
                            }
                        }
                        ++i2;
                    }
                }
                catch (InitException initException) {
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            instance.preInit();
            for (String line : usmLines) {
                instance.loadUser(line, instance.m_usm);
            }
            m_instances.put(instance.m_monitorName, instance);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block22: {
            try {
                if (this.m_trapSession != null) {
                    try {
                        Snmp snmp = this.m_trapSession;
                        synchronized (snmp) {
                            this.m_trapSession.notifyAll();
                        }
                        this.m_trapSession.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                Address listenAddress = GenericAddress.parse(System.getProperty("snmp4j.listenAddress", "udp:0.0.0.0/" + this.m_port));
                try {
                    if (!this.m_trapSession.addNotificationListener(listenAddress, this)) {
                        this.m_msgSubmitter.sendMessage(null, "AGENT", GROUP_SNMP, APPL_SNMPTRAPD, "Error: Failed to initialize notification listener.", "warning", null);
                        return;
                    }
                }
                catch (Exception e) {
                    this.m_msgSubmitter.sendMessage(null, "AGENT", GROUP_SNMP, APPL_SNMPTRAPD, "Error: Port is busy.", "warning", null);
                    this.m_trapSession = null;
                    return;
                }
                try {
                    Snmp e = this.m_trapSession;
                    synchronized (e) {
                        this.m_trapSession.wait();
                    }
                }
                catch (Throwable e) {
                    this.m_msgSubmitter.sendMessage(null, "AGENT", GROUP_SNMP, APPL_SNMPTRAPD, "SNMPv3Trapd stopped. Error: " + e.getMessage(), "warning", null);
                }
                try {
                    this.m_trapSession.close();
                }
                catch (Throwable throwable) {}
                break block22;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.m_trapSession = null;
            }
        }
    }

    public void preInit() {
        this.ensureEngineID();
        ThreadPool threadPool = ThreadPool.create("Trap", 3);
        MessageDispatcherImpl messageDispatcher = new MessageDispatcherImpl();
        messageDispatcher.addAuthenticationFailureListener(new AuthenticationFailureListener(){

            @Override
            public void authenticationFailure(AuthenticationFailureEvent event) {
            }
        });
        MultiThreadedMessageDispatcher mtDispatcher = new MultiThreadedMessageDispatcher(threadPool, messageDispatcher);
        this.m_trapSession = new Snmp(mtDispatcher);
        messageDispatcher.addAuthenticationFailureListener(this);
        SNMP4JSettings.setOIDTextFormat(new OIDTextFormatter());
        SecurityProtocols protocols = SecurityProtocols.getInstance();
        protocols.addDefaultProtocols();
        protocols.addPrivacyProtocol(new Priv3DES());
        MPv3 mPv3 = new MPv3();
        mPv3.setSecurityProtocols(protocols);
        mPv3.setLocalEngineID(this.m_localEngineID);
        this.m_trapSession.getMessageDispatcher().addMessageProcessingModel(new MPv1());
        this.m_trapSession.getMessageDispatcher().addMessageProcessingModel(new MPv2c());
        this.m_trapSession.getMessageDispatcher().addMessageProcessingModel(mPv3);
        try {
            DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
            transport.setAsyncMsgProcessingSupported(true);
            transport.addTransportListener(this.m_trapSession.getMessageDispatcher());
            this.m_trapSession.getMessageDispatcher().addTransportMapping(transport);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_usm = new USM(SecurityProtocols.getInstance(), new OctetString(this.m_localEngineID), 0);
        this.m_usm.setEngineDiscoveryEnabled(true);
        SecurityModels.getInstance().addSecurityModel(this.m_usm);
        this.m_trapSession.setContextEngineIdDiscoveryDisabled(false);
        this.loadUSMFile(USM_FILE);
    }

    public void ensureEngineID() {
        File eidFile;
        byte[] tempValue;
        block17: {
            File eidDir = new File("spi/snmp");
            if (!eidDir.exists()) {
                eidDir.mkdirs();
            }
            tempValue = MPv3.createLocalEngineID();
            eidFile = this.getEngineIDFile();
            if (eidFile.exists()) {
                FileInputStream fis = null;
                try {
                    try {
                        fis = new FileInputStream(eidFile);
                        byte[] temp = new byte[256];
                        int count = fis.read(temp);
                        if (count > 0) {
                            byte[] temp2 = new byte[count];
                            System.arraycopy(temp, 0, temp2, 0, count);
                            OctetString str = OctetString.fromHexString(new String(temp2));
                            this.m_localEngineID = str.getValue();
                        } else {
                            this.m_localEngineID = tempValue;
                        }
                    }
                    catch (Throwable e) {
                        this.m_localEngineID = tempValue;
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable) {}
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    fis.close();
                }
                catch (Throwable throwable) {}
            } else {
                this.m_localEngineID = tempValue;
            }
        }
        if (Arrays.equals(this.m_localEngineID, tempValue)) {
            this.storeEngineID(eidFile);
        }
    }

    private File getEngineIDFile() {
        File eidFile = new File("spi/snmp/engineid.dat");
        return eidFile;
    }

    private void storeEngineID(File eidFile) {
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(eidFile, false);
                fos.write(new OctetString(this.m_localEngineID).toHexString().getBytes());
            }
            catch (Throwable throwable) {
                try {
                    fos.close();
                }
                catch (Throwable throwable2) {}
            }
        }
        finally {
            try {
                fos.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public void processTrapV1(CommandResponderEvent event) {
        System.out.println("V1 Trap received");
        LinkedHashMap<String, String> opts = new LinkedHashMap<String, String>();
        PDUv1 pdu = (PDUv1)event.getPDU();
        String agentAddress = pdu.getAgentAddress().toString();
        opts.put("IP", agentAddress);
        opts.put("A", agentAddress);
        String enterprise = pdu.getEnterprise().toString();
        opts.put("Enterprise", enterprise);
        opts.put("e", enterprise);
        String generic = "" + pdu.getGenericTrap();
        opts.put("Generic", generic);
        opts.put("G", generic);
        String specific = "" + pdu.getSpecificTrap();
        opts.put("Specific", specific);
        opts.put("S", specific);
        opts.put(SYSUPTIME_VARNAME, "" + pdu.getTimestamp());
        OctetString community = new OctetString(event.getSecurityName());
        opts.put("Community", community.toString());
        opts.put("C", community.toString());
        String oid = String.valueOf(enterprise) + ":" + generic + "." + specific;
        opts.put("o", String.valueOf(enterprise) + "." + generic + "." + specific);
        ArrayList<? extends VariableBinding> list = new ArrayList<VariableBinding>();
        list.addAll(event.getPDU().getVariableBindings());
        opts.put("#", "" + list.size());
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < list.size()) {
            VariableBinding vb = (VariableBinding)list.get(i);
            String variableName = vb.getOid().toString();
            String variableValue = vb.getVariable().toString();
            opts.put(variableName, variableValue);
            opts.put("" + (i + 1), vb.getVariable().toString());
            sb.append(variableName).append("=").append(variableValue).append("\n");
            ++i;
        }
        String hostnameIP = pdu.getAgentAddress().toString();
        hostnameIP = agentAddress != null && agentAddress.length() > 0 ? agentAddress : (hostnameIP.startsWith("/") ? hostnameIP.substring(1) : hostnameIP.substring(0, hostnameIP.indexOf(47)));
        if (sb.length() == 0) {
            sb.append(oid);
        }
        this.m_msgSubmitter.sendMessage(hostnameIP, APPL_SNMPTRAPD, GROUP_SNMP, oid, sb.toString(), "warning", opts);
    }

    public void processTrapV2(CommandResponderEvent event) {
        LinkedHashMap<String, String> opts = new LinkedHashMap<String, String>();
        this.processAndSend(event, opts);
    }

    private void processTrapV3(CommandResponderEvent event) {
        LinkedHashMap<String, String> opts = new LinkedHashMap<String, String>();
        opts.put("SecurityName", new OctetString(event.getSecurityName()).toString());
        this.processAndSend(event, opts);
        if (this.m_unknownSecurityNameErrors.size() > 0) {
            try {
                String ipAddr = event.getPeerAddress().toString();
                int p1 = ipAddr.indexOf(47);
                if (p1 != -1) {
                    ipAddr = ipAddr.substring(0, p1);
                }
                ScopedPDU scopedPDU = (ScopedPDU)event.getPDU();
                String engineID = scopedPDU.getSecurityEngineID().toHexString();
                String user = scopedPDU.getContextName().toString();
                String key = String.valueOf(ipAddr) + "_" + engineID + "_" + user;
                this.m_unknownSecurityNameErrors.remove(key);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void processAndSend(CommandResponderEvent event, HashMap<String, String> opts) {
        String E;
        String S;
        String G;
        opts.put("PDUCommand", "" + (256 + event.getPDU().getType()));
        OctetString community = new OctetString(event.getSecurityName());
        opts.put("Community", community.toString());
        opts.put("C", community.toString());
        opts.put("PDUErrorStatus", "" + event.getPDU().getErrorStatus());
        opts.put("PDUErrorIndex", "" + event.getPDU().getErrorIndex());
        String severiry = "warning";
        ArrayList<VariableBinding> list = new ArrayList<VariableBinding>();
        String sysUpTime = "";
        String oid = "";
        Vector<? extends VariableBinding> bindings = event.getPDU().getVariableBindings();
        int i = 0;
        while (i < bindings.size()) {
            VariableBinding vb = bindings.get(i);
            String variableName = vb.getOid().toString();
            if (SNMP_SYSUPTIME2.equals(variableName) || SNMP_SYSUPTIME.equals(variableName)) {
                sysUpTime = vb.getVariable().toString();
            } else if (TRAPOID.equals(variableName)) {
                oid = vb.getVariable().toString();
            } else {
                list.add(vb);
            }
            ++i;
        }
        opts.put("#", "" + list.size());
        StringBuilder sb = new StringBuilder();
        sb.append(SNMP_SYSUPTIME).append("=").append(sysUpTime).append("\n");
        sb.append(TRAPOID).append("=").append(oid).append("\n");
        opts.put(SYSUPTIME_VARNAME, sysUpTime);
        opts.put(TRAPOID, oid);
        int i2 = 0;
        while (i2 < list.size()) {
            VariableBinding vb = (VariableBinding)list.get(i2);
            String name = vb.getOid().toString();
            String value = vb.getVariable().toString();
            opts.put(name, value);
            opts.put("" + (i2 + 1), value);
            sb.append(name);
            sb.append("=" + value).append("\n");
            ++i2;
        }
        String generic = GENERIC_TRAPS.get(oid);
        if (generic != null) {
            G = generic;
            opts.put("G", G);
            S = "0";
            opts.put("S", S);
            String enterprise = opts.get(SNMP_TRAP_ENTERPRISE_ID);
            if (enterprise != null) {
                E = enterprise;
                opts.put("e", E);
                StringBuilder sbb = new StringBuilder();
                sbb.append(E).append(':').append(G).append('.').append(S);
                oid = sbb.toString();
            } else {
                E = ".1.3.6.1.6.3.1.1.5." + oid.charAt(oid.length() - 1);
                opts.put("e", E);
            }
        } else {
            G = "6";
            opts.put("G", G);
            int lastDot = oid.lastIndexOf(46);
            S = oid.substring(lastDot + 1);
            opts.put("S", S);
            if (oid.charAt(lastDot - 1) == '0') {
                E = oid.substring(0, lastDot - 2);
                opts.put("e", E);
            } else {
                E = oid.substring(0, lastDot);
                opts.put("e", E);
            }
        }
        String hostnameIP = event.getPeerAddress().toString();
        hostnameIP = hostnameIP.startsWith("/") ? hostnameIP.substring(1) : hostnameIP.substring(0, hostnameIP.indexOf(47));
        opts.put("o", oid);
        opts.put("A", hostnameIP);
        StringBuilder sbOBJECT = new StringBuilder();
        sbOBJECT.append(E).append(':').append(G).append('.').append(S);
        String OBJECT = sbOBJECT.toString();
        if (sb.length() == 0) {
            sb.append(oid);
        }
        this.m_msgSubmitter.sendMessage(hostnameIP, APPL_SNMPTRAPD, GROUP_SNMP, oid, sb.toString(), severiry, opts);
    }

    @Override
    public void authenticationFailure(AuthenticationFailureEvent event) {
        String error = "Unknown Authentication failure";
        switch (event.getError()) {
            case -1402: {
                error = "Unsupported security model";
                break;
            }
            case 1408: {
                error = "Authentication failure";
                break;
            }
            case 1403: {
                error = "Unsupported security level";
                break;
            }
            case 1404: {
                error = "Unknown security name";
                break;
            }
            case 1407: {
                error = "Authentication error";
                break;
            }
            case 1411: {
                error = "Authentication not in time window";
                break;
            }
            case 1412: {
                error = "Unsupported Authentication protocol";
                break;
            }
            case 1410: {
                error = "Unknown engine ID";
                return;
            }
            case -1412: {
                error = "Wrong user name";
                break;
            }
            case 1603: {
                error = "TSM Inadequate security level";
                break;
            }
            case -1414: {
                error = "USM error";
            }
        }
        try {
            String ipAddr = event.getAddress().toString();
            int p1 = ipAddr.indexOf(47);
            if (p1 != -1) {
                ipAddr = ipAddr.substring(0, p1);
            }
            String key = ipAddr;
            HashMap<String, String> vars = new HashMap<String, String>();
            if (event.getErrorDetails() != null) {
                String secName;
                String engineId = event.getErrorDetails().getEngineId();
                if (engineId != null && engineId.length() > 0) {
                    error = String.valueOf(error) + " engineID: " + engineId;
                    key = String.valueOf(key) + "_" + engineId.replace(":", "");
                    vars.put(ENGINE_ID, engineId);
                }
                if ((secName = event.getErrorDetails().getSecurityName()) != null && secName.length() > 0) {
                    error = String.valueOf(error) + " securityName: " + secName;
                    key = String.valueOf(key) + "_" + secName;
                    vars.put("securityName", secName);
                }
                key = String.valueOf(key) + "_" + event.getError();
                vars.put("error", "" + event.getError());
                vars.put("addr", "" + event.getAddress());
            }
            if (key.length() > 0) {
                System.err.println(key);
                Long lastError = this.m_unknownSecurityNameErrors.get(key);
                if (lastError == null || System.currentTimeMillis() - lastError > 600000L) {
                    this.m_msgSubmitter.sendMessage(ipAddr, APPL_SNMPTRAPD, GROUP_SNMP, "USM Error", error, "warning", vars);
                    this.m_unknownSecurityNameErrors.put(key, System.currentTimeMillis());
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processPdu(CommandResponderEvent event) {
        long pt = System.nanoTime();
        switch (event.getMessageProcessingModel()) {
            case 0: {
                this.processTrapV1(event);
                break;
            }
            case 1: 
            case 2: {
                this.processTrapV2(event);
                break;
            }
            case 3: {
                this.processTrapV3(event);
                break;
            }
            default: {
                System.out.println("Unknown trap version");
            }
        }
        pt = System.nanoTime() - pt;
        if (this.startTimeNs == -1L) {
            this.startTimeNs = System.nanoTime();
        }
        this.processedTraps.incrementAndGet();
    }

    public long getProcessesTrapsCount() {
        return this.processedTraps.get();
    }

    public Snmp getSsmp() {
        return this.m_trapSession;
    }

    public String getLocalEngineID() {
        OctetString id = new OctetString(this.m_localEngineID);
        return id.toHexString().replace(":", "");
    }

    public void printMap(Map<String, String> map) {
        for (String key : map.keySet()) {
            System.out.println(String.valueOf('\"') + key + '\"' + ":" + '\"' + map.get(key) + '\"');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snmpTrapSessionError(Snmp session, int error, Object ref) {
        this.m_msgSubmitter.sendMessage(null, APPL_SNMPTRAPD, GROUP_SNMP, null, "" + ref, "warning", null);
        if (error == -1) {
            Snmp snmp = session;
            synchronized (snmp) {
                try {
                    session.notify();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public void snmpProcessBadPacket(DatagramPacket dp) {
        this.print("unsupported UDP packet detected. ");
    }

    public void setInterval(long ms) {
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
    }

    public String runMonitor() {
        if (this.m_trapSession == null || this.m_listenerThread == null || !this.m_listenerThread.isAlive()) {
            this.m_listenerThread = new Thread(this);
            this.m_listenerThread.start();
        }
        return String.valueOf(this.m_monitorName) + "=0";
    }

    public void setMessageSubmitter(IMessage submitter) {
        if (submitter != null) {
            this.m_msgSubmitter = submitter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            Snmp snmp = this.m_trapSession;
            synchronized (snmp) {
                try {
                    this.m_trapSession.notify();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.m_trapSession.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.m_running.set(false);
        m_instances.remove(this.m_monitorName);
    }

    public void print(String msg) {
        if (this.m_printOutput) {
            m_logger.print(1, msg);
        }
    }

    public void print(String msg, Throwable e) {
        if (this.m_printOutput) {
            m_logger.print(1, msg, e);
            m_logger.getPrintStream(false).flush();
        }
    }

    public boolean loadUser(String line, USM usm) throws InitException {
        boolean res = false;
        Matcher m = this.userPattern.matcher(line);
        if (m.matches()) {
            String engineID = m.group(1);
            String username = m.group(2);
            String authType = m.group(3);
            String authPass = m.group(4);
            String privType = m.group(5);
            String privPass = m.group(6);
            res = this.loadUser(line, usm, engineID, username, authType, authPass, privType, privPass);
            res = true;
        } else {
            line.startsWith("#");
        }
        return res;
    }

    private boolean loadUser(String line, USM usm, String engineID, String username, String authType, String authPass, String privType, String privPass) throws InitException {
        boolean res = false;
        if (engineID == null) {
            throw new InitException("Error: engineID is not defined. Line: " + line);
        }
        if (username == null) {
            throw new InitException("Error: username is not defined. Line: " + line);
        }
        OctetString engineID_O = null;
        Matcher m1 = this.snmp4jEnginePattern1.matcher(engineID);
        Matcher m2 = this.snmp4jEnginePattern2.matcher(engineID);
        if (m1.matches()) {
            engineID_O = engineID.startsWith("0x") ? OctetString.fromHexStringPairs(engineID.substring(2)) : OctetString.fromHexStringPairs(engineID);
        } else if (m2.matches()) {
            engineID_O = OctetString.fromHexString(engineID);
        } else {
            throw new InitException("Error parsing USM line: " + line + "\n" + "Unsupported engineID format!");
        }
        OID authProtocol = SNMPTrapd.getAuthProtocol(authType);
        OID privProtocol = SNMPTrapd.getPrivProtocol(privType);
        if (authProtocol == null) {
            authPass = null;
        }
        if (privProtocol == null) {
            privPass = null;
        }
        if (privProtocol != null && authProtocol == null) {
            throw new InitException("Error: Auth=none/Priv=" + privType + " is not supported! Line: " + line);
        }
        if (privProtocol != null && (privPass == null || privPass.length() == 0)) {
            throw new InitException("Error: Priv=" + privType + " with no password is not supported! Line: " + line);
        }
        if (authProtocol != null && (authPass == null || authPass.length() == 0)) {
            throw new InitException("Error: Auth=" + authProtocol + " with no password is not supported! Line: " + line);
        }
        OctetString userName = SnmpConfigurator.createOctetString(username, null);
        UsmUser user = null;
        try {
            user = new UsmUser(userName, authProtocol, SnmpConfigurator.createOctetString(authPass, null), privProtocol, SnmpConfigurator.createOctetString(privPass, null));
            usm.addUser(userName, engineID_O, user);
            res = true;
        }
        catch (Throwable e) {
            throw new InitException("Error parsing USM line: " + line + "\n" + e.getClass().getCanonicalName() + " " + e.getMessage());
        }
        return res;
    }

    public static OID getPrivProtocol(String privType) {
        OID privProtocol = null;
        if ("DES".equals(privType)) {
            privProtocol = PrivDES.ID;
        } else if ("3DES".equals(privType)) {
            privProtocol = Priv3DES.ID;
        } else if ("AES".equals(privType) || "AES128".equals(privType)) {
            privProtocol = PrivAES128.ID;
        } else if ("AES192".equals(privType)) {
            privProtocol = PrivAES192.ID;
        } else if ("AES256".equals(privType)) {
            privProtocol = PrivAES256.ID;
        } else if ("AES192p".equals(privType)) {
            privProtocol = PrivAES192With3DESKeyExtension.ID;
        } else if ("AES192p".equals(privType)) {
            privProtocol = PrivAES256With3DESKeyExtension.ID;
        } else if ("none".equals(privType)) {
            privProtocol = null;
        }
        return privProtocol;
    }

    public static OID getAuthProtocol(String authType) {
        OID authProtocol = null;
        if ("MD5".equals(authType)) {
            authProtocol = AuthMD5.ID;
        } else if ("SHA".equals(authType)) {
            authProtocol = AuthSHA.ID;
        } else if ("HMAC192SHA256".equals(authType)) {
            authProtocol = AuthHMAC192SHA256.ID;
        } else if ("HMAC384SHA512".equals(authType)) {
            authProtocol = AuthHMAC384SHA512.ID;
        } else if ("none".equals(authType)) {
            authProtocol = null;
        }
        return authProtocol;
    }

    public void loadUSMFile(File file) {
        this.m_usm.addUser(new OctetString(this.m_localEngineID), new UsmUser(new OctetString("boom"), AuthMD5.ID, new OctetString("boomsnmp"), PrivDES.ID, new OctetString("boomsnmp")));
        this.m_usm.addUser(new OctetString(this.m_localEngineID), new UsmUser(new OctetString("boomaes"), AuthSHA.ID, new OctetString("boomsnmp"), PrivAES128.ID, new OctetString("boomsnmp")));
        this.m_usm.addUser(new OctetString(this.m_localEngineID), new UsmUser(new OctetString("boomnopriv"), AuthSHA.ID, new OctetString("boomsnmp"), null, null));
        if (file.exists()) {
            boolean resave = false;
            FileReader fr = null;
            JsonArray array = null;
            try {
                fr = new FileReader(file);
                array = Json.parse(fr).asArray();
                for (JsonValue val : array.values()) {
                    JsonObject obj = val.asObject();
                    String agentID = obj.getString(AGENT_ID, "");
                    String engineID = obj.getString(ENGINE_ID, null);
                    String userName = obj.getString(USER, null);
                    String authType = obj.getString(AUTH_TYPE, null);
                    String authPass = obj.getString(AUTH_PASS, null);
                    String authEnPass = obj.getString(AUTH_EN_PASS, null);
                    String privType = obj.getString(PRIV_TYPE, null);
                    String privEnPass = obj.getString(PRIV_EN_PASS, null);
                    String privPass = obj.getString(PRIV_PASS, null);
                    String comment = obj.getString(COMMENT, null);
                    if (authPass != null) {
                        authEnPass = Cryptor.encrypt(authPass);
                        obj.remove(AUTH_PASS);
                        obj.set(AUTH_EN_PASS, authEnPass);
                        resave = true;
                    }
                    if (privPass != null) {
                        privEnPass = Cryptor.encrypt(privPass);
                        obj.remove(PRIV_PASS);
                        obj.set(PRIV_EN_PASS, privEnPass);
                        resave = true;
                    }
                    try {
                        this.loadUser(obj.toString(), this.m_usm, engineID, userName, authType, Cryptor.decrypt(authEnPass), privType, Cryptor.decrypt(privEnPass));
                    }
                    catch (InitException e) {
                        this.print(e.getMessage());
                    }
                }
            }
            catch (Throwable e) {
                try {
                    fr.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (resave && array != null) {
                OutputStreamWriter writer = null;
                try {
                    try {
                        writer = new FileWriter(file);
                        array.writeTo(writer, WriterConfig.PRETTY_PRINT);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
                finally {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    public static String getType(OID type) {
        if (type == null) {
            return "none";
        }
        if (AuthMD5.ID.equals(type)) {
            return "MD5";
        }
        if (AuthSHA.ID.equals(type)) {
            return "SHA";
        }
        if (Priv3DES.ID.equals(type)) {
            return "3DES";
        }
        if (PrivDES.ID.equals(type)) {
            return "DES";
        }
        if (PrivAES128.ID.equals(type)) {
            return "AES";
        }
        if (PrivAES192.ID.equals(type)) {
            return "AES192";
        }
        if (PrivAES256.ID.equals(type)) {
            return "AES256";
        }
        if (PrivAES192With3DESKeyExtension.ID.equals(type)) {
            return "AES192p";
        }
        if (PrivAES256With3DESKeyExtension.ID.equals(type)) {
            return "AES256p";
        }
        if (AuthHMAC192SHA256.ID.equals(type)) {
            return "HMAC192SHA256";
        }
        if (AuthHMAC384SHA512.ID.equals(type)) {
            return "HMAC384SHA512";
        }
        return "none";
    }

    public static class InitException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public InitException(String message, Throwable cause) {
            super(message, cause);
        }

        public InitException(String message) {
            super(message);
        }
    }
}

