/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.snmp;

import com.blixx.boom.snmp.SNMPTrapd;
import com.blixx.ext.IAction;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.UserTarget;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.security.Priv3DES;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TreeEvent;
import org.snmp4j.util.TreeListener;
import org.snmp4j.util.TreeUtils;

public class SNMPWalkAction
implements IAction,
PDUFactory {
    StringBuffer m_result = new StringBuffer();
    int m_version = 0;
    String m_community = null;
    int m_retries = 1;
    int m_timeout = 10000;
    int m_port = 161;
    String m_host = "";
    OID m_startOid = new OID("1.3.6");
    OID m_stopAt = null;
    Target target;
    Snmp session = null;
    static OctetString localEngineID = new OctetString(MPv3.createLocalEngineID());
    static int engineBootCount = 0;
    OID authProtocol;
    OID privProtocol;
    OctetString privPassphrase;
    OctetString authPassphrase;
    OctetString community = new OctetString("public");
    OctetString authoritativeEngineID;
    OctetString contextEngineID;
    OctetString contextName = new OctetString();
    OctetString securityName = new OctetString();
    int maxSizeResponsePDU = 65535;
    PDUv1 v1TrapPDU = new PDUv1();
    boolean m_get = false;
    private static Snmp snmpSession;
    private static Snmp snmpSessionV3;

    @Override
    public PDU createPDU(Target target) {
        PDU request;
        if (target.getVersion() == 3) {
            request = new ScopedPDU();
            ScopedPDU scopedPDU = request;
            if (this.contextEngineID != null) {
                scopedPDU.setContextEngineID(this.contextEngineID);
            }
            if (this.contextName != null) {
                scopedPDU.setContextName(this.contextName);
            }
        } else {
            request = this.m_version == -92 ? this.v1TrapPDU : new PDU();
            request.setType(-95);
        }
        return request;
    }

    @Override
    public PDU createPDU(MessageProcessingModel messageProcessingModel) {
        PDU request = messageProcessingModel.getID() == 3 ? new ScopedPDU() : new PDU();
        return request;
    }

    void parseOptions(String[] args) throws IllegalArgumentException {
        int lastArg = 0;
        int x = 0;
        while (x < args.length) {
            if (args[x].startsWith("-")) {
                if (args[x].equals("-c")) {
                    this.m_community = args[++x];
                    this.community = new OctetString(this.m_community);
                } else if (args[x].equals("-v")) {
                    if (args[++x].equals("1")) {
                        this.m_version = 0;
                    } else if (args[x].equals("2") || args[x].equals("2c")) {
                        this.m_version = 1;
                    } else if (args[x].equals("3")) {
                        this.m_version = 3;
                    } else if (args[x].contains("2")) {
                        this.m_version = 1;
                    } else if (args[x].contains("3")) {
                        this.m_version = 3;
                    }
                } else if (args[x].equals("-r")) {
                    try {
                        this.m_retries = Integer.parseInt(args[++x]);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Malformed retry number");
                    }
                } else if (args[x].equals("-t")) {
                    try {
                        float f = Float.parseFloat(args[++x]);
                        this.m_timeout = (int)(f * 1000.0f);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Malformed timeout period");
                    }
                } else if (args[x].equals("-p")) {
                    try {
                        this.m_port = Integer.parseInt(args[++x]);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Malformed port number");
                    }
                } else if (args[x].equals("-Xu")) {
                    this.securityName = SNMPWalkAction.createOctetString(args[++x]);
                } else if (args[x].equals("-Xa")) {
                    String s = args[++x];
                    this.authProtocol = SNMPTrapd.getAuthProtocol(s);
                } else if (args[x].equals("-Xs")) {
                    this.authPassphrase = SNMPWalkAction.createOctetString(args[++x]);
                } else if (args[x].equals("-Xp")) {
                    this.privPassphrase = SNMPWalkAction.createOctetString(args[++x]);
                } else if (args[x].equals("-Xt")) {
                    String s = args[++x];
                    this.privProtocol = SNMPTrapd.getPrivProtocol(s);
                } else if (args[x].equals("-o")) {
                    this.m_startOid = new OID(args[++x]);
                } else if (args[x].equals("-get")) {
                    this.m_get = true;
                    if (args[x + 1] != null && !args[x + 1].startsWith("-")) {
                        this.m_startOid = new OID(args[++x]);
                    }
                } else if (args[x].equals("-notTable")) {
                    this.m_get = true;
                } else if (args[x].equals("-h")) {
                    this.m_host = args[++x];
                } else {
                    if (args[x].equals("--")) {
                        lastArg = x + 1;
                        break;
                    }
                    throw new IllegalArgumentException("Unknown Option " + args[x]);
                }
                lastArg = x + 1;
            }
            ++x;
        }
        if (args.length - lastArg == 1) {
            this.m_host = args[lastArg++];
        } else if (args.length - lastArg == 2) {
            this.m_host = args[lastArg++];
            this.m_startOid = new OID(args[lastArg++]);
        } else if (this.m_host.length() == 0) {
            throw new IllegalArgumentException("Invalid number of arguments");
        }
    }

    private static OctetString createOctetString(String s) {
        OctetString octetString = s.startsWith("0x") ? OctetString.fromHexString(s.substring(2), ':') : new OctetString(s);
        return octetString;
    }

    public String run(String[] parameters, int timeout) {
        this.m_result = new StringBuffer();
        InetAddress remote = null;
        try {
            this.parseOptions(parameters);
            remote = InetAddress.getByName(this.m_host);
        }
        catch (IllegalArgumentException e) {
            this.m_result.append("\n").append(e.getMessage());
            return this.m_result.toString();
        }
        catch (UnknownHostException e) {
            this.m_result.append("\n").append("UnknownHostException: " + e.getMessage());
            return this.m_result.toString();
        }
        Snmp snmp = null;
        try {
            if (this.m_version != 3) {
                snmp = SNMPWalkAction.getSnmpSession();
            } else {
                snmp = SNMPWalkAction.getSnmpSessionV3();
                this.addUsmUser(snmp);
            }
            this.target = this.createTarget();
            this.target.setVersion(this.m_version);
            UdpAddress ua = new UdpAddress(String.valueOf(this.m_host) + "/" + this.m_port);
            this.target.setAddress(ua);
            this.target.setRetries(this.m_retries);
            this.target.setTimeout(this.m_timeout);
            this.target.setMaxSizeRequestPDU(this.maxSizeResponsePDU);
            if (this.m_get) {
                Vector<? extends VariableBinding> vect;
                PDU request = this.createPDU(this.target);
                request.setType(-96);
                request.add(new VariableBinding(this.m_startOid));
                ResponseEvent response = snmp.send(request, this.target, null);
                if (response.getError() != null) {
                    throw response.getError();
                }
                PDU resp = response.getResponse();
                if (resp.getErrorStatus() != 0) {
                    String error = resp.getErrorStatusText();
                    if (error != null) {
                        error = "Unknown error code:" + resp.getErrorStatus();
                    }
                    this.m_result.append(error);
                }
                if ((vect = resp.getVariableBindings()) != null) {
                    for (VariableBinding variableBinding : vect) {
                        this.m_result.append(variableBinding.toString()).append("\n");
                    }
                }
            } else {
                PDU request = this.createPDU(this.target);
                request.setMaxRepetitions(0);
                request.setNonRepeaters(0);
                request.add(new VariableBinding(this.m_startOid));
                ArrayList snapshot = new ArrayList();
                this.walk(snmp, request, this.target, snapshot);
            }
        }
        catch (Throwable e) {
            this.m_result.append("Error: ").append(e.getMessage());
        }
        return this.m_result.toString();
    }

    private static synchronized Snmp getSnmpSession() throws IOException {
        if (snmpSession == null) {
            DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
            snmpSession = new Snmp(transport);
            ((MPv3)snmpSession.getMessageProcessingModel(3)).setLocalEngineID(localEngineID.getValue());
            snmpSession.listen();
        }
        return snmpSession;
    }

    private static synchronized Snmp getSnmpSessionV3() throws IOException {
        if (snmpSessionV3 == null) {
            DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
            snmpSessionV3 = new Snmp(transport);
            ((MPv3)snmpSessionV3.getMessageProcessingModel(3)).setLocalEngineID(localEngineID.getValue());
            SecurityProtocols.getInstance().addDefaultProtocols();
            SecurityProtocols.getInstance().addPrivacyProtocol(new Priv3DES());
            USM usm = new USM(SecurityProtocols.getInstance(), localEngineID, engineBootCount);
            SecurityModels.getInstance().addSecurityModel(usm);
            snmpSessionV3.listen();
        }
        return snmpSessionV3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PDU walk(Snmp snmp, PDU request, Target target, final List snapshot) throws IOException {
        TreeListener treeListener;
        OID rootOID = request.get(0).getOid();
        PDU response = null;
        final WalkCounts counts = new WalkCounts();
        final long startTime = System.currentTimeMillis();
        TreeUtils treeUtils = new TreeUtils(snmp, this);
        treeUtils.setIgnoreLexicographicOrder(true);
        TreeListener treeListener2 = treeListener = new TreeListener(){
            private boolean finished;

            @Override
            public boolean next(TreeEvent e) {
                ++counts.requests;
                if (e.getVariableBindings() != null) {
                    VariableBinding[] vbs = e.getVariableBindings();
                    counts.objects += vbs.length;
                    int i = 0;
                    while (i < vbs.length) {
                        if (snapshot != null) {
                            snapshot.add(vbs[i]);
                        }
                        SNMPWalkAction.this.m_result.append(vbs[i].toString()).append("\n");
                        ++i;
                    }
                }
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finished(TreeEvent e) {
                if (e.getVariableBindings() != null && e.getVariableBindings().length > 0) {
                    this.next(e);
                }
                SNMPWalkAction.this.m_result.append("\n");
                SNMPWalkAction.this.m_result.append("Total requests sent:    " + counts.requests).append("\n");
                SNMPWalkAction.this.m_result.append("Total objects received: " + counts.objects).append("\n");
                SNMPWalkAction.this.m_result.append("Total walk time:        " + (System.currentTimeMillis() - startTime) + " milliseconds").append("\n");
                if (e.isError()) {
                    SNMPWalkAction.this.m_result.append("\n");
                    SNMPWalkAction.this.m_result.append("The following error occurred during walk:").append("\n");
                    SNMPWalkAction.this.m_result.append(e.getErrorMessage()).append("\n");
                }
                this.finished = true;
                1 var2_2 = this;
                synchronized (var2_2) {
                    this.notify();
                }
            }

            @Override
            public boolean isFinished() {
                return this.finished;
            }
        };
        synchronized (treeListener2) {
            treeUtils.getSubtree(target, rootOID, null, treeListener);
            try {
                treeListener.wait();
            }
            catch (InterruptedException ex) {
                System.err.println("Tree retrieval interrupted: " + ex.getMessage());
                Thread.currentThread().interrupt();
            }
        }
        return response;
    }

    private void addUsmUser(Snmp snmp) {
        snmp.getUSM().addUser(this.securityName, new UsmUser(this.securityName, this.authProtocol, this.authPassphrase, this.privProtocol, this.privPassphrase));
    }

    private Target createTarget() {
        if (this.m_version == 3) {
            UserTarget target = new UserTarget();
            if (this.authPassphrase != null) {
                if (this.privPassphrase != null) {
                    target.setSecurityLevel(3);
                } else {
                    target.setSecurityLevel(2);
                }
            } else {
                target.setSecurityLevel(1);
            }
            target.setSecurityName(this.securityName);
            return target;
        }
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(this.community);
        return target;
    }

    public static void main(String[] args) {
        SNMPWalkAction walker = new SNMPWalkAction();
        System.out.println(walker.run(args, 300));
    }

    class WalkCounts {
        public int requests;
        public int objects;

        WalkCounts() {
        }
    }
}

