/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.snmp;

import com.blixx.boom.snmp.SNMPTrapd;
import com.blixx.boom.snmp.SyntaxException;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitor;
import com.blixx.ext.IMonitorExt;
import com.blixx.ext.IMonitorSubmitter;
import com.blixx.ext.test.NullMonSubmitter;
import com.blixx.ext.test.NullMsgSubmitter;
import com.wl.snmp.exp4j.Expression;
import com.wl.snmp.exp4j.OpmExpressionBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.UserTarget;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.security.Priv3DES;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TreeEvent;
import org.snmp4j.util.TreeListener;
import org.snmp4j.util.TreeUtils;

public class SNMPWalkMonitor
implements IMonitorExt,
PDUFactory {
    private static final String GROUP_SNMP = "SNMPGetWalk";
    public static final String VAR = "$";
    public static Pattern m_digitsPattern = null;
    public static Pattern m_operand = null;
    public String m_monitor = "";
    public HashMap<String, String> m_orig = new HashMap();
    public HashMap<String, HashMap<String, String>> m_rows = new HashMap();
    public ArrayList<String> m_calcLines = new ArrayList();
    public IMonitorSubmitter m_submitter = null;
    public IMessage m_msgSubmitter = null;
    private HashMap<String, ArrayList<Object>> m_previousValues = new HashMap();
    public static String FUNC_COUNT = "COUNT";
    public static String FUNC_SUM = "SUM";
    public static String FUNC_MIN = "MIN";
    public static String FUNC_MAX = "MAX";
    public static String FUNC_AVG = "AVG";
    public static final int PLUS = 0;
    public static final int MINUS = 1;
    public static final int DIV = 2;
    public static final int MUL = 3;
    public static final int DIV1 = 4;
    int m_version = 0;
    String m_community = null;
    int m_retries = 1;
    int m_timeout = 10000;
    int m_port = 161;
    String m_host = "127.0.0.1";
    OID m_startOid = new OID("1.3.6");
    OID m_stopAt = null;
    Target target;
    Snmp session = null;
    static OctetString localEngineID = new OctetString(MPv3.createLocalEngineID());
    static int engineBootCount = 0;
    OID authProtocol;
    OID privProtocol;
    OctetString privPassphrase;
    OctetString authPassphrase;
    OctetString community = new OctetString("public");
    OctetString authoritativeEngineID;
    OctetString contextEngineID;
    OctetString contextName = new OctetString();
    OctetString securityName = new OctetString();
    int maxSizeResponsePDU = 65535;
    boolean m_get = false;
    private static Snmp snmpSession;
    private static Snmp snmpSessionV3;

    static {
        m_digitsPattern = Pattern.compile("\\s*[-]*\\d+.*");
        m_operand = Pattern.compile("\\s*[\\*+-/]+\\s*");
    }

    public static IMonitor getInstance(String monitorName, String[] parameters) {
        SNMPWalkMonitor sw = new SNMPWalkMonitor();
        sw.m_monitor = monitorName;
        sw.parseOptions(parameters);
        sw.target = sw.createTarget();
        sw.target.setVersion(sw.m_version);
        UdpAddress ua = new UdpAddress(String.valueOf(sw.m_host) + "/" + sw.m_port);
        sw.target.setAddress(ua);
        sw.target.setRetries(sw.m_retries);
        sw.target.setTimeout(sw.m_timeout);
        sw.target.setMaxSizeRequestPDU(sw.maxSizeResponsePDU);
        return sw;
    }

    @Override
    public PDU createPDU(Target target) {
        PDU request;
        if (target.getVersion() == 3) {
            request = new ScopedPDU();
            ScopedPDU scopedPDU = request;
            if (this.contextEngineID != null) {
                scopedPDU.setContextEngineID(this.contextEngineID);
            }
            if (this.contextName != null) {
                scopedPDU.setContextName(this.contextName);
            }
        } else {
            request = this.m_version == -92 ? new PDUv1() : new PDU();
            request.setType(-95);
        }
        return request;
    }

    @Override
    public PDU createPDU(MessageProcessingModel messageProcessingModel) {
        PDU request = messageProcessingModel.getID() == 3 ? new ScopedPDU() : new PDU();
        return request;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void parseOptions(String[] args) throws IllegalArgumentException {
        int i = 0;
        while (i < args.length) {
            String[] name_val = args[i].split("\\s+", 2);
            if (name_val[0].equals("-c") && name_val.length == 2) {
                this.m_community = name_val[1];
                this.community = new OctetString(this.m_community);
            } else if (name_val[0].equals("-v") && name_val.length == 2) {
                if (name_val[1].equals("1")) {
                    this.m_version = 0;
                } else if (name_val[1].equals("2") || name_val[1].equals("2c")) {
                    this.m_version = 1;
                } else {
                    if (!name_val[1].equals("3")) throw new RuntimeException("Invalid SNMP version specified: " + name_val[1]);
                    this.m_version = 3;
                }
            } else if (name_val[0].equals("-p") && name_val.length == 2) {
                try {
                    this.m_port = Integer.parseInt(name_val[1]);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Invalid SNMP port specified: " + name_val[1]);
                }
            } else if (name_val[0].equals("-r") && name_val.length == 2) {
                try {
                    this.m_retries = Integer.parseInt(name_val[1]);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Invalid SNMP retry specified: " + name_val[1]);
                }
            } else if (name_val[0].equals("-t") && name_val.length == 2) {
                try {
                    float f = Float.parseFloat(name_val[1]);
                    this.m_timeout = (int)(f * 1000.0f);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Invalid timeout specified: " + name_val[1]);
                }
            } else if (name_val[0].equals("-h") && name_val.length == 2) {
                this.m_host = name_val[1];
            } else if (name_val[0].equals("-o") && name_val.length == 2) {
                this.m_startOid = new OID(name_val[1]);
            } else if (name_val[0].equals("-Xu") && name_val.length == 2) {
                this.securityName = SNMPWalkMonitor.createOctetString(name_val[1]);
            } else if (name_val[0].equals("-Xa") && name_val.length == 2) {
                String s = name_val[1];
                this.authProtocol = SNMPTrapd.getAuthProtocol(s);
            } else if (name_val[0].equals("-Xs") && name_val.length == 2) {
                this.authPassphrase = SNMPWalkMonitor.createOctetString(name_val[1]);
            } else if (name_val[0].equals("-Xp") && name_val.length == 2) {
                this.privPassphrase = SNMPWalkMonitor.createOctetString(name_val[1]);
            } else if (name_val[0].equals("-Xt") && name_val.length == 2) {
                String s = name_val[1];
                this.privProtocol = SNMPTrapd.getPrivProtocol(s);
            } else if (name_val[0].equals("-get")) {
                this.m_get = true;
                if (name_val.length > 1) {
                    this.m_startOid = new OID(name_val[1]);
                }
            } else if (name_val[0].equals("-notTable")) {
                this.m_get = true;
            } else {
                String calcLine = args[i];
                if (calcLine != null && calcLine.trim().length() > 0) {
                    this.m_calcLines.add(args[i]);
                }
            }
            ++i;
        }
    }

    private static OctetString createOctetString(String s) {
        OctetString octetString = s.startsWith("0x") ? OctetString.fromHexString(s.substring(2), ':') : new OctetString(s);
        return octetString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PDU walk(Snmp snmp, PDU request, Target target) throws IOException {
        TreeListener treeListener;
        OID rootOID = request.get(0).getOid();
        PDU response = null;
        final WalkCounts counts = new WalkCounts();
        TreeUtils treeUtils = new TreeUtils(snmp, this);
        treeUtils.setIgnoreLexicographicOrder(true);
        TreeListener treeListener2 = treeListener = new TreeListener(){
            private boolean finished;

            @Override
            public boolean next(TreeEvent e) {
                if (e.getUserObject() != this) {
                    return true;
                }
                ++counts.requests;
                if (e.getVariableBindings() != null) {
                    VariableBinding[] vbs = e.getVariableBindings();
                    counts.objects += vbs.length;
                    int i = 0;
                    while (i < vbs.length) {
                        String fullOID = vbs[i].getOid().toString();
                        SNMPWalkMonitor.this.m_orig.put(fullOID, vbs[i].getVariable().toString());
                        String m1oid = fullOID.replace(SNMPWalkMonitor.this.m_startOid.toString(), SNMPWalkMonitor.this.m_monitor);
                        String[] arr = m1oid.split("\\.");
                        if (arr.length > 1) {
                            HashMap<String, String> row;
                            String fieldNum = arr[1];
                            String instance = "0";
                            if (arr.length > 2) {
                                instance = fullOID.replace(String.valueOf(SNMPWalkMonitor.this.m_startOid.toString()) + "." + fieldNum + ".", "");
                            }
                            if (SNMPWalkMonitor.this.m_calcLines.size() == 0 && !instance.equals("0")) {
                                instance = fieldNum = String.valueOf(fieldNum) + "." + instance;
                            }
                            if ((row = SNMPWalkMonitor.this.m_rows.get(instance)) == null) {
                                row = new HashMap();
                            }
                            row.put(SNMPWalkMonitor.VAR + fieldNum, vbs[i].getVariable().toString());
                            SNMPWalkMonitor.this.m_rows.put(instance, row);
                        }
                        ++i;
                    }
                }
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finished(TreeEvent e) {
                if (e.getVariableBindings() != null && e.getVariableBindings().length > 0) {
                    this.next(e);
                }
                e.isError();
                this.finished = true;
                1 var2_2 = this;
                synchronized (var2_2) {
                    this.notify();
                }
            }

            @Override
            public boolean isFinished() {
                return this.finished;
            }
        };
        synchronized (treeListener2) {
            treeUtils.getSubtree(target, rootOID, treeListener, treeListener);
            try {
                treeListener.wait();
            }
            catch (InterruptedException ex) {
                System.err.println("Tree retrieval interrupted: " + ex.getMessage());
                Thread.currentThread().interrupt();
            }
        }
        return response;
    }

    private void addUsmUser(Snmp snmp) {
        UsmUser user = new UsmUser(this.securityName, this.authProtocol, this.authPassphrase, this.privProtocol, this.privPassphrase);
        snmp.getUSM().addUser(this.securityName, user);
    }

    private Target createTarget() {
        if (this.m_version == 3) {
            UserTarget target = new UserTarget();
            if (this.authPassphrase != null) {
                if (this.privPassphrase != null) {
                    target.setSecurityLevel(3);
                } else {
                    target.setSecurityLevel(2);
                }
            } else {
                target.setSecurityLevel(1);
            }
            target.setSecurityName(this.securityName);
            return target;
        }
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(this.community);
        return target;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public String runMonitor() {
        block24: {
            this.m_rows = new HashMap<K, V>();
            this.m_orig = new HashMap<K, V>();
            snmp = null;
            try {
                if (this.m_version != 3) {
                    snmp = SNMPWalkMonitor.getSnmpSession();
                } else {
                    snmp = SNMPWalkMonitor.getSnmpSessionV3();
                    this.addUsmUser(snmp);
                }
                if (!this.m_get) break block24;
                request = this.createPDU(this.target);
                request.setType(-96);
                request.add(new VariableBinding(this.m_startOid));
                response = snmp.send(request, this.target, null);
                if (response.getError() != null) {
                    throw response.getError();
                }
                resp = response.getResponse();
                if (resp.getErrorStatus() != 0) {
                    error = resp.getErrorStatusText();
                    if (error != null) {
                        error = "Unknown error code:" + resp.getErrorStatus();
                    }
                    throw new Exception(error);
                }
                vect = resp.getVariableBindings();
                for (VariableBinding vvb : vect) {
                    oid = vvb.getOid();
                    object = oid.toString();
                    v = vvb.getVariable();
                    vars = new HashMap<String, String>();
                    vars.put("host", this.m_host);
                    try {
                        if (v.isException()) {
                            throw new RuntimeException("Error getting SNMP data: " + v.toString() + " on OID: " + object);
                        }
                        value = v.toLong();
                        this.m_submitter.submitMonitorValue(this.m_monitor, value, object, null);
                    }
                    catch (Throwable e) {
                        this.m_msgSubmitter.sendMessage(this.m_host, "SNMPGetWalk", "SNMPGetWalk", object, e.getMessage(), "warning", null);
                    }
                }
                return null;
            }
            catch (Throwable e) {
                runtimeException = new RuntimeException(e.getMessage());
                runtimeException.setStackTrace(e.getStackTrace());
                throw runtimeException;
            }
        }
        request = this.createPDU(this.target);
        request.setMaxRepetitions(0);
        request.setNonRepeaters(0);
        request.add(new VariableBinding(this.m_startOid));
        this.walk(snmp, request, this.target);
        try {
            it = this.m_rows.keySet().iterator();
            if (it.hasNext()) ** GOTO lbl94
            runtimeException = new RuntimeException("Empty result. Potential communication error.");
            throw runtimeException;
lbl-1000:
            // 1 sources

            {
                instance = it.next();
                vars = this.m_rows.get(instance);
                if (!instance.equals("0") && !vars.containsKey("$" + instance)) {
                    vars.put("$OBJ", instance);
                }
                if (this.m_calcLines.size() > 0) {
                    this.calculateAndSend(vars);
                    continue;
                }
                vars.put("host", this.m_host);
                for (String next : vars.keySet()) {
                    if ("host".equals(next)) continue;
                    try {
                        res = Double.parseDouble(vars.get(next));
                        if (instance.equals("0")) {
                            nvars = new HashMap<String, String>();
                            nvars.put("host", this.m_host);
                            if (!next.startsWith("$")) continue;
                            try {
                                object = next.substring(1);
                                nvars.put("oid", this.m_startOid + "." + object);
                                this.m_submitter.submitMonitorValue(this.m_monitor, res, object, nvars);
                            }
                            catch (NumberFormatException var10_26) {}
                            continue;
                        }
                        varP = next.substring(1);
                        if (!varP.equals(instance)) {
                            varP = String.valueOf(varP) + "." + instance;
                        }
                        this.m_submitter.submitMonitorValue(this.m_monitor, res, varP, vars);
                    }
                    catch (Throwable var7_18) {
                        // empty catch block
                    }
                }
lbl94:
                // 3 sources

                ** while (it.hasNext())
            }
lbl95:
            // 1 sources

        }
        catch (Throwable e) {
            runtimeException = new RuntimeException(e.getMessage());
            runtimeException.setStackTrace(e.getStackTrace());
            throw runtimeException;
        }
        return null;
    }

    private static synchronized Snmp getSnmpSession() throws IOException {
        if (snmpSession == null) {
            DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
            snmpSession = new Snmp(transport);
            ((MPv3)snmpSession.getMessageProcessingModel(3)).setLocalEngineID(localEngineID.getValue());
            snmpSession.listen();
        }
        return snmpSession;
    }

    private static synchronized Snmp getSnmpSessionV3() throws IOException {
        if (snmpSessionV3 == null) {
            DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
            snmpSessionV3 = new Snmp(transport);
            ((MPv3)snmpSessionV3.getMessageProcessingModel(3)).setLocalEngineID(localEngineID.getValue());
            SecurityProtocols.getInstance().addDefaultProtocols();
            SecurityProtocols.getInstance().addPrivacyProtocol(new Priv3DES());
            USM usm = new USM(SecurityProtocols.getInstance(), localEngineID, engineBootCount);
            SecurityModels.getInstance().addSecurityModel(usm);
            snmpSessionV3.listen();
        }
        return snmpSessionV3;
    }

    private void calculateAndSend(HashMap<String, String> vars) {
        int i = 0;
        while (i < this.m_calcLines.size()) {
            try {
                String object;
                String function = this.m_calcLines.get(i);
                String[] arr = function.split("\\s+", 3);
                String objectOrig = object = arr[0];
                String func = arr[1];
                String calcLine = arr[2];
                try {
                    double res = this.calculateLine(vars, calcLine);
                    if (object.indexOf(VAR) != -1) {
                        for (String var : vars.keySet()) {
                            if (!var.startsWith(VAR)) continue;
                            object = object.replace(var, vars.get(var));
                        }
                    }
                    if (func.equalsIgnoreCase("DELTA")) {
                        ArrayList<Number> al = new ArrayList<Number>();
                        al.add(res);
                        al.add(System.currentTimeMillis());
                        if (this.m_previousValues.containsKey(object)) {
                            ArrayList<Object> stored = this.m_previousValues.get(object);
                            vars.put("lastValue", "" + stored.get(0));
                            vars.put("lastTime", "" + stored.get(1));
                            try {
                                Double pr = (Double)stored.get(0);
                                res -= pr.doubleValue();
                                if (res < 0.0) {
                                    res = -1.0;
                                }
                            }
                            catch (Throwable e) {
                                res = -1.0;
                            }
                        } else {
                            res = 0.0;
                        }
                        this.m_previousValues.put(object, al);
                    }
                    vars.put("host", this.m_host);
                    this.m_submitter.submitMonitorValue(this.m_monitor, res, object, vars);
                    vars.put(objectOrig, "" + res);
                }
                catch (ArithmeticException arithmeticException) {}
            }
            catch (Throwable e) {
                this.m_msgSubmitter.sendMessage(this.m_host, GROUP_SNMP, GROUP_SNMP, null, "Error calculate: " + this.m_calcLines.get(i) + ". " + e.getMessage(), "warning", null);
            }
            ++i;
        }
    }

    public double calculateLine(Map<String, String> values, String calcLine) throws ArithmeticException {
        double result;
        HashMap<String, Double> valuesAndCalculatedObjects = new HashMap<String, Double>();
        for (String variableName : values.keySet()) {
            String variableValue = values.get(variableName);
            if (variableValue == null) continue;
            try {
                valuesAndCalculatedObjects.put(variableName, Double.valueOf(variableValue));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            Expression e = new OpmExpressionBuilder(calcLine).variables(valuesAndCalculatedObjects.keySet()).build().setVariables(valuesAndCalculatedObjects);
            result = e.evaluate();
        }
        catch (ArithmeticException t) {
            throw t;
        }
        catch (Throwable t) {
            throw new SyntaxException(t);
        }
        return result;
    }

    public void setMessageSubmitter(IMessage submitter) {
        this.m_msgSubmitter = submitter;
    }

    public void stop() {
    }

    public void setInterval(long ms) {
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
        this.m_submitter = submitter;
    }

    public static void main(String[] args) {
        String[] t201 = new String[]{"-h kapellestraat.bes-intern.com", "-o .1.3.6.1.2.1.25.2.2.0", "-p 161", "-t 5", "-r 1", "-v 3", "-Xu boomsnmp", "-Xa MD5", "-Xs boomsnmp", "-Xt DES", "-Xp boomsnmp", "-notTable"};
        SNMPWalkMonitor snmpw201 = (SNMPWalkMonitor)SNMPWalkMonitor.getInstance("MONNAME", t201);
        snmpw201.setMessageSubmitter((IMessage)new NullMsgSubmitter());
        snmpw201.setMonitorSubmitter((IMonitorSubmitter)new NullMonSubmitter());
        snmpw201.runMonitor();
        t201 = new String[]{"-h kapellestraat.bes-intern.com", "-o .1.3.6.1.2.1.25.2.2", "-p 161", "-t 5", "-r 1", "-v 3", "-Xu boomsnmp", "-Xa MD5", "-Xs boomsnmp", "-Xt DES", "-Xp boomsnmp", "-notTable", "MEMORY = $0"};
        snmpw201 = (SNMPWalkMonitor)SNMPWalkMonitor.getInstance("MONNAMENT", t201);
        snmpw201.setMessageSubmitter((IMessage)new NullMsgSubmitter());
        snmpw201.setMonitorSubmitter((IMonitorSubmitter)new NullMonSubmitter());
        snmpw201.runMonitor();
        t201 = new String[]{"-h kapellestraat.bes-intern.com", "-o .1.3.6.1.2.1.25.2.2", "-p 161", "-t 5", "-r 1", "-v 3", "-Xu boomsnmp", "-Xa MD5", "-Xs boomsnmp", "-Xt DES", "-Xp boomsnmp", "MEMORY = ($0 / 1000)"};
        snmpw201 = (SNMPWalkMonitor)SNMPWalkMonitor.getInstance("MONNAME", t201);
        snmpw201.setMessageSubmitter((IMessage)new NullMsgSubmitter());
        snmpw201.setMonitorSubmitter((IMonitorSubmitter)new NullMonSubmitter());
        snmpw201.runMonitor();
        t201 = new String[]{"-h kapellestraat.bes-intern.com", "-o .1.3.6.1.2.1.25.2.2", "-p 161", "-t 5", "-r 1", "-v 3", "-Xu boomsnmp", "-Xa MD5", "-Xs boomsnmp", "-Xt DES", "-Xp boomsnmp", ""};
        snmpw201 = (SNMPWalkMonitor)SNMPWalkMonitor.getInstance("MONNAME", t201);
        snmpw201.setMessageSubmitter((IMessage)new NullMsgSubmitter());
        snmpw201.setMonitorSubmitter((IMonitorSubmitter)new NullMonSubmitter());
        snmpw201.runMonitor();
        System.exit(0);
        String[] t003 = new String[]{"-h 10.0.0.1", "-p 161", "-o .1.3.6.1.2.1.2.2.1", "-c public", "-r 2", "-t 10", "-v 2c", "$2_D DELTA $10 + $16", "$2_R = $2_D / $5"};
        SNMPWalkMonitor snmpw003 = (SNMPWalkMonitor)SNMPWalkMonitor.getInstance("MONNAME", t003);
        snmpw003.setMessageSubmitter((IMessage)new NullMsgSubmitter());
        snmpw003.setMonitorSubmitter((IMonitorSubmitter)new NullMonSubmitter());
        String out003 = snmpw003.runMonitor();
        System.out.println(out003);
        System.exit(0);
        t003 = new String[]{"-h 192.168.123.5", "-p 161", "-get .1.3.6.1.2.1.43.6.1.1.2.1.1", "-c public", "-r 2", "-t 10", "-v 1"};
        snmpw003 = (SNMPWalkMonitor)SNMPWalkMonitor.getInstance("MONNAME", t003);
        snmpw003.setMessageSubmitter((IMessage)new NullMsgSubmitter());
        snmpw003.setMonitorSubmitter((IMonitorSubmitter)new NullMonSubmitter());
        out003 = snmpw003.runMonitor();
        System.exit(0);
        String[] arr = new String[]{"-h 15.124.140.144", "-o .1.3.6.1.2.1.43.11.1.1", "$6 = $9 / $8 * 100"};
        SNMPWalkMonitor snmpw = (SNMPWalkMonitor)SNMPWalkMonitor.getInstance("TONER", arr);
        snmpw.setMessageSubmitter((IMessage)new NullMsgSubmitter());
        snmpw.setMonitorSubmitter((IMonitorSubmitter)new NullMonSubmitter());
        String out = snmpw.runMonitor();
        arr = new String[]{"-h 15.124.140.144", "-o .1.3.6.1.2.1.43.10.2.1.4.1"};
        snmpw = (SNMPWalkMonitor)SNMPWalkMonitor.getInstance("STATUS", arr);
        snmpw.setMessageSubmitter((IMessage)new NullMsgSubmitter());
        snmpw.setMonitorSubmitter((IMonitorSubmitter)new NullMonSubmitter());
        out = snmpw.runMonitor();
        arr = new String[]{"-h 15.124.140.144", "-o .1.3.6.1.2.1.43.8.2.1", "$13 = $11"};
        snmpw = (SNMPWalkMonitor)SNMPWalkMonitor.getInstance("TrayStatus", arr);
        snmpw.setMessageSubmitter((IMessage)new NullMsgSubmitter());
        snmpw.setMonitorSubmitter((IMonitorSubmitter)new NullMonSubmitter());
        out = snmpw.runMonitor();
        arr = new String[]{"-h blixx22", "-o .1.3.6.1.2.1.4.20.1", "-t 2", "-r 3", "-v 2c", "-c public"};
        snmpw = (SNMPWalkMonitor)SNMPWalkMonitor.getInstance("Win1", arr);
        snmpw.setMessageSubmitter((IMessage)new NullMsgSubmitter());
        snmpw.setMonitorSubmitter((IMonitorSubmitter)new NullMonSubmitter());
        out = snmpw.runMonitor();
        arr = new String[]{"-h localhost", "-o .1.3.6.1.2.1.11.28", "-v 3", "-c public", "-Xu boris", "-Xa MD5", "-Xs Markaba99", "-Xt DES", "-Xp Markaba99"};
        snmpw = (SNMPWalkMonitor)SNMPWalkMonitor.getInstance("SNMPCount", arr);
        snmpw.setMessageSubmitter((IMessage)new NullMsgSubmitter());
        snmpw.setMonitorSubmitter((IMonitorSubmitter)new NullMonSubmitter());
        out = snmpw.runMonitor();
        arr = new String[]{"-h localhost", "-o .1.3.6.1.2.1.11.28.0", "-v 3", "-c public", "-Xu boris", "-Xa MD5", "-Xs Markaba99", "-Xt DES", "-Xp Markaba99"};
        snmpw = (SNMPWalkMonitor)SNMPWalkMonitor.getInstance("SNMPCount0", arr);
        snmpw.setMessageSubmitter((IMessage)new NullMsgSubmitter());
        snmpw.setMonitorSubmitter((IMonitorSubmitter)new NullMonSubmitter());
        out = snmpw.runMonitor();
    }

    class WalkCounts {
        public int requests;
        public int objects;

        WalkCounts() {
        }
    }
}

